/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi.remote;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.infinispan.cdi.common.util.Reflections;
import org.infinispan.cdi.remote.Remote;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;

@ApplicationScoped
public class RemoteCacheProducer {
    @Inject
    private RemoteCacheManager defaultRemoteCacheManager;
    @Any
    @Inject
    private Instance<RemoteCacheManager> cacheManagers;

    @Remote
    @Produces
    public <K, V> RemoteCache<K, V> getRemoteCache(InjectionPoint injectionPoint) {
        Set qualifiers = injectionPoint.getQualifiers();
        RemoteCacheManager cacheManager = this.getRemoteCacheManager(qualifiers.toArray(new Annotation[0]));
        Remote remote = this.getRemoteAnnotation(injectionPoint.getAnnotated());
        if (remote != null && !remote.value().isEmpty()) {
            return cacheManager.getCache(remote.value());
        }
        return cacheManager.getCache();
    }

    private RemoteCacheManager getRemoteCacheManager(Annotation[] qualifiers) {
        Instance specificCacheManager = this.cacheManagers.select(qualifiers);
        if (specificCacheManager.isUnsatisfied()) {
            return this.defaultRemoteCacheManager;
        }
        return (RemoteCacheManager)specificCacheManager.get();
    }

    private Remote getRemoteAnnotation(Annotated annotated) {
        Remote remote = (Remote)annotated.getAnnotation(Remote.class);
        if (remote == null) {
            remote = (Remote)Reflections.getMetaAnnotation((Annotated)annotated, Remote.class);
        }
        return remote;
    }
}

