/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.mgmt.UndertowHttpManagementService;
import org.jboss.as.server.suspend.SuspendController;
import org.jboss.as.web.host.CommonWebServer;
import org.jboss.as.web.host.WebHost;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.requestcontroller.RequestController;
import org.wildfly.extension.undertow.ConsoleRedirectService;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.HostDefinition;
import org.wildfly.extension.undertow.Server;
import org.wildfly.extension.undertow.ServerDefinition;
import org.wildfly.extension.undertow.UndertowRootDefinition;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.WebHostService;
import org.wildfly.extension.undertow.deployment.DefaultDeploymentMappingProvider;

final class HostAdd
extends AbstractAddStepHandler {
    static final HostAdd INSTANCE = new HostAdd();

    private HostAdd() {
        super(HostDefinition.ATTRIBUTES);
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        super.recordCapabilitiesAndRequirements(context, operation, resource);
        String ourCap = HostDefinition.HOST_CAPABILITY.getDynamicName(context.getCurrentAddress());
        String serverCap = ServerDefinition.SERVER_CAPABILITY.getDynamicName(context.getCurrentAddress().getParent());
        context.registerAdditionalCapabilityRequirement(serverCap, ourCap, null);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        Consumer hostConsumer;
        PathAddress address = context.getCurrentAddress();
        PathAddress serverAddress = address.getParent();
        PathAddress subsystemAddress = serverAddress.getParent();
        ModelNode subsystemModel = Resource.Tools.readModel((Resource)context.readResourceFromRoot(subsystemAddress, false), (int)0);
        ModelNode serverModel = Resource.Tools.readModel((Resource)context.readResourceFromRoot(serverAddress, false), (int)0);
        String name = address.getLastElement().getValue();
        List aliases = HostDefinition.ALIAS.unwrap((ExpressionResolver)context, model);
        String defaultWebModule = HostDefinition.DEFAULT_WEB_MODULE.resolveModelAttribute(context, model).asString();
        String defaultServerName = UndertowRootDefinition.DEFAULT_SERVER.resolveModelAttribute(context, subsystemModel).asString();
        String defaultHostName = ServerDefinition.DEFAULT_HOST.resolveModelAttribute(context, serverModel).asString();
        String serverName = serverAddress.getLastElement().getValue();
        boolean isDefaultHost = defaultServerName.equals(serverName) && name.equals(defaultHostName);
        int defaultResponseCode = HostDefinition.DEFAULT_RESPONSE_CODE.resolveModelAttribute(context, model).asInt();
        boolean enableConsoleRedirect = !HostDefinition.DISABLE_CONSOLE_REDIRECT.resolveModelAttribute(context, model).asBoolean();
        Boolean queueRequestsOnStart = null;
        if (model.hasDefined(HostDefinition.QUEUE_REQUESTS_ON_START.getName())) {
            queueRequestsOnStart = HostDefinition.QUEUE_REQUESTS_ON_START.resolveModelAttribute(context, model).asBoolean();
        }
        if (!defaultWebModule.equals("ROOT.war") || DefaultDeploymentMappingProvider.instance().getMapping("ROOT.war") == null) {
            DefaultDeploymentMappingProvider.instance().addMapping(defaultWebModule, serverName, name);
        }
        ServiceName virtualHostServiceName = HostDefinition.HOST_CAPABILITY.fromBaseCapability(address).getCapabilityServiceName();
        CapabilityServiceBuilder csb = context.getCapabilityServiceTarget().addCapability(HostDefinition.HOST_CAPABILITY);
        if (isDefaultHost) {
            this.addCommonHost(context, aliases, serverName, virtualHostServiceName);
            RuntimeCapability[] capabilitiesParam = new RuntimeCapability[]{HostDefinition.HOST_CAPABILITY};
            ServiceName[] serviceNamesParam = new ServiceName[]{UndertowService.virtualHostName(serverName, name), UndertowService.DEFAULT_HOST};
            hostConsumer = csb.provides(capabilitiesParam, serviceNamesParam);
        } else {
            hostConsumer = csb.provides(HostDefinition.HOST_CAPABILITY, UndertowService.virtualHostName(serverName, name), new ServiceName[0]);
        }
        Supplier sSupplier = csb.requiresCapability("org.wildfly.undertow.server", Server.class, new String[]{serverName});
        Supplier usSupplier = csb.requiresCapability("org.wildfly.undertow", UndertowService.class, new String[0]);
        Supplier cpssSupplier = csb.requires(ControlledProcessStateService.SERVICE_NAME);
        Supplier scSupplier = csb.requires(context.getCapabilityServiceName("org.wildfly.server.suspend-controller", SuspendController.class));
        csb.setInstance((Service)new Host(hostConsumer, sSupplier, usSupplier, cpssSupplier, scSupplier, name, aliases == null ? new LinkedList() : aliases, defaultWebModule, defaultResponseCode, queueRequestsOnStart));
        csb.setInitialMode(ServiceController.Mode.ON_DEMAND);
        csb.install();
        if (enableConsoleRedirect) {
            ServiceName consoleRedirectName = UndertowService.consoleRedirectServiceName(serverName, name);
            if (context.getProcessType() == ProcessType.STANDALONE_SERVER) {
                ServiceBuilder sb = context.getServiceTarget().addService(consoleRedirectName);
                Supplier hmSupplier = sb.requires(UndertowHttpManagementService.SERVICE_NAME);
                Supplier hSupplier = sb.requires(virtualHostServiceName);
                sb.setInstance((Service)new ConsoleRedirectService(hmSupplier, hSupplier));
                sb.setInitialMode(ServiceController.Mode.PASSIVE);
                sb.install();
            } else {
                ServiceBuilder sb = context.getServiceTarget().addService(consoleRedirectName);
                Supplier hSupplier = sb.requires(virtualHostServiceName);
                sb.setInstance((Service)new ConsoleRedirectService(null, hSupplier));
                sb.setInitialMode(ServiceController.Mode.PASSIVE);
                sb.install();
            }
        }
    }

    private void addCommonHost(OperationContext context, List<String> aliases, String serverName, ServiceName virtualHostServiceName) {
        RuntimeCapability[] capabilitiesParam = new RuntimeCapability[]{WebHost.CAPABILITY};
        ServiceName[] serviceNamesParam = new ServiceName[aliases == null ? 1 : aliases.size() + 1];
        if (aliases != null) {
            int i = 0;
            for (String alias : aliases) {
                serviceNamesParam[i++] = WebHost.SERVICE_NAME.append(new String[]{alias});
            }
        }
        serviceNamesParam[serviceNamesParam.length - 1] = WebHost.SERVICE_NAME.append(new String[]{context.getCurrentAddressValue()});
        boolean rqCapabilityAvailable = context.hasOptionalCapability("org.wildfly.request-controller", null, null);
        CapabilityServiceBuilder sb = context.getCapabilityServiceTarget().addCapability(WebHost.CAPABILITY);
        Consumer whConsumer = sb.provides(capabilitiesParam, serviceNamesParam);
        Supplier sSupplier = sb.requiresCapability("org.wildfly.undertow.server", Server.class, new String[]{serverName});
        Supplier hSupplier = sb.requires(virtualHostServiceName);
        Supplier rcSupplier = rqCapabilityAvailable ? sb.requiresCapability("org.wildfly.request-controller", RequestController.class, new String[0]) : null;
        sb.setInstance((Service)new WebHostService(whConsumer, sSupplier, hSupplier, rcSupplier));
        sb.requiresCapability("org.wildfly.web.common.server", CommonWebServer.class, new String[0]);
        sb.setInitialMode(ServiceController.Mode.PASSIVE);
        sb.install();
    }
}

