/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.server.HttpHandler;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import jakarta.servlet.ServletException;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.web.common.StartupContext;
import org.jboss.as.web.common.WebInjectionContainer;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.ServletContainerService;
import org.wildfly.extension.undertow.logging.UndertowLogger;

public class UndertowDeploymentService
implements Service<UndertowDeploymentService> {
    private final Consumer<UndertowDeploymentService> serviceConsumer;
    private final Supplier<ServletContainerService> container;
    private final Supplier<ExecutorService> serverExecutor;
    private final Supplier<Host> host;
    private final Supplier<DeploymentInfo> deploymentInfo;
    private final WebInjectionContainer webInjectionContainer;
    private final boolean autostart;
    private volatile DeploymentManager deploymentManager;

    UndertowDeploymentService(Consumer<UndertowDeploymentService> serviceConsumer, Supplier<ServletContainerService> container, Supplier<ExecutorService> serverExecutor, Supplier<Host> host, Supplier<DeploymentInfo> deploymentInfo, WebInjectionContainer webInjectionContainer, boolean autostart) {
        this.serviceConsumer = serviceConsumer;
        this.container = container;
        this.serverExecutor = serverExecutor;
        this.host = host;
        this.deploymentInfo = deploymentInfo;
        this.webInjectionContainer = webInjectionContainer;
        this.autostart = autostart;
    }

    public void start(final StartContext startContext) throws StartException {
        if (this.autostart) {
            startContext.asynchronous();
            this.serverExecutor.get().submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        UndertowDeploymentService.this.startContext();
                        startContext.complete();
                    }
                    catch (Throwable e) {
                        startContext.failed(new StartException(e));
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startContext() throws ServletException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        DeploymentInfo deploymentInfo = this.deploymentInfo.get();
        Thread.currentThread().setContextClassLoader(deploymentInfo.getClassLoader());
        try {
            StartupContext.setInjectionContainer((WebInjectionContainer)this.webInjectionContainer);
            try {
                this.deploymentManager = this.container.get().getServletContainer().addDeployment(deploymentInfo);
                this.deploymentManager.deploy();
                HttpHandler handler = this.deploymentManager.start();
                Deployment deployment = this.deploymentManager.getDeployment();
                this.host.get().registerDeployment(deployment, handler);
            }
            catch (Throwable e) {
                this.deploymentManager.undeploy();
                this.container.get().getServletContainer().removeDeployment(deploymentInfo);
                throw e;
            }
            finally {
                StartupContext.setInjectionContainer(null);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
            this.serviceConsumer.accept(this);
        }
    }

    public void stop(final StopContext stopContext) {
        stopContext.asynchronous();
        this.serverExecutor.get().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    UndertowDeploymentService.this.stopContext();
                }
                finally {
                    stopContext.complete();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopContext() {
        this.serviceConsumer.accept(null);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        DeploymentInfo deploymentInfo = this.deploymentInfo.get();
        Thread.currentThread().setContextClassLoader(deploymentInfo.getClassLoader());
        try {
            if (this.deploymentManager != null) {
                Deployment deployment = this.deploymentManager.getDeployment();
                try {
                    this.host.get().unregisterDeployment(deployment);
                    this.deploymentManager.stop();
                }
                catch (ServletException e) {
                    throw new RuntimeException(e);
                }
                this.deploymentManager.undeploy();
                this.container.get().getServletContainer().removeDeployment(deploymentInfo);
            }
            UndertowDeploymentService.recursiveDelete(deploymentInfo.getTempDir());
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public UndertowDeploymentService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public DeploymentInfo getDeploymentInfo() {
        return this.deploymentInfo.get();
    }

    public Deployment getDeployment() {
        if (this.deploymentManager != null) {
            return this.deploymentManager.getDeployment();
        }
        return null;
    }

    private static void recursiveDelete(File file) {
        if (file == null) {
            return;
        }
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                UndertowDeploymentService.recursiveDelete(f);
            }
        }
        if (!file.delete()) {
            UndertowLogger.ROOT_LOGGER.couldNotDeleteTempFile(file);
        }
    }
}

