/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories.threads;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.infinispan.security.Security;

final class SecurityActions {
    SecurityActions() {
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return Security.doPrivileged(action);
    }

    static void setContextClassLoader(Thread thread, ClassLoader contextClassLoader) {
        SecurityActions.doPrivileged(() -> {
            thread.setContextClassLoader(contextClassLoader);
            return null;
        });
    }
}

