/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.sort.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.AbstractElasticsearchReversibleSort;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortCollector;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.engine.search.sort.spi.ScoreSortBuilder;

class ElasticsearchScoreSort
extends AbstractElasticsearchReversibleSort {
    private static final String SCORE_SORT_KEYWORD = "_score";
    private static final JsonPrimitive SCORE_SORT_KEYWORD_JSON = new JsonPrimitive("_score");

    ElasticsearchScoreSort(Builder builder) {
        super(builder);
    }

    @Override
    public void doToJsonSorts(ElasticsearchSearchSortCollector collector, JsonObject innerObject) {
        if (innerObject.size() == 0) {
            collector.collectSort((JsonElement)SCORE_SORT_KEYWORD_JSON);
        } else {
            JsonObject outerObject = new JsonObject();
            outerObject.add(SCORE_SORT_KEYWORD, (JsonElement)innerObject);
            collector.collectSort((JsonElement)outerObject);
        }
    }

    static class Builder
    extends AbstractElasticsearchReversibleSort.AbstractBuilder
    implements ScoreSortBuilder {
        Builder(ElasticsearchSearchIndexScope<?> scope) {
            super(scope);
        }

        public SearchSort build() {
            return new ElasticsearchScoreSort(this);
        }
    }
}

