/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.version;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.EnumSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Manifest;
import org.jboss.as.version.Stability;
import org.jboss.as.version.Version;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;

public class ProductConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String version;
    private final String consoleSlot;
    private final Stability defaultStability;
    private final Set<Stability> stabilities;
    private boolean isProduct;

    public static ProductConfig fromFilesystemSlot(ModuleLoader loader, String home, Map<?, ?> providedProperties) {
        return new ProductConfig(loader, ProductConfig.getProductConfProperties(home), providedProperties);
    }

    public static ProductConfig fromKnownSlot(String slot, ModuleLoader loader, Map<?, ?> providedProperties) {
        return new ProductConfig(loader, new ProductConfProps(slot), providedProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProductConfig(ModuleLoader loader, ProductConfProps productConfProps, Map<?, ?> providedProperties) {
        String productName = null;
        String projectName = null;
        String productVersion = null;
        String consoleSlot = null;
        Stability defaultStability = Stability.COMMUNITY;
        Stability minStability = Stability.EXPERIMENTAL;
        Stability maxStability = Stability.DEFAULT;
        InputStream manifestStream = null;
        try {
            if (productConfProps.productModuleId != null) {
                Module module = loader.loadModule(productConfProps.productModuleId);
                manifestStream = module.getClassLoader().getResourceAsStream("META-INF/MANIFEST.MF");
                Manifest manifest = null;
                if (manifestStream != null) {
                    manifest = new Manifest(manifestStream);
                }
                if (manifest != null) {
                    String minStabilityValue;
                    productName = manifest.getMainAttributes().getValue("JBoss-Product-Release-Name");
                    productVersion = manifest.getMainAttributes().getValue("JBoss-Product-Release-Version");
                    consoleSlot = manifest.getMainAttributes().getValue("JBoss-Product-Console-Slot");
                    projectName = manifest.getMainAttributes().getValue("JBoss-Project-Release-Name");
                    String defaultStabilityValue = manifest.getMainAttributes().getValue("JBoss-Product-Stability");
                    if (defaultStabilityValue != null) {
                        defaultStability = Stability.fromString(defaultStabilityValue);
                    }
                    if ((minStabilityValue = manifest.getMainAttributes().getValue("JBoss-Product-Minimum-Stability")) != null) {
                        minStability = Stability.fromString(minStabilityValue);
                    }
                }
            }
            this.setSystemProperties(productConfProps.miscProperties, providedProperties);
        }
        catch (Exception exception) {
        }
        finally {
            ProductConfig.safeClose(manifestStream);
        }
        this.isProduct = productName != null && !productName.isEmpty() && projectName == null;
        this.name = this.isProduct ? productName : projectName;
        this.version = productVersion;
        this.consoleSlot = consoleSlot;
        this.defaultStability = defaultStability;
        this.stabilities = EnumSet.range(maxStability, minStability);
    }

    private static String getProductConf(String home) {
        final String defaultVal = home + File.separator + "bin" + File.separator + "product.conf";
        PrivilegedAction<String> action = new PrivilegedAction<String>(){

            @Override
            public String run() {
                String env = System.getenv("JBOSS_PRODUCT_CONF");
                if (env == null) {
                    env = defaultVal;
                }
                return env;
            }
        };
        return System.getSecurityManager() == null ? (String)action.run() : AccessController.doPrivileged(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ProductConfProps getProductConfProperties(String home) {
        Properties props = new Properties();
        BufferedReader reader = null;
        try {
            reader = Files.newBufferedReader(Paths.get(ProductConfig.getProductConf(home), new String[0]), StandardCharsets.UTF_8);
            props.load(reader);
        }
        catch (Exception exception) {
            ProductConfig.safeClose(reader);
        }
        catch (Throwable throwable) {
            ProductConfig.safeClose(reader);
            throw throwable;
        }
        ProductConfig.safeClose(reader);
        return new ProductConfProps(props);
    }

    public ProductConfig(String productName, String productVersion, String consoleSlot) {
        this.name = productName;
        this.version = productVersion;
        this.consoleSlot = consoleSlot;
        this.defaultStability = Stability.DEFAULT;
        this.stabilities = EnumSet.of(this.defaultStability);
    }

    public String getProductName() {
        return this.name;
    }

    public String getProductVersion() {
        return this.version;
    }

    public boolean isProduct() {
        return this.isProduct;
    }

    public String getConsoleSlot() {
        return this.consoleSlot;
    }

    public Stability getDefaultStability() {
        return this.defaultStability;
    }

    public Set<Stability> getStabilitySet() {
        return this.stabilities;
    }

    public String getPrettyVersionString() {
        if (this.name != null) {
            return String.format("%s %s (WildFly Core %s)", this.name, this.version, Version.AS_VERSION);
        }
        if ("".equals(Version.AS_RELEASE_CODENAME)) {
            return String.format("WildFly Core %s", Version.AS_VERSION);
        }
        return String.format("WildFly Core %s \"%s\"", Version.AS_VERSION, Version.AS_RELEASE_CODENAME);
    }

    public String resolveVersion() {
        return this.version != null ? this.version : Version.AS_VERSION;
    }

    public String resolveName() {
        return this.name != null ? this.name : "WildFly";
    }

    public static String getPrettyVersionString(String name, String version1, String version2) {
        if (name != null) {
            return String.format("JBoss %s %s (WildFly %s)", name, version1, version2);
        }
        return String.format("WildFly %s \"%s\"", version1, version2);
    }

    private void setSystemProperties(final Properties propConfProps, final Map providedProperties) {
        if (propConfProps.size() == 0) {
            return;
        }
        PrivilegedAction<Void> action = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                for (Map.Entry<Object, Object> entry : propConfProps.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("slot") || System.getProperty(key) != null) continue;
                    System.setProperty(key, (String)entry.getValue());
                    providedProperties.put(key, entry.getValue());
                }
                return null;
            }
        };
        if (System.getSecurityManager() == null) {
            action.run();
        } else {
            AccessController.doPrivileged(action);
        }
    }

    private static void safeClose(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static class ProductConfProps {
        private final Properties miscProperties;
        private final ModuleIdentifier productModuleId;

        private ProductConfProps(String slot) {
            this.productModuleId = slot == null ? null : ModuleIdentifier.create("org.jboss.as.product", slot);
            this.miscProperties = new Properties();
        }

        private ProductConfProps(Properties properties) {
            this(properties.getProperty("slot"));
            if (this.productModuleId != null) {
                properties.remove("slot");
            }
            if (!properties.isEmpty()) {
                for (String key : properties.stringPropertyNames()) {
                    this.miscProperties.setProperty(key, properties.getProperty(key));
                }
            }
        }
    }
}

