/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.vfs.VFSMessages;
import org.jboss.vfs.VirtualFile;

public class VFSMessages_$bundle
implements VFSMessages,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final VFSMessages_$bundle INSTANCE = new VFSMessages_$bundle();
    private static final Locale LOCALE = Locale.ROOT;

    protected VFSMessages_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String cantSetupTempFileProvider$str() {
        return "VFS000010: Can't set up temp file provider";
    }

    @Override
    public final RuntimeException cantSetupTempFileProvider(Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.cantSetupTempFileProvider$str(), new Object[0]), cause);
        VFSMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String tempDirectoryClosed$str() {
        return "VFS000011: Temp directory closed";
    }

    @Override
    public final IOException tempDirectoryClosed() {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.tempDirectoryClosed$str(), new Object[0]));
        VFSMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String tempFileProviderClosed$str() {
        return "VFS000012: Temp file provider closed";
    }

    @Override
    public final IOException tempFileProviderClosed() {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.tempFileProviderClosed$str(), new Object[0]));
        VFSMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotCreateDirectoryForRoot$str() {
        return "VFS000014: Could not create directory for root '%s' (prefix '%s', suffix '%s') after %d attempts";
    }

    @Override
    public final IOException couldNotCreateDirectoryForRoot(File root, String prefix, String suffix, int retries) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.couldNotCreateDirectoryForRoot$str(), root, prefix, suffix, retries));
        VFSMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotCreateDirectory$str() {
        return "VFS000015: Could not create directory for original name '%s' after %d attempts";
    }

    @Override
    public final IOException couldNotCreateDirectory(String originalName, int retries) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.couldNotCreateDirectory$str(), originalName, retries));
        VFSMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String rootFileSystemAlreadyMounted$str() {
        return "VFS000016: Root filesystem already mounted";
    }

    @Override
    public final IOException rootFileSystemAlreadyMounted() {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.rootFileSystemAlreadyMounted$str(), new Object[0]));
        VFSMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String fileSystemAlreadyMountedAtMountPoint$str() {
        return "VFS000017: Filesystem already mounted at mount point \"%s\"";
    }

    @Override
    public final IOException fileSystemAlreadyMountedAtMountPoint(VirtualFile mountPoint) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.fileSystemAlreadyMountedAtMountPoint$str(), mountPoint));
        VFSMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String streamIsClosed$str() {
        return "VFS000018: Stream is closed";
    }

    @Override
    public final IOException streamIsClosed() {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.streamIsClosed$str(), new Object[0]));
        VFSMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notAFile$str() {
        return "VFS000019: Not a file: '%s'";
    }

    @Override
    public final IOException notAFile(String path) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.notAFile$str(), path));
        VFSMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String remoteHostAccessNotSupportedForUrls$str() {
        return "VFS000020: Remote host access not supported for URLs of type '%s'";
    }

    @Override
    public final IOException remoteHostAccessNotSupportedForUrls(String protocol) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.remoteHostAccessNotSupportedForUrls$str(), protocol));
        VFSMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullArgument$str() {
        return "VFS000021: %s must not be null";
    }

    @Override
    public final IllegalArgumentException nullArgument(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullArgument$str(), name));
        VFSMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullOrEmpty$str() {
        return "VFS000022: Null or empty %s";
    }

    @Override
    public final IllegalArgumentException nullOrEmpty(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullOrEmpty$str(), name));
        VFSMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String parentIsNotAncestor$str() {
        return "VFS000023: Given parent (%s) is not an ancestor of this virtual file";
    }

    @Override
    public final IllegalArgumentException parentIsNotAncestor(VirtualFile parent) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.parentIsNotAncestor$str(), parent));
        VFSMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String problemCreatingNewDirectory$str() {
        return "VFS000024: Problems creating new directory: %s";
    }

    @Override
    public final IllegalArgumentException problemCreatingNewDirectory(VirtualFile targetChild) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.problemCreatingNewDirectory$str(), targetChild));
        VFSMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidWin32Path$str() {
        return "VFS000025: Invalid Win32 path: %s";
    }

    @Override
    public final IllegalArgumentException invalidWin32Path(String path) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidWin32Path$str(), path));
        VFSMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotDecode$str() {
        return "VFS000026: Cannot decode: %s [%s]";
    }

    @Override
    public final IllegalArgumentException cannotDecode(String path, String encoding, Exception e) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotDecode$str(), path, encoding), e);
        VFSMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidJarSignature$str() {
        return "VFS000027: Invalid jar signature %s should be %s";
    }

    @Override
    public final IOException invalidJarSignature(String bytes, String expectedHeader) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.invalidJarSignature$str(), bytes, expectedHeader));
        VFSMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidActionsString$str() {
        return "VFS000028: Invalid actions string: %s";
    }

    @Override
    public final IllegalArgumentException invalidActionsString(String actions) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidActionsString$str(), actions));
        VFSMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String bufferMustBeLargerThan$str() {
        return "VFS000029: The totalBufferLength must be larger than: %s";
    }

    @Override
    public final IllegalArgumentException bufferMustBeLargerThan(int minimumBufferLength) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.bufferMustBeLargerThan$str(), minimumBufferLength));
        VFSMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String bufferDoesntHaveEnoughCapacity$str() {
        return "VFS000030: Buffer does not have enough capacity";
    }

    @Override
    public final IllegalArgumentException bufferDoesntHaveEnoughCapacity() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.bufferDoesntHaveEnoughCapacity$str(), new Object[0]));
        VFSMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String preconfiguredAttributesAreImmutable$str() {
        return "VFS000031: The preconfigured attributes are immutable";
    }

    @Override
    public final IllegalStateException preconfiguredAttributesAreImmutable() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.preconfiguredAttributesAreImmutable$str(), new Object[0]));
        VFSMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String onRootPath$str() {
        return "VFS000032: .. on root path";
    }

    @Override
    public final IllegalStateException onRootPath() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.onRootPath$str(), new Object[0]));
        VFSMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }
}

