/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli;

import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.activemq.artemis.cli.Artemis;
import org.apache.activemq.artemis.cli.Terminal;
import org.apache.activemq.artemis.cli.commands.Connect;
import org.jline.console.CommandRegistry;
import org.jline.console.impl.SystemRegistryImpl;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.MaskingCallback;
import org.jline.reader.Parser;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.DefaultParser;
import org.jline.terminal.TerminalBuilder;
import picocli.CommandLine;
import picocli.shell.jline3.PicocliCommands;

@CommandLine.Command(name="shell", description={"JLine3 shell helping using the CLI"})
public class Shell
implements Runnable {
    @CommandLine.Option(names={"--url"}, description={"It will be used for an initial connection if set."})
    protected String brokerURL = "tcp://localhost:61616";
    @CommandLine.Option(names={"--user"}, description={"It will be used for an initial connection if set."})
    protected String user;
    @CommandLine.Option(names={"--password"}, description={"It will be used for an initial connection if set."})
    protected String password;
    private static ThreadLocal<AtomicBoolean> IN_SHELL = ThreadLocal.withInitial(() -> new AtomicBoolean(false));

    public Shell(CommandLine commandLine) {
    }

    @Override
    public void run() {
        Shell.setInShell();
        Shell.printBanner();
        if (this.brokerURL != "tcp://localhost:61616" || this.user != null || this.password != null) {
            Connect connect = new Connect();
            connect.setUser(this.user).setPassword(this.password).setBrokerURL(this.brokerURL);
            connect.run();
        }
        Shell.runShell(false);
    }

    public static boolean inShell() {
        return IN_SHELL.get().get();
    }

    public static void setInShell() {
        IN_SHELL.get().set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void runShell(boolean printBanner) {
        block21: {
            Shell.setInShell();
            isInstance = System.getProperty("artemis.instance") != null;
            workDir = (Supplier<Path>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$runShell$1(), ()Ljava/nio/file/Path;)();
            factory = new PicocliCommands.PicocliCommandsFactory();
            commandLine = Artemis.buildCommand(isInstance, isInstance == false, true);
            picocliCommands = new PicocliCommands(commandLine);
            parser = new DefaultParser();
            terminal = TerminalBuilder.terminal();
            systemRegistry = new SystemRegistryImpl((Parser)parser, terminal, workDir, null);
            systemRegistry.setCommandRegistries(new CommandRegistry[]{picocliCommands});
            systemRegistry.register("help", (CommandRegistry)picocliCommands);
            reader = LineReaderBuilder.builder().terminal(terminal).completer(systemRegistry.completer()).parser((Parser)parser).variable("list-max", (Object)50).build();
            factory.setTerminal(terminal);
            prompt = Terminal.YELLOW_UNICODE + Artemis.getNameFromBanner() + " > " + Terminal.CLEAR_UNICODE;
            rightPrompt = null;
            if (printBanner) {
                Shell.printBanner();
            }
            System.out.println("For a list of commands, type " + Terminal.RED_UNICODE + "help" + Terminal.CLEAR_UNICODE + " or press " + Terminal.RED_UNICODE + "<TAB>" + Terminal.CLEAR_UNICODE + ":");
            System.out.println("Type " + Terminal.RED_UNICODE + "exit" + Terminal.CLEAR_UNICODE + " or press " + Terminal.RED_UNICODE + "<CTRL-D>" + Terminal.CLEAR_UNICODE + " to leave the session:");
            while (true) lbl-1000:
            // 4 sources

            {
                try {
                    while (true) {
                        systemRegistry.setCommandRegistries(new CommandRegistry[]{new PicocliCommands(Artemis.buildCommand(isInstance, isInstance == false, true))});
                        systemRegistry.cleanUp();
                        line = reader.readLine(prompt, rightPrompt, (MaskingCallback)null, null);
                        systemRegistry.execute(line);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (UserInterruptException e) {
                }
                catch (EndOfFileException e) {
                    if (terminal != null) {
                        terminal.close();
                    }
                    Shell.IN_SHELL.get().set(false);
                    return;
                }
                catch (Exception e) {
                    try {
                        try {
                            systemRegistry.trace((Throwable)e);
                            continue;
                        }
                        catch (Throwable var8_10) {
                            if (terminal != null) {
                                try {
                                    terminal.close();
                                }
                                catch (Throwable var9_12) {
                                    var8_10.addSuppressed(var9_12);
                                }
                            }
                            throw var8_10;
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        break block21;
                    }
                }
                break;
            }
            ** GOTO lbl-1000
            finally {
                Shell.IN_SHELL.get().set(false);
            }
        }
    }

    private static void printBanner() {
        System.out.print(Terminal.YELLOW_UNICODE);
        try {
            Artemis.printBanner(System.out);
        }
        catch (Exception e) {
            System.out.println("Error recovering the banner:");
            e.printStackTrace();
        }
        System.out.print(Terminal.CLEAR_UNICODE);
    }

    private static /* synthetic */ Path lambda$runShell$1() {
        return Paths.get(System.getProperty("user.dir"), new String[0]);
    }
}

