/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.backend.types.spi;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.engine.backend.metamodel.IndexObjectFieldTypeDescriptor;
import org.hibernate.search.engine.backend.types.ObjectStructure;
import org.hibernate.search.engine.search.common.spi.SearchIndexCompositeNodeContext;
import org.hibernate.search.engine.search.common.spi.SearchIndexCompositeNodeTypeContext;
import org.hibernate.search.engine.search.common.spi.SearchIndexScope;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementFactory;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementTypeKey;

public abstract class AbstractIndexCompositeNodeType<SC extends SearchIndexScope<?>, N extends SearchIndexCompositeNodeContext<SC>>
implements IndexObjectFieldTypeDescriptor,
SearchIndexCompositeNodeTypeContext<SC, N> {
    private final ObjectStructure objectStructure;
    private final Map<SearchQueryElementTypeKey<?>, SearchQueryElementFactory<?, ? super SC, ? super N>> queryElementFactories;

    protected AbstractIndexCompositeNodeType(Builder<SC, N> builder) {
        this.objectStructure = builder.objectStructure;
        this.queryElementFactories = builder.queryElementFactories;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[objectStructure=" + this.objectStructure + ", capabilities=" + this.queryElementFactories.keySet() + "]";
    }

    @Override
    public boolean nested() {
        switch (this.objectStructure) {
            case NESTED: {
                return true;
            }
        }
        return false;
    }

    @Override
    public final <T> SearchQueryElementFactory<? extends T, ? super SC, ? super N> queryElementFactory(SearchQueryElementTypeKey<T> key) {
        return this.queryElementFactories.get(key);
    }

    public static abstract class Builder<SC extends SearchIndexScope<?>, N extends SearchIndexCompositeNodeContext<SC>> {
        private final ObjectStructure objectStructure;
        private final Map<SearchQueryElementTypeKey<?>, SearchQueryElementFactory<?, ? super SC, ? super N>> queryElementFactories = new HashMap();

        public Builder(ObjectStructure objectStructure) {
            this.objectStructure = objectStructure;
        }

        public final <T> void queryElementFactory(SearchQueryElementTypeKey<T> key, SearchQueryElementFactory<? extends T, ? super SC, ? super N> factory) {
            this.queryElementFactories.put(key, factory);
        }

        public abstract AbstractIndexCompositeNodeType<SC, N> build();
    }
}

