/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import java.util.Collection;
import java.util.function.UnaryOperator;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.RestartParentResourceAddHandler;
import org.jboss.as.controller.RestartParentResourceRemoveHandler;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.undertow.CookieConfig;
import org.wildfly.extension.undertow.ServletContainerAdd;
import org.wildfly.extension.undertow.ServletContainerDefinition;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.UndertowSubsystemModel;

abstract class AbstractCookieDefinition
extends PersistentResourceDefinition {
    Collection<AttributeDefinition> attributes;

    public AbstractCookieDefinition(PathElement path, Collection<AttributeDefinition> attributes) {
        super(path, (ResourceDescriptionResolver)UndertowExtension.getResolver(path.getKeyValuePair()), (OperationStepHandler)new SessionCookieAdd(attributes), (OperationStepHandler)new SessionCookieRemove());
        this.attributes = attributes;
    }

    public Collection<AttributeDefinition> getAttributes() {
        return this.attributes;
    }

    static CookieConfig getConfig(Attribute nameAttribute, ExpressionResolver context, ModelNode model) throws OperationFailedException {
        if (!model.isDefined()) {
            return null;
        }
        ModelNode nameValue = nameAttribute.getDefinition().resolveModelAttribute(context, model);
        ModelNode domainValue = Attribute.DOMAIN.resolveModelAttribute(context, model);
        ModelNode secureValue = Attribute.SECURE.resolveModelAttribute(context, model);
        ModelNode httpOnlyValue = Attribute.HTTP_ONLY.resolveModelAttribute(context, model);
        ModelNode maxAgeValue = Attribute.MAX_AGE.resolveModelAttribute(context, model);
        String name = nameValue.isDefined() ? nameValue.asString() : null;
        String domain = domainValue.isDefined() ? domainValue.asString() : null;
        Boolean secure = secureValue.isDefined() ? Boolean.valueOf(secureValue.asBoolean()) : null;
        Boolean httpOnly = httpOnlyValue.isDefined() ? Boolean.valueOf(httpOnlyValue.asBoolean()) : null;
        Integer maxAge = maxAgeValue.isDefined() ? Integer.valueOf(maxAgeValue.asInt()) : null;
        return new CookieConfig(name, domain, httpOnly, secure, maxAge);
    }

    private static class SessionCookieAdd
    extends RestartParentResourceAddHandler {
        private final Collection<AttributeDefinition> attributes;

        protected SessionCookieAdd(Collection<AttributeDefinition> attributes) {
            super(ServletContainerDefinition.PATH_ELEMENT.getKey());
            this.attributes = attributes;
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition def : this.attributes) {
                def.validateAndSet(operation, model);
            }
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
            ServletContainerAdd.installRuntimeServices(context.getCapabilityServiceTarget(), (ExpressionResolver)context, parentAddress, parentModel);
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return ServletContainerDefinition.SERVLET_CONTAINER_CAPABILITY.getCapabilityServiceName(parentAddress);
        }
    }

    private static class SessionCookieRemove
    extends RestartParentResourceRemoveHandler {
        protected SessionCookieRemove() {
            super(ServletContainerDefinition.PATH_ELEMENT.getKey());
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
            ServletContainerAdd.installRuntimeServices(context.getCapabilityServiceTarget(), (ExpressionResolver)context, parentAddress, parentModel);
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return ServletContainerDefinition.SERVLET_CONTAINER_CAPABILITY.getCapabilityServiceName(parentAddress);
        }
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute
    {
        OPTIONAL_NAME("name", ModelType.STRING),
        REQUIRED_NAME("name", ModelType.STRING, ad -> (SimpleAttributeDefinitionBuilder)ad.setRequired(true)),
        DOMAIN("domain", ModelType.STRING),
        COMMENT("comment", ModelType.STRING, ad -> (SimpleAttributeDefinitionBuilder)ad.setDeprecated(UndertowSubsystemModel.VERSION_13_0_0.getVersion())),
        HTTP_ONLY("http-only", ModelType.BOOLEAN),
        SECURE("secure", ModelType.BOOLEAN),
        MAX_AGE("max-age", ModelType.INT);

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type) {
            this(name, type, UnaryOperator.identity());
        }

        private Attribute(String name, ModelType type, UnaryOperator<SimpleAttributeDefinitionBuilder> builder) {
            this.definition = ((SimpleAttributeDefinitionBuilder)builder.apply((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setRequired(false)).setRestartAllServices()).setAllowExpression(true))).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

