/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.LogManager;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.persistence.ConfigurationExtensionFactory;
import org.jboss.as.controller.persistence.ConfigurationFile;
import org.jboss.as.server.Bootstrap;
import org.jboss.as.server.CommandLineArgumentUsageImpl;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentWrapper;
import org.jboss.as.server.SystemExiter;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.version.ProductConfig;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.handlers.ConsoleHandler;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.stdio.LoggingOutputStream;
import org.jboss.stdio.NullInputStream;
import org.jboss.stdio.SimpleStdioContextSelector;
import org.jboss.stdio.StdioContext;
import org.jboss.stdio.StdioContextSelector;
import org.wildfly.security.manager.WildFlySecurityManager;

public final class Main {
    private static final PrintStream STDOUT = System.out;
    private static final PrintStream STDERR = System.err;

    private static void usage(ProductConfig productConfig) {
        CommandLineArgumentUsageImpl.printUsage(productConfig, STDOUT);
    }

    private Main() {
    }

    public static void main(String[] args) {
        try {
            if (LogManager.getLogManager().getClass().getName().equals("org.jboss.logmanager.LogManager")) {
                try {
                    Class.forName(ConsoleHandler.class.getName(), true, ConsoleHandler.class.getClassLoader());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                StdioContext.install();
                StdioContext context = StdioContext.create((InputStream)new NullInputStream(), (OutputStream)new LoggingOutputStream((java.util.logging.Logger)Logger.getLogger((String)"stdout"), (Level)org.jboss.logmanager.Level.INFO), (OutputStream)new LoggingOutputStream((java.util.logging.Logger)Logger.getLogger((String)"stderr"), (Level)org.jboss.logmanager.Level.ERROR));
                StdioContext.setStdioContextSelector((StdioContextSelector)new SimpleStdioContextSelector(context));
            }
            Module.registerURLStreamHandlerFactoryModule((Module)Module.getBootModuleLoader().loadModule("org.jboss.vfs"));
            ServerEnvironmentWrapper serverEnvironmentWrapper = Main.determineEnvironment(args, WildFlySecurityManager.getSystemPropertiesPrivileged(), WildFlySecurityManager.getSystemEnvironmentPrivileged(), ServerEnvironment.LaunchType.STANDALONE, Module.getStartTime());
            if (serverEnvironmentWrapper.getServerEnvironment() == null) {
                if (serverEnvironmentWrapper.getServerEnvironmentStatus() == ServerEnvironmentWrapper.ServerEnvironmentStatus.ERROR) {
                    Main.abort(null);
                } else {
                    SystemExiter.safeAbort();
                }
            } else {
                Bootstrap bootstrap = Bootstrap.Factory.newInstance();
                Bootstrap.Configuration configuration = new Bootstrap.Configuration(serverEnvironmentWrapper.getServerEnvironment());
                configuration.setModuleLoader(Module.getBootModuleLoader());
                bootstrap.bootstrap(configuration, Collections.emptyList()).get();
            }
        }
        catch (Throwable t) {
            Main.abort(t);
        }
    }

    private static void abort(Throwable t) {
        try {
            if (t != null) {
                t.printStackTrace(STDERR);
            }
        }
        finally {
            SystemExiter.abort(1);
        }
    }

    public static ServerEnvironmentWrapper determineEnvironment(String[] args, Properties systemProperties, Map<String, String> systemEnvironment, ServerEnvironment.LaunchType launchType, long startTime) {
        int argsLength = args.length;
        String serverConfig = null;
        String gitRepository = null;
        String gitBranch = "master";
        String gitAuthConfiguration = null;
        String supplementalConfiguration = null;
        RunningMode runningMode = RunningMode.NORMAL;
        ProductConfig productConfig = ProductConfig.fromFilesystemSlot((ModuleLoader)Module.getBootModuleLoader(), (String)WildFlySecurityManager.getPropertyPrivileged((String)"jboss.home.dir", null), null);
        ConfigurationFile.InteractionPolicy configInteractionPolicy = ConfigurationFile.InteractionPolicy.STANDARD;
        boolean startSuspended = false;
        boolean startGracefully = true;
        boolean removeConfig = false;
        boolean startModeSet = false;
        for (int i = 0; i < argsLength; ++i) {
            String arg = args[i];
            try {
                if ("--version".equals(arg) || "-v".equals(arg) || "-version".equals(arg) || "-V".equals(arg)) {
                    STDOUT.println(productConfig.getPrettyVersionString());
                    return new ServerEnvironmentWrapper(ServerEnvironmentWrapper.ServerEnvironmentStatus.NORMAL);
                }
                if ("--help".equals(arg) || "-h".equals(arg) || "-help".equals(arg)) {
                    Main.usage(productConfig);
                    return new ServerEnvironmentWrapper(ServerEnvironmentWrapper.ServerEnvironmentStatus.NORMAL);
                }
                if ("--server-config".equals(arg) || "-c".equals(arg) || "-server-config".equals(arg)) {
                    Main.assertSingleConfig(serverConfig);
                    serverConfig = args[++i];
                    continue;
                }
                if (arg.startsWith("--server-config")) {
                    Main.assertSingleConfig(serverConfig);
                    serverConfig = Main.parseValue(productConfig, arg, "--server-config");
                    if (serverConfig != null) continue;
                    return new ServerEnvironmentWrapper(ServerEnvironmentWrapper.ServerEnvironmentStatus.ERROR);
                }
                if (arg.startsWith("-c")) {
                    Main.assertSingleConfig(serverConfig);
                    serverConfig = Main.parseValue(productConfig, arg, "-c");
                    if (serverConfig != null) continue;
                    return new ServerEnvironmentWrapper(ServerEnvironmentWrapper.ServerEnvironmentStatus.ERROR);
                }
                if (arg.startsWith("--read-only-server-config")) {
                    Main.assertSingleConfig(serverConfig);
                    serverConfig = Main.parseValue(productConfig, arg, "--read-only-server-config");
                    if (serverConfig == null) {
                        return new ServerEnvironmentWrapper(ServerEnvironmentWrapper.ServerEnvironmentStatus.ERROR);
                    }
                    configInteractionPolicy = ConfigurationFile.InteractionPolicy.READ_ONLY;
                    continue;
                }
                if (arg.startsWith("-server-config")) {
                    serverConfig = Main.parseValue(productConfig, arg, "-server-config");
                    if (serverConfig != null) continue;
                    return new ServerEnvironmentWrapper(ServerEnvironmentWrapper.ServerEnvironmentStatus.ERROR);
                }
                if (arg.startsWith("--internal-empty-config")) {
                    assert (launchType == ServerEnvironment.LaunchType.EMBEDDED);
                    configInteractionPolicy = removeConfig ? ConfigurationFile.InteractionPolicy.DISCARD : ConfigurationFile.InteractionPolicy.NEW;
                    continue;
                }
                if (arg.startsWith("--internal-remove-config")) {
                    assert (launchType == ServerEnvironment.LaunchType.EMBEDDED);
                    removeConfig = true;
                    if (configInteractionPolicy == ConfigurationFile.InteractionPolicy.NEW) {
                        configInteractionPolicy = ConfigurationFile.InteractionPolicy.DISCARD;
                    }
                    continue;
                }
                if ("--properties".equals(arg) || "-properties".equals(arg) || "-P".equals(arg)) {
                    if (Main.processProperties(productConfig, arg, args[++i], systemProperties)) continue;
                    return new ServerEnvironmentWrapper(ServerEnvironmentWrapper.ServerEnvironmentStatus.ERROR);
                }
                if (arg.startsWith("--properties")) {
                    String urlSpec = Main.parseValue(productConfig, arg, "--properties");
                    if (urlSpec != null && Main.processProperties(productConfig, arg, urlSpec, systemProperties)) continue;
                    return new ServerEnvironmentWrapper(ServerEnvironmentWrapper.ServerEnvironmentStatus.ERROR);
                }
                if (arg.startsWith("-P")) {
                    String urlSpec = Main.parseValue(productConfig, arg, "-P");
                    if (urlSpec != null && Main.processProperties(productConfig, arg, urlSpec, systemProperties)) continue;
                    return new ServerEnvironmentWrapper(ServerEnvironmentWrapper.ServerEnvironmentStatus.ERROR);
                }
                if (arg.startsWith("-properties")) {
                    String urlSpec = Main.parseValue(productConfig, arg, "-properties");
                    if (urlSpec != null && Main.processProperties(productConfig, arg, urlSpec, systemProperties)) continue;
                    return new ServerEnvironmentWrapper(ServerEnvironmentWrapper.ServerEnvironmentStatus.ERROR);
                }
                if (arg.startsWith("-D")) {
                    String value;
                    String name;
                    int idx = arg.indexOf("=");
                    if (idx == -1) {
                        name = arg.substring(2);
                        value = "true";
                    } else {
                        name = arg.substring(2, idx);
                        value = arg.substring(idx + 1);
                    }
                    systemProperties.setProperty(name, value);
                    continue;
                }
                if (arg.startsWith("-b")) {
                    int idx = arg.indexOf(61);
                    if (idx == arg.length() - 1) {
                        STDERR.println(ServerLogger.ROOT_LOGGER.noArgValue(arg));
                        Main.usage(productConfig);
                        return new ServerEnvironmentWrapper(ServerEnvironmentWrapper.ServerEnvironmentStatus.ERROR);
                    }
                    String value = idx > -1 ? arg.substring(idx + 1) : args[++i];
                    value = Main.fixPossibleIPv6URL(value);
                    Object propertyName = null;
                    propertyName = idx < 0 ? (arg.length() == 2 ? "jboss.bind.address" : "jboss.bind.address." + arg.substring(2)) : (idx == 2 ? "jboss.bind.address" : "jboss.bind.address." + arg.substring(2, idx));
                    systemProperties.setProperty((String)propertyName, value);
                    continue;
                }
                if (arg.startsWith("-u")) {
                    int idx = arg.indexOf(61);
                    if (idx == arg.length() - 1) {
                        STDERR.println(ServerLogger.ROOT_LOGGER.valueExpectedForCommandLineOption(arg));
                        Main.usage(productConfig);
                        return new ServerEnvironmentWrapper(ServerEnvironmentWrapper.ServerEnvironmentStatus.ERROR);
                    }
                    String value = idx > -1 ? arg.substring(idx + 1) : args[++i];
                    value = Main.fixPossibleIPv6URL(value);
                    systemProperties.setProperty("jboss.default.multicast.address", value);
                    continue;
                }
                if ("--admin-only".equals(arg)) {
                    if (startModeSet) {
                        STDERR.println(ServerLogger.ROOT_LOGGER.cannotSetBothAdminOnlyAndStartMode());
                        Main.usage(productConfig);
                        return new ServerEnvironmentWrapper(ServerEnvironmentWrapper.ServerEnvironmentStatus.ERROR);
                    }
                    startModeSet = true;
                    runningMode = RunningMode.ADMIN_ONLY;
                    continue;
                }
                if (arg.startsWith("-S")) {
                    String token = arg.substring(2);
                    Main.processSecurityProperties(productConfig, token, systemProperties);
                    continue;
                }
                if (arg.startsWith("--start-mode")) {
                    if (startModeSet) {
                        STDERR.println(ServerLogger.ROOT_LOGGER.cannotSetBothAdminOnlyAndStartMode());
                        Main.usage(productConfig);
                        return new ServerEnvironmentWrapper(ServerEnvironmentWrapper.ServerEnvironmentStatus.ERROR);
                    }
                    startModeSet = true;
                    int idx = arg.indexOf(61);
                    if (idx == arg.length() - 1) {
                        STDERR.println(ServerLogger.ROOT_LOGGER.noArgValue(arg));
                        Main.usage(productConfig);
                        return new ServerEnvironmentWrapper(ServerEnvironmentWrapper.ServerEnvironmentStatus.ERROR);
                    }
                    String value = idx > -1 ? arg.substring(idx + 1) : args[++i];
                    switch (value = value.toLowerCase(Locale.ENGLISH)) {
                        case "admin-only": {
                            runningMode = RunningMode.ADMIN_ONLY;
                            break;
                        }
                        case "suspend": {
                            startSuspended = true;
                            break;
                        }
                        case "normal": {
                            break;
                        }
                        default: {
                            STDERR.println(ServerLogger.ROOT_LOGGER.unknownStartMode(value));
                            Main.usage(productConfig);
                            return new ServerEnvironmentWrapper(ServerEnvironmentWrapper.ServerEnvironmentStatus.ERROR);
                        }
                    }
                    continue;
                }
                if (arg.startsWith("--graceful-startup")) {
                    int idx = arg.indexOf(61);
                    if (idx == arg.length() - 1) {
                        STDERR.println(ServerLogger.ROOT_LOGGER.noArgValue(arg));
                        Main.usage(productConfig);
                        return new ServerEnvironmentWrapper(ServerEnvironmentWrapper.ServerEnvironmentStatus.ERROR);
                    }
                    String value = (idx > -1 ? arg.substring(idx + 1) : args[++i]).toLowerCase(Locale.ENGLISH);
                    if ("true".equals(value)) {
                        startGracefully = true;
                        continue;
                    }
                    if ("false".equals(value)) {
                        startGracefully = false;
                        continue;
                    }
                    STDERR.println(ServerLogger.ROOT_LOGGER.invalidCommandLineOption(arg));
                    Main.usage(productConfig);
                    return new ServerEnvironmentWrapper(ServerEnvironmentWrapper.ServerEnvironmentStatus.ERROR);
                }
                if (arg.equals("--debug")) {
                    String nextArg;
                    int next = i + 1;
                    if (next < argsLength && !(nextArg = args[next]).startsWith("-")) {
                        try {
                            Integer.parseInt(nextArg);
                            ++i;
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    continue;
                }
                if (arg.equals("-secmgr")) continue;
                if (arg.startsWith("--git-repo")) {
                    int idx = arg.indexOf("=");
                    if (idx == arg.length() - 1) {
                        return Main.requireValue(arg, productConfig);
                    }
                    if (idx == -1) {
                        int next = i + 1;
                        if (next < argsLength) {
                            gitRepository = args[next];
                            ++i;
                            continue;
                        }
                        return Main.requireValue(arg, productConfig);
                    }
                    gitRepository = arg.substring(idx + 1);
                    continue;
                }
                if (arg.startsWith("--git-auth")) {
                    int idx = arg.indexOf("=");
                    if (idx == arg.length() - 1) {
                        return Main.requireValue(arg, productConfig);
                    }
                    if (idx == -1) {
                        int next = i + 1;
                        if (next < argsLength) {
                            gitAuthConfiguration = args[next];
                            ++i;
                            continue;
                        }
                        return Main.requireValue(arg, productConfig);
                    }
                    gitAuthConfiguration = arg.substring(idx + 1);
                    continue;
                }
                if (arg.startsWith("--git-branch")) {
                    int idx = arg.indexOf("=");
                    if (idx == arg.length() - 1) {
                        return Main.requireValue(arg, productConfig);
                    }
                    if (idx == -1) {
                        int next = i + 1;
                        if (next < argsLength) {
                            gitBranch = args[next];
                            ++i;
                            continue;
                        }
                        return Main.requireValue(arg, productConfig);
                    }
                    gitBranch = arg.substring(idx + 1);
                    continue;
                }
                if (productConfig.getStabilitySet().size() > 1 && arg.startsWith("--stability")) {
                    String stability;
                    String string = stability = arg.length() == "--stability".length() ? args[++i] : Main.parseValue(productConfig, arg, "--stability");
                    if (stability == null) {
                        return new ServerEnvironmentWrapper(ServerEnvironmentWrapper.ServerEnvironmentStatus.ERROR);
                    }
                    systemProperties.setProperty("jboss.stability", stability);
                    continue;
                }
                if (ConfigurationExtensionFactory.isConfigurationExtensionSupported() && ConfigurationExtensionFactory.commandLineContainsArgument((String)arg)) {
                    int idx = arg.indexOf("=");
                    if (idx == arg.length() - 1) {
                        return Main.requireValue(arg, productConfig);
                    }
                    if (idx == -1) {
                        int next = i + 1;
                        if (next < argsLength) {
                            supplementalConfiguration = args[next];
                            ++i;
                            continue;
                        }
                        return Main.requireValue(arg, productConfig);
                    }
                    supplementalConfiguration = arg.substring(idx + 1);
                    continue;
                }
                STDERR.println(ServerLogger.ROOT_LOGGER.invalidCommandLineOption(arg));
                Main.usage(productConfig);
                return new ServerEnvironmentWrapper(ServerEnvironmentWrapper.ServerEnvironmentStatus.ERROR);
            }
            catch (IndexOutOfBoundsException e) {
                return Main.requireValue(arg, productConfig);
            }
        }
        String hostControllerName = null;
        productConfig = ProductConfig.fromFilesystemSlot((ModuleLoader)Module.getBootModuleLoader(), (String)WildFlySecurityManager.getPropertyPrivileged((String)"jboss.home.dir", null), (Map)systemProperties);
        return new ServerEnvironmentWrapper(new ServerEnvironment(hostControllerName, systemProperties, systemEnvironment, serverConfig, configInteractionPolicy, launchType, runningMode, productConfig, startTime, startSuspended, startGracefully, gitRepository, gitBranch, gitAuthConfiguration, supplementalConfiguration));
    }

    private static ServerEnvironmentWrapper requireValue(String arg, ProductConfig productConfig) {
        STDERR.println(ServerLogger.ROOT_LOGGER.valueExpectedForCommandLineOption(arg));
        Main.usage(productConfig);
        return new ServerEnvironmentWrapper(ServerEnvironmentWrapper.ServerEnvironmentStatus.ERROR);
    }

    private static void assertSingleConfig(String serverConfig) {
        if (serverConfig != null) {
            throw ServerLogger.ROOT_LOGGER.cannotHaveBothInitialServerConfigAndServerConfig();
        }
    }

    private static String parseValue(ProductConfig productConfig, String arg, String key) {
        String value = null;
        int splitPos = key.length();
        if (arg.length() <= splitPos + 1 || arg.charAt(splitPos) != '=') {
            Main.usage(productConfig);
        } else {
            value = arg.substring(splitPos + 1);
        }
        return value;
    }

    private static String fixPossibleIPv6URL(String val) {
        String result = val;
        if (val != null && val.length() > 2 && val.charAt(0) == '[' && val.charAt(val.length() - 1) == ']' && val.contains(":")) {
            result = val.substring(1, val.length() - 1);
        }
        return result;
    }

    private static boolean processProperties(ProductConfig productConfig, String arg, String urlSpec, Properties systemProperties) {
        URL url = null;
        try {
            url = Main.makeURL(urlSpec);
            systemProperties.load(url.openConnection().getInputStream());
            return true;
        }
        catch (MalformedURLException e) {
            STDERR.println(ServerLogger.ROOT_LOGGER.malformedCommandLineURL(urlSpec, arg));
            Main.usage(productConfig);
            return false;
        }
        catch (IOException e) {
            STDERR.println(ServerLogger.ROOT_LOGGER.unableToLoadProperties(url));
            Main.usage(productConfig);
            return false;
        }
    }

    private static URL makeURL(String urlspec) throws MalformedURLException {
        URL url;
        urlspec = urlspec.trim();
        try {
            url = new URL(urlspec);
            if (url.getProtocol().equals("file")) {
                File file = new File(url.getFile()).getCanonicalFile();
                url = file.toURI().toURL();
            }
        }
        catch (Exception e) {
            try {
                File file = new File(urlspec).getCanonicalFile();
                url = file.toURI().toURL();
            }
            catch (Exception n) {
                throw new MalformedURLException(n.toString());
            }
        }
        return url;
    }

    private static void processSecurityProperties(ProductConfig productConfig, String secProperties, Properties systemProperties) {
        StringTokenizer tokens = new StringTokenizer(secProperties, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            int idx = token.indexOf(61);
            if (idx == token.length() - 1) {
                STDERR.println(ServerLogger.ROOT_LOGGER.valueExpectedForCommandLineOption(secProperties));
                Main.usage(productConfig);
                return;
            }
            String value = token.substring(idx + 1);
            String key = token.substring(0, idx);
            systemProperties.setProperty(key, value);
        }
    }
}

