/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.operations.common.ProcessReloadHandler;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.Services;
import org.jboss.as.server.controller.descriptions.ServerDescriptions;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.version.Stability;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;

public class ServerProcessReloadHandler
extends ProcessReloadHandler<RunningModeControl> {
    private static final AttributeDefinition USE_CURRENT_SERVER_CONFIG = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("use-current-server-config", ModelType.BOOLEAN, true).setAlternatives(new String[]{"server-config"})).setDefaultValue(ModelNode.TRUE)).build();
    protected static final AttributeDefinition ADMIN_ONLY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("admin-only", ModelType.BOOLEAN, true).setAlternatives(new String[]{"start-mode"})).setDeprecated(ModelVersion.create((int)5, (int)0, (int)0))).setDefaultValue(ModelNode.FALSE)).build();
    private static final AttributeDefinition SERVER_CONFIG = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("server-config", ModelType.STRING, true).setAlternatives(new String[]{"use-current-server-config"})).build();
    protected static final AttributeDefinition START_MODE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("start-mode", ModelType.STRING, true).setValidator((ParameterValidator)EnumValidator.create(StartMode.class))).setAlternatives(new String[]{"admin-only"})).setDefaultValue(new ModelNode(StartMode.NORMAL.toString()))).build();
    private static final AttributeDefinition[] STANDARD_ATTRIBUTES = new AttributeDefinition[]{ADMIN_ONLY, USE_CURRENT_SERVER_CONFIG, SERVER_CONFIG, START_MODE};
    private static final OperationDefinition STANDARD_DEFINITION = new SimpleOperationDefinitionBuilder("reload", ServerDescriptions.getResourceDescriptionResolver("server")).setParameters(STANDARD_ATTRIBUTES).setRuntimeOnly().build();
    private static final String ENHANCED_OPERATION_NAME = "reload-enhanced";
    protected static final AttributeDefinition STABILITY = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("stability", ModelType.STRING, true).setValidator((ParameterValidator)EnumValidator.create(Stability.class))).build();
    private static final AttributeDefinition[] ENHANCED_ATTRIBUTES = new AttributeDefinition[]{ADMIN_ONLY, USE_CURRENT_SERVER_CONFIG, SERVER_CONFIG, START_MODE, STABILITY};
    private static final OperationDefinition ENHANCED_DEFINITION = new SimpleOperationDefinitionBuilder("reload-enhanced", ServerDescriptions.getResourceDescriptionResolver("server")).setStability(Stability.COMMUNITY).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.RELOAD_ENHANCED}).setParameters(ENHANCED_ATTRIBUTES).setRuntimeOnly().build();
    private final Set<String> additionalAttributes;
    private final ServerEnvironment environment;

    protected ServerProcessReloadHandler(ServiceName rootService, RunningModeControl runningModeControl, ControlledProcessState processState, ServerEnvironment environment) {
        this(rootService, runningModeControl, processState, environment, null);
    }

    private ServerProcessReloadHandler(ServiceName rootService, RunningModeControl runningModeControl, ControlledProcessState processState, ServerEnvironment environment, Set<String> additionalAttributes) {
        super(rootService, runningModeControl, processState);
        this.additionalAttributes = additionalAttributes == null ? Collections.emptySet() : additionalAttributes;
        this.environment = environment;
    }

    public static void registerStandardReloadOperation(ManagementResourceRegistration resourceRegistration, RunningModeControl runningModeControl, ControlledProcessState processState, ServerEnvironment serverEnvironment) {
        ServerProcessReloadHandler reloadHandler = new ServerProcessReloadHandler(Services.JBOSS_AS, runningModeControl, processState, serverEnvironment);
        resourceRegistration.registerOperationHandler(STANDARD_DEFINITION, (OperationStepHandler)reloadHandler, false);
    }

    public static void registerEnhancedReloadOperation(ManagementResourceRegistration resourceRegistration, RunningModeControl runningModeControl, ControlledProcessState processState, ServerEnvironment serverEnvironment) {
        ServerProcessReloadHandler reloadHandler = new ServerProcessReloadHandler(Services.JBOSS_AS, runningModeControl, processState, serverEnvironment, ServerProcessReloadHandler.getAttributeNames(ENHANCED_ATTRIBUTES));
        resourceRegistration.registerOperationHandler(ENHANCED_DEFINITION, (OperationStepHandler)reloadHandler, false);
    }

    private static Set<String> getAttributeNames(AttributeDefinition[] attributes) {
        HashSet<String> names = new HashSet<String>();
        for (AttributeDefinition attr : attributes) {
            names.add(attr.getName());
        }
        return names;
    }

    protected ProcessReloadHandler.ReloadContext<RunningModeControl> initializeReloadContext(OperationContext context, ModelNode operation) throws OperationFailedException {
        String serverConfig;
        Stability stability;
        boolean unmanaged = context.getProcessType() != ProcessType.DOMAIN_SERVER;
        boolean adminOnly = unmanaged && ADMIN_ONLY.resolveModelAttribute(context, operation).asBoolean(false);
        final boolean useCurrentConfig = unmanaged && USE_CURRENT_SERVER_CONFIG.resolveModelAttribute(context, operation).asBoolean(true);
        String startMode = START_MODE.resolveModelAttribute(context, operation).asString();
        if (this.additionalAttributes.contains("stability") && operation.hasDefined("stability")) {
            String val = STABILITY.resolveModelAttribute(context, operation).asString();
            stability = Stability.fromString((String)val);
            this.environment.checkStabilityIsValidForInstallation(stability);
        } else {
            stability = null;
        }
        if (operation.get("admin-only").isDefined() && operation.get("start-mode").isDefined()) {
            throw ServerLogger.ROOT_LOGGER.cannotSpecifyBothAdminOnlyAndStartMode();
        }
        boolean suspend = false;
        if (!adminOnly) {
            switch (startMode.toLowerCase(Locale.ENGLISH)) {
                case "admin-only": {
                    if (!unmanaged) break;
                    adminOnly = true;
                    break;
                }
                case "suspend": {
                    suspend = true;
                }
            }
        }
        final boolean finalSuspend = suspend;
        final boolean finalAdminOnly = adminOnly;
        String string = serverConfig = unmanaged && operation.hasDefined(SERVER_CONFIG.getName()) ? SERVER_CONFIG.resolveModelAttribute(context, operation).asString() : null;
        if (operation.hasDefined(USE_CURRENT_SERVER_CONFIG.getName()) && serverConfig != null) {
            throw ServerLogger.ROOT_LOGGER.cannotBothHaveFalseUseCurrentConfigAndServerConfig();
        }
        if (serverConfig != null && !this.environment.getServerConfigurationFile().checkCanFindNewBootFile(serverConfig)) {
            throw ServerLogger.ROOT_LOGGER.serverConfigForReloadNotFound(serverConfig);
        }
        return new ProcessReloadHandler.ReloadContext<RunningModeControl>(){

            public void reloadInitiated(RunningModeControl runningModeControl) {
            }

            public void doReload(RunningModeControl runningModeControl) {
                runningModeControl.setRunningMode(finalAdminOnly ? RunningMode.ADMIN_ONLY : RunningMode.NORMAL);
                runningModeControl.setReloaded();
                runningModeControl.setUseCurrentConfig(useCurrentConfig);
                runningModeControl.setNewBootFileName(serverConfig);
                runningModeControl.setSuspend(Boolean.valueOf(finalSuspend));
                if (stability != null) {
                    ServerProcessReloadHandler.this.environment.setStability(stability);
                }
            }
        };
    }

    private static enum StartMode {
        NORMAL("normal"),
        ADMIN_ONLY("admin-only"),
        SUSPEND("suspend");

        private final String localName;

        private StartMode(String localName) {
            this.localName = localName;
        }

        public String toString() {
            return this.localName;
        }
    }
}

