/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc;

import jakarta.resource.Referenceable;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionManager;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.ManagedConnectionFactory;
import jakarta.transaction.RollbackException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransactionRollbackException;
import java.util.logging.Logger;
import javax.naming.Reference;
import javax.sql.DataSource;
import org.jboss.jca.adapters.jdbc.BaseWrapperManagedConnectionFactory;
import org.jboss.jca.adapters.jdbc.JBossWrapper;
import org.jboss.jca.adapters.jdbc.SecurityActions;
import org.jboss.jca.adapters.jdbc.WrappedConnection;
import org.jboss.jca.adapters.jdbc.WrappedConnectionRequestInfo;
import org.jboss.jca.adapters.jdbc.spi.ClassLoaderPlugin;
import org.jboss.jca.core.spi.transaction.TransactionTimeoutConfiguration;
import org.jboss.jca.core.spi.transaction.TxUtils;

public class WrapperDataSource
extends JBossWrapper
implements Referenceable,
DataSource,
Serializable {
    private static final long serialVersionUID = 3570285419164793501L;
    private static org.jboss.logging.Logger spyLogger = org.jboss.logging.Logger.getLogger((String)"jboss.jdbc.spy");
    private final BaseWrapperManagedConnectionFactory mcf;
    private final ConnectionManager cm;
    private PrintWriter logger;
    private Reference reference;
    private ConnectionRequestInfo defaultCRI;
    private final ClassLoaderPlugin classLoaderPlugin;

    protected WrapperDataSource(BaseWrapperManagedConnectionFactory mcf, ConnectionManager cm, ClassLoaderPlugin classLoaderPlugin) {
        this.mcf = mcf;
        this.cm = cm;
        this.classLoaderPlugin = classLoaderPlugin;
        this.defaultCRI = mcf.getUserName() != null ? new WrappedConnectionRequestInfo(mcf.getUserName(), mcf.getPassword()) : null;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logger;
    }

    @Override
    public void setLogWriter(PrintWriter pw) throws SQLException {
        this.logger = pw;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setLoginTimeout(int param1) throws SQLException {
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Connection getConnection() throws SQLException {
        ClassLoader tccl = SecurityActions.getThreadContextClassLoader();
        this.mcf.setOriginalTCCLn(tccl);
        try {
            try {
                SecurityActions.setThreadContextClassLoader(this.classLoaderPlugin.getClassLoader());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.mcf.getSpy().booleanValue()) {
                spyLogger.debugf("%s [%s] getConnection()", (Object)this.mcf.getJndiName(), (Object)"DataSource");
            }
            WrappedConnection wc = (WrappedConnection)this.cm.allocateConnection((ManagedConnectionFactory)this.mcf, this.defaultCRI);
            wc.setDataSource(this);
            wc.setSpy(this.mcf.getSpy());
            wc.setJndiName(this.mcf.getJndiName());
            WrappedConnection wrappedConnection = wc;
            return wrappedConnection;
        }
        catch (ResourceException re) {
            throw new SQLException(re);
        }
        finally {
            this.mcf.setOriginalTCCLn(null);
            SecurityActions.setThreadContextClassLoader(tccl);
        }
    }

    @Override
    public Connection getConnection(String user, String password) throws SQLException {
        ClassLoader tccl = SecurityActions.getThreadContextClassLoader();
        WrappedConnectionRequestInfo cri = new WrappedConnectionRequestInfo(user, password);
        try {
            SecurityActions.setThreadContextClassLoader(this.classLoaderPlugin.getClassLoader());
            if (this.mcf.getSpy().booleanValue()) {
                spyLogger.debugf("%s [%s] getConnection(%s, ****)", (Object)this.mcf.getJndiName(), (Object)"DataSource", (Object)user);
            }
            WrappedConnection wc = (WrappedConnection)this.cm.allocateConnection((ManagedConnectionFactory)this.mcf, (ConnectionRequestInfo)cri);
            wc.setDataSource(this);
            wc.setSpy(this.mcf.getSpy());
            wc.setJndiName(this.mcf.getJndiName());
            WrappedConnection wrappedConnection = wc;
            return wrappedConnection;
        }
        catch (ResourceException re) {
            throw new SQLException(re);
        }
        finally {
            SecurityActions.setThreadContextClassLoader(tccl);
        }
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public Reference getReference() {
        return this.reference;
    }

    protected int getTimeLeftBeforeTransactionTimeout() throws SQLException {
        try {
            if (this.cm instanceof TransactionTimeoutConfiguration) {
                long timeout = ((TransactionTimeoutConfiguration)this.cm).getTimeLeftBeforeTransactionTimeout(true);
                if (timeout == -1L) {
                    return -1;
                }
                if (timeout == 0L) {
                    throw new SQLTimeoutException(bundle.transactionCannotProceed("No remaining transaction timeout"));
                }
                long result = timeout / 1000L;
                if (timeout % 1000L != 0L) {
                    ++result;
                }
                return (int)result;
            }
            return -1;
        }
        catch (RollbackException e) {
            throw new SQLTransactionRollbackException(e);
        }
    }

    protected void checkTransactionActive() throws SQLException {
        if (!this.mcf.isJTA().booleanValue()) {
            return;
        }
        try {
            int status = 6;
            if (this.mcf.getTransactionSynchronizationRegistry() != null) {
                status = this.mcf.getTransactionSynchronizationRegistry().getTransactionStatus();
            }
            if (status == 6) {
                return;
            }
            if (status != 0 && status != 7 && status != 2 && status != 8) {
                String transactionCannotProceed = bundle.transactionCannotProceed(TxUtils.getStatusAsString((int)status));
                if (status == 4) {
                    throw new SQLTransactionRollbackException(transactionCannotProceed);
                }
                throw new SQLException(transactionCannotProceed);
            }
        }
        catch (SQLException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new SQLException(t.getMessage(), t);
        }
    }
}

