/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.math;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.common.function.ExceptionPredicate;

public enum BigDecimalMarshaller implements ProtoStreamMarshaller<BigDecimal>,
ExceptionPredicate<BigInteger, IOException>
{
    INSTANCE;

    private static final int UNSCALED_VALUE_INDEX = 1;
    private static final int SCALE_INDEX = 2;
    private static final int DEFAULT_SCALE = 0;

    @Override
    public BigDecimal readFrom(ProtoStreamReader reader) throws IOException {
        BigInteger unscaledValue = BigInteger.ZERO;
        int scale = 0;
        block4: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    unscaledValue = new BigInteger(reader.readByteArray());
                    continue block4;
                }
                case 2: {
                    scale = reader.readSInt32();
                    continue block4;
                }
            }
            reader.skipField(tag);
        }
        return new BigDecimal(unscaledValue, scale);
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, BigDecimal value) throws IOException {
        int scale;
        BigInteger unscaledValue = value.unscaledValue();
        if (!this.test(unscaledValue)) {
            writer.writeBytes(1, unscaledValue.toByteArray());
        }
        if ((scale = value.scale()) != 0) {
            writer.writeSInt32(2, scale);
        }
    }

    @Override
    public Class<? extends BigDecimal> getJavaClass() {
        return BigDecimal.class;
    }

    public boolean test(BigInteger value) {
        return value.signum() == 0;
    }
}

