/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.management.ActiveMQServerControl;
import org.apache.activemq.artemis.core.security.SecurityAuth;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.wildfly.extension.messaging.activemq.ActiveMQBroker;
import org.wildfly.extension.messaging.activemq.ManagementUtil;

public class ActiveMQBrokerImpl
implements ActiveMQBroker {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final ActiveMQServer delegate;

    public ActiveMQBrokerImpl(ActiveMQServer delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object getDelegate() {
        return this.delegate;
    }

    @Override
    public SimpleString getNodeID() {
        return this.delegate.getNodeID();
    }

    @Override
    public void addConnectorConfiguration(String string, TransportConfiguration tc) {
        this.delegate.getConfiguration().addConnectorConfiguration(string, tc);
    }

    @Override
    public void createQueue(SimpleString address, RoutingType routingType, SimpleString queueName, SimpleString filter, boolean durable, boolean temporary) throws Exception {
        this.delegate.createQueue(address, routingType, queueName, filter, durable, temporary);
    }

    @Override
    public void destroyQueue(SimpleString queueName, SecurityAuth session, boolean checkConsumerCount) throws Exception {
        this.delegate.destroyQueue(queueName, session, checkConsumerCount);
    }

    @Override
    public boolean isActive() {
        return this.delegate.isStarted() && this.delegate.isActive();
    }

    @Override
    public boolean hasResource(String resourceName) {
        return this.delegate.getManagementService() != null && this.delegate.getManagementService().getResource(resourceName) != null;
    }

    @Override
    public Object getResource(String resourceName) {
        if (this.delegate.getManagementService() != null) {
            return this.delegate.getManagementService().getResource(resourceName);
        }
        return null;
    }

    @Override
    public Object[] getResources(Class<?> resourceType) {
        if (this.delegate.getManagementService() != null) {
            return this.delegate.getManagementService().getResources(resourceType);
        }
        return EMPTY_ARRAY;
    }

    @Override
    public ActiveMQServerControl getActiveMQServerControl() {
        return this.delegate.getActiveMQServerControl();
    }

    @Override
    public String getAddressSettingsAsJSON(String addressMatch) {
        AddressSettings settings = (AddressSettings)this.delegate.getAddressSettingsRepository().getMatch(addressMatch);
        settings.merge((AddressSettings)this.delegate.getAddressSettingsRepository().getDefault());
        return ManagementUtil.convertAddressSettingInfosAsJSON(settings.toJSON());
    }
}

