/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.Arrays;
import java.util.Collection;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReadResourceNameOperationStepHandler;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.threads.HandoffExecutorResolver;
import org.jboss.as.threads.ManagedQueuelessExecutorService;
import org.jboss.as.threads.PoolAttributeDefinitions;
import org.jboss.as.threads.QueuelessThreadPoolAdd;
import org.jboss.as.threads.QueuelessThreadPoolMetricsHandler;
import org.jboss.as.threads.QueuelessThreadPoolRemove;
import org.jboss.as.threads.QueuelessThreadPoolWriteAttributeHandler;
import org.jboss.as.threads.ThreadFactoryResolver;
import org.jboss.as.threads.ThreadPoolResourceDescriptionResolver;
import org.jboss.as.threads.ThreadsExtension;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.msc.service.ServiceName;

public class QueuelessThreadPoolResourceDefinition
extends PersistentResourceDefinition {
    private final QueuelessThreadPoolWriteAttributeHandler writeHandler;
    private final QueuelessThreadPoolMetricsHandler metricsHandler;
    private final boolean blocking;
    private final boolean registerRuntimeOnly;

    public static QueuelessThreadPoolResourceDefinition create(boolean blocking, boolean registerRuntimeOnly) {
        if (blocking) {
            return QueuelessThreadPoolResourceDefinition.create("blocking-queueless-thread-pool", ThreadsServices.getThreadFactoryResolver("blocking-queueless-thread-pool"), null, ThreadsServices.EXECUTOR, registerRuntimeOnly);
        }
        return QueuelessThreadPoolResourceDefinition.create("queueless-thread-pool", ThreadsServices.getThreadFactoryResolver("queueless-thread-pool"), ThreadsServices.getHandoffExecutorResolver("queueless-thread-pool"), ThreadsServices.EXECUTOR, registerRuntimeOnly);
    }

    public static QueuelessThreadPoolResourceDefinition create(boolean blocking, String type, boolean registerRuntimeOnly) {
        if (blocking) {
            return QueuelessThreadPoolResourceDefinition.create(type, ThreadsServices.getThreadFactoryResolver(type), null, ThreadsServices.EXECUTOR, registerRuntimeOnly);
        }
        return QueuelessThreadPoolResourceDefinition.create(type, ThreadsServices.getThreadFactoryResolver(type), ThreadsServices.getHandoffExecutorResolver(type), ThreadsServices.EXECUTOR, registerRuntimeOnly);
    }

    public static QueuelessThreadPoolResourceDefinition create(String type, ThreadFactoryResolver threadFactoryResolver, HandoffExecutorResolver handoffExecutorResolver, ServiceName serviceNameBase, boolean registerRuntimeOnly) {
        boolean blocking = handoffExecutorResolver == null;
        String resolverPrefix = blocking ? "blocking-queueless-thread-pool" : "queueless-thread-pool";
        RuntimeCapability<Void> capability = ThreadsServices.createCapability(type, ManagedQueuelessExecutorService.class);
        QueuelessThreadPoolAdd addHandler = new QueuelessThreadPoolAdd(blocking, threadFactoryResolver, handoffExecutorResolver, serviceNameBase, capability);
        QueuelessThreadPoolRemove removeHandler = new QueuelessThreadPoolRemove(addHandler);
        return new QueuelessThreadPoolResourceDefinition(blocking, registerRuntimeOnly, capability, type, serviceNameBase, resolverPrefix, (OperationStepHandler)addHandler, (OperationStepHandler)removeHandler);
    }

    private QueuelessThreadPoolResourceDefinition(boolean blocking, boolean registerRuntimeOnly, RuntimeCapability<Void> capability, String type, ServiceName serviceNameBase, String resolverPrefix, OperationStepHandler addHandler, OperationStepHandler removeHandler) {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)type), (ResourceDescriptionResolver)new ThreadPoolResourceDescriptionResolver(resolverPrefix, ThreadsExtension.RESOURCE_NAME, ThreadsExtension.class.getClassLoader())).setAddHandler(addHandler).setRemoveHandler(removeHandler).setCapabilities(new RuntimeCapability[]{capability}));
        this.registerRuntimeOnly = registerRuntimeOnly;
        this.blocking = blocking;
        this.writeHandler = new QueuelessThreadPoolWriteAttributeHandler(blocking, capability, serviceNameBase);
        this.metricsHandler = new QueuelessThreadPoolMetricsHandler(capability, serviceNameBase);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)PoolAttributeDefinitions.NAME, (OperationStepHandler)ReadResourceNameOperationStepHandler.INSTANCE);
        this.writeHandler.registerAttributes(resourceRegistration);
        if (this.registerRuntimeOnly) {
            this.metricsHandler.registerAttributes(resourceRegistration);
        }
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(this.writeHandler.attributes);
    }
}

