/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful.cache.distributable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.function.Consumer;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.clustering.controller.ResourceServiceConfigurator;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.EEModuleConfiguration;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanCacheProvider;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanCacheProviderServiceNameProvider;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanInstance;
import org.jboss.as.ejb3.component.stateful.cache.distributable.DistributableStatefulSessionBeanCacheFactoryServiceConfigurator;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.modules.Module;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.ejb.DeploymentConfiguration;
import org.wildfly.clustering.ejb.bean.BeanConfiguration;
import org.wildfly.clustering.ejb.bean.BeanDeploymentConfiguration;
import org.wildfly.clustering.ejb.bean.BeanManagementProvider;
import org.wildfly.clustering.service.SupplierDependency;

public abstract class AbstractDistributableStatefulSessionBeanCacheProviderServiceConfigurator<K, V extends StatefulSessionBeanInstance<K>>
extends StatefulSessionBeanCacheProviderServiceNameProvider
implements ResourceServiceConfigurator,
StatefulSessionBeanCacheProvider<K, V>,
Consumer<SupplierDependency<BeanManagementProvider>> {
    private volatile SupplierDependency<BeanManagementProvider> provider;

    public AbstractDistributableStatefulSessionBeanCacheProviderServiceConfigurator(PathAddress address) {
        super(address.getLastElement().getValue());
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceName name = this.getServiceName();
        ServiceBuilder builder = target.addService(name);
        Consumer provider = this.provider.register(builder).provides(new ServiceName[]{name});
        Service service = Service.newInstance((Consumer)provider, (Object)this);
        return builder.setInstance(service);
    }

    @Override
    public void accept(SupplierDependency<BeanManagementProvider> provider) {
        this.provider = provider;
    }

    String getBeanManagerName(DeploymentUnit unit) {
        BeanManagementProvider provider = (BeanManagementProvider)this.provider.get();
        ArrayList<String> parts = new ArrayList<String>(3);
        DeploymentUnit parent = unit.getParent();
        if (parent != null) {
            parts.add(parent.getServiceName().getSimpleName());
        }
        parts.add(unit.getServiceName().getSimpleName());
        parts.add(provider.getName());
        return String.join((CharSequence)"/", parts);
    }

    @Override
    public Iterable<CapabilityServiceConfigurator> getDeploymentServiceConfigurators(DeploymentUnit unit, EEModuleConfiguration moduleConfiguration) {
        return ((BeanManagementProvider)this.provider.get()).getDeploymentServiceConfigurators((BeanDeploymentConfiguration)new BeanDeploymentUnitConfiguration((BeanManagementProvider)this.provider.get(), unit, moduleConfiguration));
    }

    @Override
    public CapabilityServiceConfigurator getStatefulBeanCacheFactoryServiceConfigurator(DeploymentUnit unit, StatefulComponentDescription description, ComponentConfiguration configuration) {
        CapabilityServiceConfigurator configurator = ((BeanManagementProvider)this.provider.get()).getBeanManagerFactoryServiceConfigurator((BeanConfiguration)new DeploymentUnitBeanConfiguration((BeanManagementProvider)this.provider.get(), unit, configuration));
        return new DistributableStatefulSessionBeanCacheFactoryServiceConfigurator(description.getCacheFactoryServiceName(), configurator);
    }

    @Override
    public boolean supportsPassivation() {
        return true;
    }

    private static class BeanDeploymentUnitConfiguration
    extends DeploymentUnitConfiguration
    implements BeanDeploymentConfiguration {
        private final Set<Class<?>> beanClasses = Collections.newSetFromMap(new IdentityHashMap());

        BeanDeploymentUnitConfiguration(BeanManagementProvider provider, DeploymentUnit unit, EEModuleConfiguration moduleConfiguration) {
            super(provider, unit);
            for (ComponentConfiguration configuration : moduleConfiguration.getComponentConfigurations()) {
                if (!(configuration.getComponentDescription() instanceof StatefulComponentDescription)) continue;
                for (Class componentClass = configuration.getComponentClass(); componentClass != Object.class; componentClass = componentClass.getSuperclass()) {
                    this.beanClasses.add(componentClass);
                }
            }
        }

        public Set<Class<?>> getBeanClasses() {
            return this.beanClasses;
        }
    }

    private static class DeploymentUnitBeanConfiguration
    extends DeploymentUnitConfiguration
    implements BeanConfiguration {
        private final ComponentConfiguration configuration;

        DeploymentUnitBeanConfiguration(BeanManagementProvider provider, DeploymentUnit unit, ComponentConfiguration configuration) {
            super(provider, unit);
            this.configuration = configuration;
        }

        public String getName() {
            return this.configuration.getComponentName();
        }
    }

    private static class DeploymentUnitConfiguration
    implements DeploymentConfiguration {
        private final String deploymentName;
        private final DeploymentUnit unit;

        DeploymentUnitConfiguration(BeanManagementProvider provider, DeploymentUnit unit) {
            ArrayList<String> parts = new ArrayList<String>(3);
            DeploymentUnit parent = unit.getParent();
            if (parent != null) {
                parts.add(parent.getServiceName().getSimpleName());
            }
            parts.add(unit.getServiceName().getSimpleName());
            parts.add(provider.getName());
            this.deploymentName = String.join((CharSequence)"/", parts);
            this.unit = unit;
        }

        public String getDeploymentName() {
            return this.deploymentName;
        }

        public ServiceName getDeploymentServiceName() {
            return this.unit.getServiceName();
        }

        public Module getModule() {
            return (Module)this.unit.getAttachment(Attachments.MODULE);
        }
    }
}

