/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.idm.model;

import java.util.HashMap;
import java.util.Map;

public enum CredentialTypeEnum {
    PASSWORD_CREDENTIAL_HANDLER("PasswordHandler", "org.picketlink.idm.credential.handler.PasswordCredentialHandler"),
    LDAP_PASSWORD_CREDENTIAL_HANDLER("LDAPPasswordHandler", "org.picketlink.idm.ldap.internal.LDAPPlainTextPasswordCredentialHandler"),
    DIGEST_CREDENTIAL_HANDLER("DigestHandler", "org.picketlink.idm.credential.handler.DigestCredentialHandler"),
    X509_CERT_CREDENTIAL_HANDLER("X509CertHandler", "org.picketlink.idm.credential.handler.X509CertificateCredentialHandler");

    private static final Map<String, CredentialTypeEnum> types;
    private final String alias;
    private final String type;

    private CredentialTypeEnum(String alias, String type) {
        this.alias = alias;
        this.type = type;
    }

    public static String forType(String alias) {
        CredentialTypeEnum resolvedType = types.get(alias);
        if (resolvedType != null) {
            return resolvedType.getType();
        }
        return null;
    }

    public String toString() {
        return this.alias;
    }

    String getAlias() {
        return this.alias;
    }

    String getType() {
        return this.type;
    }

    static {
        types = new HashMap<String, CredentialTypeEnum>();
        for (CredentialTypeEnum element : CredentialTypeEnum.values()) {
            types.put(element.getAlias(), element);
        }
    }
}

