/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.weld.injection;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.Bean;
import java.io.IOException;
import java.lang.reflect.Field;
import java.security.PrivilegedAction;
import java.util.Collections;
import org.infinispan.protostream.descriptors.WireType;
import org.jboss.weld.Container;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.enhanced.jlr.EnhancedAnnotatedMethodImpl;
import org.jboss.weld.annotated.slim.AnnotatedTypeIdentifier;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedMethod;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedType;
import org.jboss.weld.injection.InjectionPointFactory;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.security.manager.WildFlySecurityManager;

public class MethodInjectionPointMarshaller<T, X>
implements ProtoStreamMarshaller<MethodInjectionPoint<T, X>> {
    private static final int TYPE_INDEX = 1;
    private static final int METHOD_INDEX = 2;
    private static final int BEAN_INDEX = 3;
    private static final MethodInjectionPoint.MethodInjectionPointType DEFAULT_TYPE = MethodInjectionPoint.MethodInjectionPointType.PRODUCER;
    static final Field TYPE_FIELD = (Field)WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<Field>(){

        @Override
        public Field run() {
            for (Field field : MethodInjectionPoint.class.getDeclaredFields()) {
                if (field.getType() != MethodInjectionPoint.MethodInjectionPointType.class) continue;
                field.setAccessible(true);
                return field;
            }
            throw new IllegalStateException();
        }
    });

    public Class<? extends MethodInjectionPoint<T, X>> getJavaClass() {
        return MethodInjectionPoint.class;
    }

    public MethodInjectionPoint<T, X> readFrom(ProtoStreamReader reader) throws IOException {
        MethodInjectionPoint.MethodInjectionPointType injectionPointType = DEFAULT_TYPE;
        BackedAnnotatedMethod method = null;
        BeanIdentifier beanId = null;
        block5: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    injectionPointType = (MethodInjectionPoint.MethodInjectionPointType)reader.readEnum(MethodInjectionPoint.MethodInjectionPointType.class);
                }
                case 2: {
                    method = (BackedAnnotatedMethod)reader.readObject(BackedAnnotatedMethod.class);
                    continue block5;
                }
                case 3: {
                    beanId = (BeanIdentifier)reader.readAny(BeanIdentifier.class);
                    continue block5;
                }
            }
            reader.skipField(tag);
        }
        BackedAnnotatedType type = method.getDeclaringType();
        AnnotatedTypeIdentifier identifier = (AnnotatedTypeIdentifier)type.getIdentifier();
        BeanManagerImpl manager = Container.instance((AnnotatedTypeIdentifier)identifier).getBeanManager(identifier.getBdaId());
        ClassTransformer transformer = ClassTransformer.instance((BeanManagerImpl)manager);
        Bean bean = beanId != null ? (Bean)((ContextualStore)Container.instance((BeanManagerImpl)manager).services().get(ContextualStore.class)).getContextual(beanId) : null;
        return InjectionPointFactory.silentInstance().createMethodInjectionPoint(injectionPointType, (EnhancedAnnotatedMethod)EnhancedAnnotatedMethodImpl.of((AnnotatedMethod)method, (EnhancedAnnotatedType)transformer.getEnhancedAnnotatedType((SlimAnnotatedType)type), (ClassTransformer)transformer), bean, this.getJavaClass(), Collections.emptySet(), manager);
    }

    public void writeTo(ProtoStreamWriter writer, MethodInjectionPoint<T, X> injectionPoint) throws IOException {
        Bean bean;
        BackedAnnotatedMethod method;
        MethodInjectionPoint.MethodInjectionPointType type = this.getValue(injectionPoint, TYPE_FIELD, MethodInjectionPoint.MethodInjectionPointType.class);
        if (type != DEFAULT_TYPE) {
            writer.writeEnum(1, (Enum)type);
        }
        if ((method = (BackedAnnotatedMethod)injectionPoint.getAnnotated()) != null) {
            writer.writeObject(2, (Object)method);
        }
        if ((bean = injectionPoint.getBean()) != null) {
            BeanIdentifier beanId = ((ContextualStore)Container.instance((AnnotatedTypeIdentifier)method.getDeclaringType().getIdentifier()).services().get(ContextualStore.class)).putIfAbsent((Contextual)bean);
            writer.writeAny(3, (Object)beanId);
        }
    }

    private <F> F getValue(final MethodInjectionPoint<T, X> injectionPoint, Field field, final Class<F> targetClass) {
        return (F)WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<F>(){

            @Override
            public F run() {
                try {
                    return targetClass.cast(TYPE_FIELD.get(injectionPoint));
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }
}

