/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session.metadata.coarse;

import java.time.Duration;
import java.time.Instant;
import org.wildfly.clustering.ee.cache.offset.OffsetValue;
import org.wildfly.clustering.web.cache.session.metadata.coarse.ContextualSessionMetaDataEntry;
import org.wildfly.clustering.web.cache.session.metadata.coarse.MutableSessionMetaDataValues;

public interface MutableSessionMetaDataOffsetValues
extends MutableSessionMetaDataValues {
    public static <C> MutableSessionMetaDataOffsetValues from(ContextualSessionMetaDataEntry<C> entry) {
        final OffsetValue timeout = OffsetValue.from((Duration)entry.getTimeout());
        final OffsetValue lastAccessStartTime = entry.getLastAccessStartTime().rebase();
        final OffsetValue lastAccessEndTime = entry.getLastAccessEndTime().rebase();
        return new MutableSessionMetaDataOffsetValues(){

            @Override
            public OffsetValue<Duration> getTimeout() {
                return timeout;
            }

            @Override
            public OffsetValue<Instant> getLastAccessStartTime() {
                return lastAccessStartTime;
            }

            @Override
            public OffsetValue<Instant> getLastAccessEndTime() {
                return lastAccessEndTime;
            }
        };
    }

    public OffsetValue<Duration> getTimeout();

    public OffsetValue<Instant> getLastAccessStartTime();

    public OffsetValue<Instant> getLastAccessEndTime();
}

