/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session.metadata.fine;

import java.time.Duration;
import java.time.Instant;
import org.wildfly.clustering.web.cache.session.metadata.fine.ImmutableSessionAccessMetaData;
import org.wildfly.clustering.web.cache.session.metadata.fine.ImmutableSessionCreationMetaData;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;

public class CompositeImmutableSessionMetaData
implements ImmutableSessionMetaData {
    private final ImmutableSessionCreationMetaData creationMetaData;
    private final ImmutableSessionAccessMetaData accessMetaData;

    public CompositeImmutableSessionMetaData(ImmutableSessionCreationMetaData creationMetaData, ImmutableSessionAccessMetaData accessMetaData) {
        this.creationMetaData = creationMetaData;
        this.accessMetaData = accessMetaData;
    }

    public boolean isNew() {
        return this.accessMetaData.isNew();
    }

    public Duration getTimeout() {
        return this.creationMetaData.getTimeout();
    }

    public Instant getCreationTime() {
        return this.creationMetaData.getCreationTime();
    }

    public Instant getLastAccessStartTime() {
        return this.getCreationTime().plus(this.accessMetaData.getSinceCreationDuration());
    }

    public Instant getLastAccessEndTime() {
        return this.getLastAccessStartTime().plus(this.accessMetaData.getLastAccessDuration());
    }
}

