/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.environment.classpath.spi;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;

public final class AggregatedClassLoader
extends ClassLoader {
    private ClassLoader[] individualClassLoaders;

    public static AggregatedClassLoader createDefault() {
        ClassLoader sysClassLoader;
        LinkedHashSet<ClassLoader> orderedClassLoaderSet = new LinkedHashSet<ClassLoader>();
        orderedClassLoaderSet.add(AggregatedClassLoader.class.getClassLoader());
        ClassLoader tccl = AggregatedClassLoader.locateTCCL();
        if (tccl != null) {
            orderedClassLoaderSet.add(tccl);
        }
        if ((sysClassLoader = AggregatedClassLoader.locateSystemClassLoader()) != null) {
            orderedClassLoaderSet.add(sysClassLoader);
        }
        return new AggregatedClassLoader(orderedClassLoaderSet.toArray(new ClassLoader[0]));
    }

    private AggregatedClassLoader(ClassLoader ... classLoaders) {
        super(null);
        this.individualClassLoaders = classLoaders;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        final HashSet<URL> resourceUrls = new HashSet<URL>();
        for (ClassLoader classLoader : this.individualClassLoaders) {
            Enumeration<URL> urls = classLoader.getResources(name);
            while (urls.hasMoreElements()) {
                resourceUrls.add(urls.nextElement());
            }
        }
        return new Enumeration<URL>(){
            final Iterator<URL> resourceUrlIterator;
            {
                this.resourceUrlIterator = resourceUrls.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.resourceUrlIterator.hasNext();
            }

            @Override
            public URL nextElement() {
                return this.resourceUrlIterator.next();
            }
        };
    }

    @Override
    protected URL findResource(String name) {
        for (ClassLoader classLoader : this.individualClassLoaders) {
            URL resource = classLoader.getResource(name);
            if (resource == null) continue;
            return resource;
        }
        return super.findResource(name);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        for (ClassLoader classLoader : this.individualClassLoaders) {
            try {
                return classLoader.loadClass(name);
            }
            catch (Exception | LinkageError throwable) {
            }
        }
        throw new ClassNotFoundException("Could not load requested class : " + name);
    }

    void addAllTo(Collection<ClassLoader> classLoaders) {
        Collections.addAll(classLoaders, this.individualClassLoaders);
    }

    private static ClassLoader locateSystemClassLoader() {
        try {
            return ClassLoader.getSystemClassLoader();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static ClassLoader locateTCCL() {
        try {
            return Thread.currentThread().getContextClassLoader();
        }
        catch (Exception e) {
            return null;
        }
    }
}

