/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.mutation.internal;

import java.sql.PreparedStatement;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementGroup;
import org.hibernate.engine.jdbc.mutation.internal.PreparedStatementDetailsStandard;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.MutationStatementPreparer;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.mutation.EntityMutationTarget;
import org.hibernate.sql.model.MutationTarget;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.PreparableMutationOperation;
import org.hibernate.sql.model.TableMapping;

public class PreparedStatementGroupStandard
implements PreparedStatementGroup {
    private final MutationType mutationType;
    private final MutationTarget<?> mutationTarget;
    private final List<PreparableMutationOperation> jdbcMutations;
    private final SharedSessionContractImplementor session;
    private final SortedMap<String, PreparedStatementDetails> statementMap;

    public PreparedStatementGroupStandard(MutationType mutationType, MutationTarget<?> mutationTarget, List<PreparableMutationOperation> jdbcMutations, SharedSessionContractImplementor session) {
        this.mutationType = mutationType;
        this.mutationTarget = mutationTarget;
        this.jdbcMutations = jdbcMutations;
        this.session = session;
        this.statementMap = this.createStatementDetailsMap(jdbcMutations, mutationType, mutationTarget, session);
    }

    @Override
    public int getNumberOfStatements() {
        return this.jdbcMutations.size();
    }

    @Override
    public int getNumberOfActiveStatements() {
        int count = 0;
        for (Map.Entry<String, PreparedStatementDetails> entry : this.statementMap.entrySet()) {
            if (entry.getValue().getStatement() == null) continue;
            ++count;
        }
        return count;
    }

    @Override
    public PreparedStatementDetails getSingleStatementDetails() {
        throw new IllegalStateException(String.format(Locale.ROOT, "Statement group contained more than one statement - %s : %s", this.mutationType.name(), this.mutationTarget.getNavigableRole().getFullPath()));
    }

    @Override
    public void forEachStatement(BiConsumer<String, PreparedStatementDetails> action) {
        this.statementMap.forEach(action);
    }

    @Override
    public PreparedStatementDetails getPreparedStatementDetails(String tableName) {
        return (PreparedStatementDetails)this.statementMap.get(tableName);
    }

    @Override
    public PreparedStatementDetails resolvePreparedStatementDetails(String tableName) {
        return (PreparedStatementDetails)this.statementMap.get(tableName);
    }

    @Override
    public boolean hasMatching(Predicate<PreparedStatementDetails> filter) {
        for (Map.Entry<String, PreparedStatementDetails> entry : this.statementMap.entrySet()) {
            if (!filter.test(entry.getValue())) continue;
            return true;
        }
        return false;
    }

    private static PreparedStatementDetails createPreparedStatementDetails(PreparableMutationOperation jdbcMutation, MutationType mutationType, MutationTarget<?> mutationTarget, SharedSessionContractImplementor session) {
        JdbcCoordinator jdbcCoordinator = session.getJdbcCoordinator();
        MutationStatementPreparer statementPreparer = jdbcCoordinator.getMutationStatementPreparer();
        TableMapping tableDetails = jdbcMutation.getTableDetails();
        Supplier<PreparedStatement> jdbcStatementCreator = mutationType == MutationType.INSERT && mutationTarget instanceof EntityMutationTarget && ((EntityMutationTarget)mutationTarget).getIdentityInsertDelegate() != null && tableDetails.getTableName().equals(mutationTarget.getIdentifierTableName()) ? () -> ((EntityMutationTarget)mutationTarget).getIdentityInsertDelegate().prepareStatement(jdbcMutation.getSqlString(), session) : () -> statementPreparer.prepareStatement(jdbcMutation.getSqlString(), jdbcMutation.isCallable());
        return new PreparedStatementDetailsStandard(jdbcMutation, jdbcMutation.getSqlString(), jdbcStatementCreator, jdbcMutation.getExpectation(), session.getJdbcServices());
    }

    @Override
    public void release() {
        this.statementMap.forEach((tableName, statementDetails) -> statementDetails.releaseStatement(this.session));
    }

    private SortedMap<String, PreparedStatementDetails> createStatementDetailsMap(List<PreparableMutationOperation> jdbcMutations, MutationType mutationType, MutationTarget<?> mutationTarget, SharedSessionContractImplementor session) {
        Comparator<String> comparator = mutationType == MutationType.DELETE ? Comparator.comparingInt(tableName -> {
            TableMapping tableMapping = this.locateTableMapping((String)tableName);
            if (tableMapping == null) {
                return -1;
            }
            return this.jdbcMutations.size() - tableMapping.getRelativePosition();
        }) : Comparator.comparingInt(tableName -> {
            TableMapping tableMapping = this.locateTableMapping((String)tableName);
            if (tableMapping == null) {
                return -1;
            }
            return tableMapping.getRelativePosition();
        });
        TreeMap<String, PreparedStatementDetails> map = new TreeMap<String, PreparedStatementDetails>(comparator);
        for (int i = 0; i < jdbcMutations.size(); ++i) {
            PreparableMutationOperation jdbcMutation = jdbcMutations.get(i);
            map.put(jdbcMutation.getTableDetails().getTableName(), PreparedStatementGroupStandard.createPreparedStatementDetails(jdbcMutation, mutationType, mutationTarget, session));
        }
        return map;
    }

    private TableMapping locateTableMapping(String name) {
        for (int i = 0; i < this.jdbcMutations.size(); ++i) {
            TableMapping tableMapping = this.jdbcMutations.get(i).getTableDetails();
            if (!tableMapping.getTableName().equals(name)) continue;
            return tableMapping;
        }
        return null;
    }
}

