/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.recovery.transactions;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.jts.recovery.transactions.RecoveredServerTransaction;
import com.arjuna.ats.jts.logging.jtsLogger;
import java.io.IOException;
import java.util.Date;
import org.omg.CosTransactions.Status;

public final class AssumedCompleteHeuristicServerTransaction
extends RecoveredServerTransaction {
    private static final String ourTypeName = "/StateManager/BasicAction/TwoPhaseCoordinator/ArjunaTransactionImple/AssumedCompleteHeuristicServerTransaction";
    private Date lastActiveTime;

    public AssumedCompleteHeuristicServerTransaction(Uid actionUid) {
        super(actionUid, ourTypeName);
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug((Object)(AssumedCompleteHeuristicServerTransaction.class.getSimpleName() + " " + String.valueOf(this.get_uid()) + " created"));
        }
    }

    public static String typeName() {
        return ourTypeName;
    }

    @Override
    public Status getOriginalStatus() {
        return Status.StatusNoTransaction;
    }

    @Override
    public String type() {
        return AssumedCompleteHeuristicServerTransaction.typeName();
    }

    @Override
    public String toString() {
        return AssumedCompleteHeuristicServerTransaction.class.getSimpleName() + " <" + String.valueOf(this.get_uid()) + ">";
    }

    @Override
    public boolean assumeComplete() {
        return false;
    }

    @Override
    public Date getLastActiveTime() {
        return this.lastActiveTime;
    }

    @Override
    public boolean restore_state(InputObjectState objectState, int ot) {
        boolean result = super.restore_state(objectState, ot);
        if (result) {
            try {
                long oldtime = objectState.unpackLong();
                this.lastActiveTime = new Date(oldtime);
            }
            catch (IOException ex) {
                this.lastActiveTime = new Date();
            }
        }
        return result;
    }

    @Override
    public boolean save_state(OutputObjectState objectState, int ot) {
        boolean result = super.save_state(objectState, ot);
        if (result) {
            this.lastActiveTime = new Date();
            try {
                objectState.packLong(this.lastActiveTime.getTime());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }
}

