/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.search.common.impl.AbstractElasticsearchCompositeNodeSearchQueryElementFactory;
import org.hibernate.search.backend.elasticsearch.search.common.impl.AbstractElasticsearchValueFieldSearchQueryElementFactory;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexCompositeNodeContext;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexNodeContext;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSingleFieldPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.ExistsPredicateBuilder;

public class ElasticsearchExistsPredicate
extends AbstractElasticsearchSingleFieldPredicate {
    private static final JsonObjectAccessor EXISTS_ACCESSOR = JsonAccessor.root().property("exists").asObject();
    private static final JsonAccessor<String> FIELD_ACCESSOR = JsonAccessor.root().property("field").asString();

    private ElasticsearchExistsPredicate(Builder builder) {
        super(builder);
    }

    @Override
    protected JsonObject doToJsonQuery(PredicateRequestContext context, JsonObject outerObject, JsonObject innerObject) {
        FIELD_ACCESSOR.set(innerObject, this.absoluteFieldPath);
        EXISTS_ACCESSOR.set(outerObject, innerObject);
        return outerObject;
    }

    private static class Builder
    extends AbstractElasticsearchSingleFieldPredicate.AbstractBuilder
    implements ExistsPredicateBuilder {
        Builder(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexNodeContext node) {
            super(scope, node);
        }

        public SearchPredicate build() {
            return new ElasticsearchExistsPredicate(this);
        }
    }

    public static class ObjectFieldFactory
    extends AbstractElasticsearchCompositeNodeSearchQueryElementFactory<ExistsPredicateBuilder> {
        public ExistsPredicateBuilder create(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexCompositeNodeContext node) {
            return new Builder(scope, node);
        }
    }

    public static class Factory<F>
    extends AbstractElasticsearchValueFieldSearchQueryElementFactory<ExistsPredicateBuilder, F> {
        @Override
        public ExistsPredicateBuilder create(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<F> field) {
            return new Builder(scope, field);
        }
    }
}

