/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.unstable.api.annotation.classpath.runtime.bytecode;

import java.util.Objects;
import java.util.Set;
import org.wildfly.unstable.api.annotation.classpath.index.RuntimeIndex;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.AnnotationUsage;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.AnnotationUsageType;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.AnnotationWithSourceClassUsage;

public class ExtendsAnnotatedClass
extends AnnotationWithSourceClassUsage {
    private final String superClass;

    ExtendsAnnotatedClass(Set<String> annotations, String clazz, String superClass) {
        super(annotations, AnnotationUsageType.EXTENDS_CLASS, clazz);
        this.superClass = superClass;
    }

    public String getSuperClass() {
        return this.superClass;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExtendsAnnotatedClass that = (ExtendsAnnotatedClass)o;
        return Objects.equals(this.superClass, that.superClass);
    }

    @Override
    protected int calculateHash() {
        return Objects.hash(super.calculateHash(), this.superClass);
    }

    @Override
    protected AnnotationUsage convertToDotFormat() {
        return new ExtendsAnnotatedClass((Set<String>)this.annotations, RuntimeIndex.convertClassNameToDotFormat(this.sourceClass), RuntimeIndex.convertClassNameToDotFormat(this.superClass));
    }
}

