/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.asyncclient;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.util.SystemPropertyAction;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HTTPConduitFactory;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.cxf.transport.http.asyncclient.AsyncHTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.ManagedNHttpClientConnectionFactory;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NHttpConnectionFactory;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.protocol.HttpContext;

@NoJSR250Annotations
public class AsyncHTTPConduitFactory
implements HTTPConduitFactory {
    public static final String TCP_NODELAY = "org.apache.cxf.transport.http.async.TCP_NODELAY";
    public static final String SO_KEEPALIVE = "org.apache.cxf.transport.http.async.SO_KEEPALIVE";
    public static final String SO_LINGER = "org.apache.cxf.transport.http.async.SO_LINGER";
    public static final String SO_TIMEOUT = "org.apache.cxf.transport.http.async.SO_TIMEOUT";
    public static final String MAX_CONNECTIONS = "org.apache.cxf.transport.http.async.MAX_CONNECTIONS";
    public static final String MAX_PER_HOST_CONNECTIONS = "org.apache.cxf.transport.http.async.MAX_PER_HOST_CONNECTIONS";
    public static final String CONNECTION_TTL = "org.apache.cxf.transport.http.async.CONNECTION_TTL";
    public static final String CONNECTION_MAX_IDLE = "org.apache.cxf.transport.http.async.CONNECTION_MAX_IDLE";
    public static final String THREAD_COUNT = "org.apache.cxf.transport.http.async.ioThreadCount";
    public static final String INTEREST_OP_QUEUED = "org.apache.cxf.transport.http.async.interestOpQueued";
    public static final String SELECT_INTERVAL = "org.apache.cxf.transport.http.async.selectInterval";
    public static final String USE_POLICY = "org.apache.cxf.transport.http.async.usePolicy";
    volatile PoolingNHttpClientConnectionManager connectionManager;
    volatile CloseableHttpAsyncClient client;
    boolean isShutdown;
    UseAsyncPolicy policy;
    int maxConnections = 5000;
    int maxPerRoute = 1000;
    int connectionTTL = 60000;
    int connectionMaxIdle = 60000;
    int ioThreadCount = IOReactorConfig.DEFAULT.getIoThreadCount();
    long selectInterval = IOReactorConfig.DEFAULT.getSelectInterval();
    boolean interestOpQueued = IOReactorConfig.DEFAULT.isInterestOpQueued();
    int soLinger = IOReactorConfig.DEFAULT.getSoLinger();
    int soTimeout = IOReactorConfig.DEFAULT.getSoTimeout();
    boolean soKeepalive = IOReactorConfig.DEFAULT.isSoKeepalive();
    boolean tcpNoDelay = true;

    AsyncHTTPConduitFactory() {
    }

    public AsyncHTTPConduitFactory(Map<String, Object> conf) {
        this();
        this.setProperties(conf);
    }

    public AsyncHTTPConduitFactory(Bus b) {
        this();
        this.addListener(b);
        this.setProperties(b.getProperties());
    }

    public UseAsyncPolicy getUseAsyncPolicy() {
        return this.policy;
    }

    public void update(Map<String, Object> props) {
        if (this.setProperties(props) && this.client != null) {
            this.restartReactor();
        }
    }

    private void restartReactor() {
        CloseableHttpAsyncClient client2 = this.client;
        this.resetVars();
        AsyncHTTPConduitFactory.shutdown(client2);
    }

    private synchronized void resetVars() {
        this.client = null;
        this.connectionManager = null;
    }

    private boolean setProperties(Map<String, Object> s) {
        if (s == null) {
            return false;
        }
        Object st = s.get(USE_POLICY);
        if (st == null) {
            st = SystemPropertyAction.getPropertyOrNull((String)USE_POLICY);
        }
        this.policy = UseAsyncPolicy.getPolicy(st);
        this.maxConnections = this.getInt(s.get(MAX_CONNECTIONS), this.maxConnections);
        this.connectionTTL = this.getInt(s.get(CONNECTION_TTL), this.connectionTTL);
        this.connectionMaxIdle = this.getInt(s.get(CONNECTION_MAX_IDLE), this.connectionMaxIdle);
        this.maxPerRoute = this.getInt(s.get(MAX_PER_HOST_CONNECTIONS), this.maxPerRoute);
        if (this.connectionManager != null) {
            this.connectionManager.setMaxTotal(this.maxConnections);
            this.connectionManager.setDefaultMaxPerRoute(this.maxPerRoute);
        }
        boolean changed = false;
        int i = this.ioThreadCount;
        this.ioThreadCount = this.getInt(s.get(THREAD_COUNT), Runtime.getRuntime().availableProcessors());
        changed |= i != this.ioThreadCount;
        long l = this.selectInterval;
        this.selectInterval = this.getInt(s.get(SELECT_INTERVAL), 1000);
        changed |= l != this.selectInterval;
        i = this.soLinger;
        this.soLinger = this.getInt(s.get(SO_LINGER), -1);
        changed |= i != this.soLinger;
        i = this.soTimeout;
        this.soTimeout = this.getInt(s.get(SO_TIMEOUT), 0);
        changed |= i != this.soTimeout;
        boolean b = this.interestOpQueued;
        this.interestOpQueued = this.getBoolean(s.get(INTEREST_OP_QUEUED), false);
        changed |= b != this.interestOpQueued;
        b = this.tcpNoDelay;
        this.tcpNoDelay = this.getBoolean(s.get(TCP_NODELAY), true);
        changed |= b != this.tcpNoDelay;
        b = this.soKeepalive;
        this.soKeepalive = this.getBoolean(s.get(SO_KEEPALIVE), false);
        return changed |= b != this.soKeepalive;
    }

    private int getInt(Object s, int defaultv) {
        int i = defaultv;
        if (s instanceof String) {
            i = Integer.parseInt((String)s);
        } else if (s instanceof Number) {
            i = ((Number)s).intValue();
        }
        if (i == -1) {
            i = defaultv;
        }
        return i;
    }

    private boolean getBoolean(Object s, boolean defaultv) {
        if (s instanceof String) {
            return Boolean.parseBoolean((String)s);
        }
        if (s instanceof Boolean) {
            return (Boolean)s;
        }
        return defaultv;
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    public HTTPConduit createConduit(HTTPTransportFactory f, Bus bus, EndpointInfo localInfo, EndpointReferenceType target) throws IOException {
        return this.createConduit(bus, localInfo, target);
    }

    public HTTPConduit createConduit(Bus bus, EndpointInfo localInfo, EndpointReferenceType target) throws IOException {
        if (this.isShutdown) {
            return null;
        }
        return new AsyncHTTPConduit(bus, localInfo, target, this);
    }

    public void shutdown() {
        if (this.client != null) {
            AsyncHTTPConduitFactory.shutdown(this.client);
            this.connectionManager = null;
            this.client = null;
        }
        this.isShutdown = true;
    }

    private static void shutdown(CloseableHttpAsyncClient client) {
        try {
            client.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private void addListener(Bus b) {
        BusLifeCycleManager manager = (BusLifeCycleManager)b.getExtension(BusLifeCycleManager.class);
        if (manager != null) {
            manager.registerLifeCycleListener(new BusLifeCycleListener(){

                public void initComplete() {
                }

                public void preShutdown() {
                    AsyncHTTPConduitFactory.this.shutdown();
                }

                public void postShutdown() {
                }
            });
        }
    }

    public synchronized void setupNIOClient(HTTPClientPolicy clientPolicy) throws IOReactorException {
        if (this.client != null) {
            return;
        }
        IOReactorConfig config = IOReactorConfig.custom().setIoThreadCount(this.ioThreadCount).setSelectInterval(this.selectInterval).setInterestOpQueued(this.interestOpQueued).setSoLinger(this.soLinger).setSoTimeout(this.soTimeout).setSoKeepAlive(this.soKeepalive).setTcpNoDelay(this.tcpNoDelay).build();
        Registry ioSessionFactoryRegistry = RegistryBuilder.create().register("http", (Object)NoopIOSessionStrategy.INSTANCE).register("https", (Object)SSLIOSessionStrategy.getSystemDefaultStrategy()).build();
        ManagedNHttpClientConnectionFactory connectionFactory = new ManagedNHttpClientConnectionFactory();
        DefaultConnectingIOReactor ioreactor = new DefaultConnectingIOReactor(config);
        this.connectionManager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioreactor, (NHttpConnectionFactory)connectionFactory, ioSessionFactoryRegistry, (SchemePortResolver)DefaultSchemePortResolver.INSTANCE, (DnsResolver)SystemDefaultDnsResolver.INSTANCE, (long)this.connectionTTL, TimeUnit.MILLISECONDS);
        this.connectionManager.setDefaultMaxPerRoute(this.maxPerRoute);
        this.connectionManager.setMaxTotal(this.maxConnections);
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setBufferSize(clientPolicy.getChunkLength() > 0 ? clientPolicy.getChunkLength() : 16332).build();
        this.connectionManager.setDefaultConnectionConfig(connectionConfig);
        RedirectStrategy redirectStrategy = new RedirectStrategy(){

            public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
                return false;
            }

            public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
                return null;
            }
        };
        HttpAsyncClientBuilder httpAsyncClientBuilder = HttpAsyncClients.custom().setConnectionManager((NHttpClientConnectionManager)this.connectionManager).setRedirectStrategy(redirectStrategy).setDefaultCookieStore((CookieStore)new BasicCookieStore(){
            private static final long serialVersionUID = 1L;

            public void addCookie(Cookie cookie) {
            }
        });
        this.adaptClientBuilder(httpAsyncClientBuilder);
        this.client = httpAsyncClientBuilder.build();
        this.client.start();
        new CloseIdleConnectionThread(this.connectionManager, this.client).start();
    }

    protected void adaptClientBuilder(HttpAsyncClientBuilder httpAsyncClientBuilder) {
    }

    public CloseableHttpAsyncClient createClient(AsyncHTTPConduit c) throws IOException {
        if (this.client == null) {
            this.setupNIOClient(c.getClient());
        }
        return this.client;
    }

    public static enum UseAsyncPolicy {
        ALWAYS,
        ASYNC_ONLY,
        NEVER;


        public static UseAsyncPolicy getPolicy(Object st) {
            if (st instanceof UseAsyncPolicy) {
                return (UseAsyncPolicy)((Object)st);
            }
            if (st instanceof String) {
                String s = ((String)st).toUpperCase();
                if ("ALWAYS".equals(s)) {
                    return ALWAYS;
                }
                if ("NEVER".equals(s)) {
                    return NEVER;
                }
                if ("ASYNC_ONLY".equals(s)) {
                    return ASYNC_ONLY;
                }
                st = Boolean.parseBoolean(s);
            }
            if (st instanceof Boolean) {
                return (Boolean)st != false ? ALWAYS : NEVER;
            }
            return ASYNC_ONLY;
        }
    }

    public class CloseIdleConnectionThread
    extends Thread {
        private final PoolingNHttpClientConnectionManager connMgr;
        private final CloseableHttpAsyncClient client;

        public CloseIdleConnectionThread(PoolingNHttpClientConnectionManager connMgr, CloseableHttpAsyncClient client) {
            super("CXFCloseIdleConnectionThread");
            this.connMgr = connMgr;
            this.client = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            long nextIdleCheck = System.currentTimeMillis() + (long)AsyncHTTPConduitFactory.this.connectionMaxIdle;
            try {
                while (this.client.isRunning()) {
                    CloseIdleConnectionThread closeIdleConnectionThread = this;
                    synchronized (closeIdleConnectionThread) {
                        CloseIdleConnectionThread.sleep(AsyncHTTPConduitFactory.this.selectInterval);
                        this.connMgr.validatePendingRequests();
                        if (AsyncHTTPConduitFactory.this.connectionTTL == 0 && AsyncHTTPConduitFactory.this.connectionMaxIdle > 0 && System.currentTimeMillis() >= nextIdleCheck) {
                            nextIdleCheck += (long)AsyncHTTPConduitFactory.this.connectionMaxIdle;
                            this.connMgr.closeIdleConnections((long)AsyncHTTPConduitFactory.this.connectionMaxIdle, TimeUnit.MILLISECONDS);
                        }
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

