/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.dd;

import java.util.Collection;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.deployment.processors.dd.AbstractEjbXmlDescriptorProcessor;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.metadata.ejb.spec.BusinessLocalsMetaData;
import org.jboss.metadata.ejb.spec.BusinessRemotesMetaData;
import org.jboss.metadata.ejb.spec.SessionBean31MetaData;
import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
import org.jboss.metadata.javaee.spec.RemoteEnvironment;

public class SessionBeanXmlDescriptorProcessor
extends AbstractEjbXmlDescriptorProcessor<SessionBeanMetaData> {
    private final boolean appclient;

    public SessionBeanXmlDescriptorProcessor(boolean appclient) {
        this.appclient = appclient;
    }

    @Override
    protected Class<SessionBeanMetaData> getMetaDataType() {
        return SessionBeanMetaData.class;
    }

    @Override
    protected void processBeanMetaData(SessionBeanMetaData sessionBean, DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        BusinessRemotesMetaData businessRemotes;
        String remote;
        String local;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        String beanName = sessionBean.getName();
        ComponentDescription bean = moduleDescription.getComponentByName(beanName);
        if (this.appclient && bean == null) {
            for (ComponentDescription component : deploymentUnit.getAttachmentList(Attachments.ADDITIONAL_RESOLVABLE_COMPONENTS)) {
                if (!component.getComponentName().equals(beanName)) continue;
                bean = component;
                break;
            }
        }
        if (!(bean instanceof SessionBeanComponentDescription)) {
            return;
        }
        SessionBeanComponentDescription sessionBeanDescription = (SessionBeanComponentDescription)bean;
        sessionBeanDescription.setDeploymentDescriptorEnvironment(new DeploymentDescriptorEnvironment("java:comp/env/", (RemoteEnvironment)sessionBean));
        sessionBeanDescription.setMappedName(sessionBean.getMappedName());
        BusinessLocalsMetaData businessLocals = sessionBean.getBusinessLocals();
        if (businessLocals != null && !businessLocals.isEmpty()) {
            sessionBeanDescription.addLocalBusinessInterfaceViews((Collection<String>)businessLocals);
        }
        if ((local = sessionBean.getLocal()) != null) {
            sessionBeanDescription.addEjbLocalObjectView(local);
        }
        if ((remote = sessionBean.getRemote()) != null) {
            sessionBeanDescription.addEjbObjectView(remote);
        }
        if ((businessRemotes = sessionBean.getBusinessRemotes()) != null && !businessRemotes.isEmpty()) {
            sessionBeanDescription.addRemoteBusinessInterfaceViews((Collection<String>)businessRemotes);
        }
        if (sessionBean instanceof SessionBean31MetaData) {
            this.processSessionBean31((SessionBean31MetaData)sessionBean, sessionBeanDescription);
        }
    }

    private void processSessionBean31(SessionBean31MetaData sessionBean31MetaData, SessionBeanComponentDescription sessionBeanComponentDescription) {
        if (sessionBean31MetaData.isNoInterfaceBean()) {
            sessionBeanComponentDescription.addNoInterfaceView();
        }
    }
}

