/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.services.path.PathInfoHandler;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.server.deployment.scanner.DeploymentScannerAdd;
import org.jboss.as.server.deployment.scanner.DeploymentScannerExtension;
import org.jboss.as.server.deployment.scanner.DeploymentScannerRemove;
import org.jboss.as.server.deployment.scanner.FileSystemDeploymentScanHandler;
import org.jboss.as.server.deployment.scanner.UpdateScannerWriteAttributeHandler;
import org.jboss.as.server.deployment.scanner.WritePathAttributeHandler;
import org.jboss.as.server.deployment.scanner.WriteRelativeToAttributeHandler;
import org.jboss.as.server.deployment.scanner.api.DeploymentScanner;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DeploymentScannerDefinition
extends SimpleResourceDefinition {
    static final RuntimeCapability<Void> SCANNER_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.management.deployment-scanner", (boolean)true, DeploymentScanner.class).addRequirements(new String[]{PathManager.SERVICE_DESCRIPTOR.getName()}).build();
    private final PathManager pathManager;
    protected static final SimpleAttributeDefinition NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("name", ModelType.STRING, false).setXmlName("name")).setAllowExpression(false)).setValidator((ParameterValidator)new StringLengthValidator(1))).build();
    protected static final SimpleAttributeDefinition PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("path", ModelType.STRING, false).setXmlName("path")).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, true))).addArbitraryDescriptor("filesystem-path", ModelNode.TRUE)).build();
    protected static final SimpleAttributeDefinition RELATIVE_TO = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("relative-to", ModelType.STRING, true).setXmlName("relative-to")).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false))).setCapabilityReference(PathManager.PATH_SERVICE_DESCRIPTOR.getName())).build();
    protected static final SimpleAttributeDefinition SCAN_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("scan-enabled", ModelType.BOOLEAN, true).setXmlName("scan-enabled")).setAllowExpression(true)).setDefaultValue(ModelNode.TRUE)).build();
    protected static final SimpleAttributeDefinition SCAN_INTERVAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("scan-interval", ModelType.INT, true).setXmlName("scan-interval")).setAllowExpression(true)).setDefaultValue(ModelNode.ZERO)).build();
    protected static final SimpleAttributeDefinition AUTO_DEPLOY_ZIPPED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("auto-deploy-zipped", ModelType.BOOLEAN, true).setXmlName("auto-deploy-zipped")).setDefaultValue(ModelNode.TRUE)).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition AUTO_DEPLOY_EXPLODED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("auto-deploy-exploded", ModelType.BOOLEAN, true).setXmlName("auto-deploy-exploded")).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).build();
    protected static final SimpleAttributeDefinition AUTO_DEPLOY_XML = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("auto-deploy-xml", ModelType.BOOLEAN, true).setXmlName("auto-deploy-xml")).setAllowExpression(true)).setDefaultValue(ModelNode.TRUE)).build();
    protected static final SimpleAttributeDefinition DEPLOYMENT_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("deployment-timeout", ModelType.LONG, true).setXmlName("deployment-timeout")).setAllowExpression(true)).setDefaultValue(new ModelNode().set(600))).build();
    protected static final SimpleAttributeDefinition RUNTIME_FAILURE_CAUSES_ROLLBACK = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("runtime-failure-causes-rollback", ModelType.BOOLEAN, true).setXmlName("runtime-failure-causes-rollback")).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).build();
    protected static final SimpleAttributeDefinition[] ALL_ATTRIBUTES = new SimpleAttributeDefinition[]{PATH, RELATIVE_TO, SCAN_ENABLED, SCAN_INTERVAL, AUTO_DEPLOY_EXPLODED, AUTO_DEPLOY_XML, AUTO_DEPLOY_ZIPPED, DEPLOYMENT_TIMEOUT, RUNTIME_FAILURE_CAUSES_ROLLBACK};

    DeploymentScannerDefinition(PathManager pathManager) {
        super(new SimpleResourceDefinition.Parameters(DeploymentScannerExtension.SCANNERS_PATH, DeploymentScannerExtension.getResourceDescriptionResolver("deployment.scanner")).setAddHandler((OperationStepHandler)new DeploymentScannerAdd(pathManager)).setRemoveHandler((OperationStepHandler)DeploymentScannerRemove.INSTANCE).setCapabilities(new RuntimeCapability[]{SCANNER_CAPABILITY}));
        this.pathManager = pathManager;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)PATH, null, (OperationStepHandler)new WritePathAttributeHandler(this.pathManager));
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)RELATIVE_TO, null, (OperationStepHandler)new WriteRelativeToAttributeHandler(this.pathManager));
        UpdateScannerWriteAttributeHandler commonHandler = new UpdateScannerWriteAttributeHandler();
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)SCAN_ENABLED, null, (OperationStepHandler)commonHandler);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)SCAN_INTERVAL, null, (OperationStepHandler)commonHandler);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)AUTO_DEPLOY_ZIPPED, null, (OperationStepHandler)commonHandler);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)AUTO_DEPLOY_EXPLODED, null, (OperationStepHandler)commonHandler);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)AUTO_DEPLOY_XML, null, (OperationStepHandler)commonHandler);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)DEPLOYMENT_TIMEOUT, null, (OperationStepHandler)commonHandler);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)RUNTIME_FAILURE_CAUSES_ROLLBACK, null, (OperationStepHandler)commonHandler);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler(FileSystemDeploymentScanHandler.DEFINITION, (OperationStepHandler)FileSystemDeploymentScanHandler.INSTANCE);
        PathInfoHandler.registerOperation((ManagementResourceRegistration)resourceRegistration, (PathInfoHandler)PathInfoHandler.Builder.of((PathManager)this.pathManager).addAttribute((AttributeDefinition)PATH, (AttributeDefinition)RELATIVE_TO).build());
    }
}

