/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs.util.automount;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSLogger;
import org.jboss.vfs.VFSMessages;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.util.PathTokenizer;
import org.jboss.vfs.util.automount.MountConfig;
import org.jboss.vfs.util.automount.MountOption;
import org.jboss.vfs.util.automount.MountOwner;
import org.jboss.vfs.util.automount.SimpleMountOwner;
import org.jboss.vfs.util.automount.VirtualFileOwner;

public class Automounter {
    private static final RegistryEntry rootEntry = new RegistryEntry();
    private static final ConcurrentMap<MountOwner, Set<RegistryEntry>> ownerReferences = new ConcurrentHashMap<MountOwner, Set<RegistryEntry>>();
    private static TempFileProvider tempFileProvider;

    private Automounter() {
    }

    public static void mount(VirtualFile target, MountOption ... mountOptions) throws IOException {
        Automounter.mount(new VirtualFileOwner(target), target, mountOptions);
    }

    public static void mount(Object owner, VirtualFile target, MountOption ... mountOptions) throws IOException {
        Automounter.mount(new SimpleMountOwner(owner), target, mountOptions);
    }

    public static void mount(VirtualFile owner, VirtualFile target, MountOption ... mountOptions) throws IOException {
        Automounter.mount(new VirtualFileOwner(owner), target, mountOptions);
    }

    public static void mount(MountOwner owner, VirtualFile target, MountOption ... mountOptions) throws IOException {
        RegistryEntry targetEntry = Automounter.getEntry(target);
        targetEntry.mount(target, Automounter.getMountConfig(mountOptions));
        targetEntry.inboundReferences.add(owner);
        ownerReferences.putIfAbsent(owner, new HashSet());
        ((Set)ownerReferences.get(owner)).add(targetEntry);
    }

    private static MountConfig getMountConfig(MountOption[] mountOptions) {
        MountConfig config = new MountConfig();
        for (MountOption option : mountOptions) {
            option.applyTo(config);
        }
        return config;
    }

    public static boolean addHandle(VirtualFile owner, Closeable handle) {
        RegistryEntry entry = Automounter.getEntry(owner);
        return entry.handles.add(handle);
    }

    public static boolean removeHandle(VirtualFile owner, Closeable handle) {
        RegistryEntry entry = Automounter.getEntry(owner);
        return entry.handles.remove(handle);
    }

    public static void cleanup(Object owner) {
        Automounter.cleanup(new SimpleMountOwner(owner));
    }

    public static void cleanup(VirtualFile owner) {
        Automounter.cleanup(new VirtualFileOwner(owner));
    }

    public static void cleanup(MountOwner owner) {
        Set references = (Set)ownerReferences.remove(owner);
        if (references != null) {
            for (RegistryEntry entry : references) {
                entry.removeInboundReference(owner);
            }
        }
        owner.onCleanup();
    }

    public static boolean isMounted(VirtualFile target) {
        return Automounter.getEntry(target).isMounted();
    }

    static RegistryEntry getEntry(VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw VFSMessages.MESSAGES.nullArgument("VirutalFile");
        }
        return rootEntry.find(virtualFile);
    }

    private static TempFileProvider getTempFileProvider() throws IOException {
        if (tempFileProvider == null) {
            tempFileProvider = TempFileProvider.create("automount", Executors.newScheduledThreadPool(2));
        }
        return tempFileProvider;
    }

    static class RegistryEntry {
        private final ConcurrentMap<String, RegistryEntry> children = new ConcurrentHashMap<String, RegistryEntry>();
        private final Set<MountOwner> inboundReferences = new HashSet<MountOwner>();
        private final List<Closeable> handles = new LinkedList<Closeable>();
        private final AtomicBoolean mounted = new AtomicBoolean();

        RegistryEntry() {
        }

        private void mount(VirtualFile target, MountConfig mountConfig) throws IOException {
            if (this.mounted.compareAndSet(false, true) && target.isFile()) {
                VFSLogger.ROOT_LOGGER.debugf("Automounting: %s with options %s", (Object)target, (Object)mountConfig);
                TempFileProvider provider = Automounter.getTempFileProvider();
                if (mountConfig.mountExpanded()) {
                    if (mountConfig.copyTarget()) {
                        this.handles.add(VFS.mountZipExpanded(target, target, provider));
                    } else {
                        this.handles.add(VFS.mountZipExpanded(target.getPhysicalFile(), target, provider));
                    }
                } else if (mountConfig.copyTarget()) {
                    this.handles.add(VFS.mountZip(target, target, provider));
                } else {
                    this.handles.add(VFS.mountZip(target.getPhysicalFile(), target, provider));
                }
            }
        }

        private void removeInboundReference(MountOwner owner) {
            this.inboundReferences.remove(owner);
            if (this.inboundReferences.isEmpty()) {
                this.cleanup();
            }
        }

        void cleanup() {
            if (this.mounted.compareAndSet(true, false)) {
                VFSUtils.safeClose(this.handles);
                this.handles.clear();
                Collection<RegistryEntry> entries = this.getEntriesRecursive();
                for (RegistryEntry entry : entries) {
                    entry.cleanup();
                }
            }
        }

        private boolean isMounted() {
            return this.mounted.get();
        }

        private RegistryEntry find(VirtualFile file) {
            return this.find(PathTokenizer.getTokens(file.getPathName()));
        }

        private RegistryEntry find(List<String> path) {
            if (path.isEmpty()) {
                return this;
            }
            String current = path.remove(0);
            this.children.putIfAbsent(current, new RegistryEntry());
            RegistryEntry childEntry = (RegistryEntry)this.children.get(current);
            return childEntry.find(path);
        }

        private Collection<RegistryEntry> getEntriesRecursive() {
            LinkedList<RegistryEntry> allHandles = new LinkedList<RegistryEntry>();
            this.collectEntries(this, allHandles);
            return allHandles;
        }

        private void collectEntries(RegistryEntry registryEntry, List<RegistryEntry> entries) {
            for (RegistryEntry childEntry : registryEntry.children.values()) {
                this.collectEntries(childEntry, entries);
                entries.add(childEntry);
            }
        }
    }
}

