/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aesh.command.Command;
import org.aesh.command.container.CommandContainer;
import org.aesh.command.impl.container.AeshCommandContainer;
import org.aesh.command.impl.internal.ProcessedCommand;
import org.aesh.command.impl.internal.ProcessedCommandBuilder;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.internal.ProcessedOptionBuilder;
import org.aesh.command.impl.parser.AeshCommandLineParser;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.parser.OptionParserException;
import org.aesh.command.populator.CommandPopulator;
import org.aesh.command.result.ResultHandler;
import org.aesh.command.validator.CommandValidator;
import org.aesh.util.ReflectionUtil;

public class CommandBuilder<C extends Command<CommandInvocation>> {
    private String name;
    private String description;
    private C command;
    private CommandValidator<C, CommandInvocation> validator;
    private ResultHandler resultHandler;
    private ProcessedOption argument;
    private List<ProcessedOption> options;
    private List<CommandBuilder> children;
    private CommandLineParserException parserException;
    private CommandPopulator<Object, CommandInvocation> populator;
    private List<String> aliases;

    private CommandBuilder() {
    }

    public static <T extends Command<CommandInvocation>> CommandBuilder<T> builder() {
        return new CommandBuilder();
    }

    public CommandBuilder<C> name(String name) {
        this.name = name;
        return this;
    }

    public CommandBuilder<C> aliases(List<String> aliases) {
        this.aliases = aliases == null ? Collections.emptyList() : Collections.unmodifiableList(aliases);
        return this;
    }

    public CommandBuilder<C> description(String description) {
        this.description = description;
        return this;
    }

    public CommandBuilder<C> command(C command) {
        this.command = command;
        return this;
    }

    public CommandBuilder<C> command(Class<C> command) {
        this.command = (Command)ReflectionUtil.newInstance(command);
        return this;
    }

    public CommandBuilder<C> validator(CommandValidator<C, CommandInvocation> commandValidator) {
        this.validator = commandValidator;
        return this;
    }

    public CommandBuilder<C> validator(Class<CommandValidator<C, CommandInvocation>> commandValidator) {
        this.validator = ReflectionUtil.newInstance(commandValidator);
        return this;
    }

    public CommandBuilder<C> populator(CommandPopulator<Object, CommandInvocation> populator) {
        this.populator = populator;
        return this;
    }

    public CommandBuilder<C> resultHandler(ResultHandler resultHandler) {
        this.resultHandler = resultHandler;
        return this;
    }

    public CommandBuilder<C> resultHandler(Class<ResultHandler> resultHandler) {
        this.resultHandler = ReflectionUtil.newInstance(resultHandler);
        return this;
    }

    public CommandBuilder<C> argument(ProcessedOption argument) {
        this.argument = argument;
        return this;
    }

    public CommandBuilder<C> addOption(ProcessedOption option) {
        if (this.options == null) {
            this.options = new ArrayList<ProcessedOption>();
        }
        this.options.add(option);
        return this;
    }

    public CommandBuilder<C> addOption(ProcessedOptionBuilder option) {
        if (this.options == null) {
            this.options = new ArrayList<ProcessedOption>();
        }
        try {
            this.options.add(option.build());
        }
        catch (OptionParserException ope) {
            this.parserException = ope;
        }
        return this;
    }

    public CommandBuilder<C> addOptions(List<ProcessedOption> options) {
        if (this.options == null) {
            this.options = new ArrayList<ProcessedOption>();
        }
        this.options.addAll(options);
        return this;
    }

    public CommandBuilder<C> addChild(CommandBuilder child) {
        if (this.children == null) {
            this.children = new ArrayList<CommandBuilder>();
        }
        this.children.add(child);
        return this;
    }

    public CommandBuilder<C> addChildren(List<CommandBuilder> children) {
        if (this.children == null) {
            this.children = new ArrayList<CommandBuilder>();
        }
        this.children.addAll(children);
        return this;
    }

    public CommandContainer<CommandInvocation> create() {
        try {
            if (this.parserException != null) {
                return new AeshCommandContainer<CommandInvocation>(this.parserException.getMessage());
            }
            return new AeshCommandContainer<CommandInvocation>(this.createParser());
        }
        catch (CommandLineParserException e) {
            return new AeshCommandContainer<CommandInvocation>(e.getMessage());
        }
    }

    private AeshCommandLineParser<CommandInvocation> createParser() throws CommandLineParserException {
        if (this.command == null) {
            throw new CommandLineParserException("Command object is null, cannot build command");
        }
        ProcessedCommand<Command<CommandInvocation>, CommandInvocation> processedCommand = this.createProcessedCommand();
        AeshCommandLineParser<CommandInvocation> parser = new AeshCommandLineParser<CommandInvocation>(processedCommand);
        if (this.children != null) {
            for (CommandBuilder builder : this.children) {
                parser.addChildParser(builder.createParser());
            }
        }
        return parser;
    }

    private ProcessedCommand<Command<CommandInvocation>, CommandInvocation> createProcessedCommand() throws CommandLineParserException {
        return ProcessedCommandBuilder.builder().name(this.name).aliases(this.aliases).command(this.command).description(this.description).addOptions(this.options).resultHandler(this.resultHandler).validator(this.validator).arguments(this.argument).populator(this.populator).create();
    }
}

