/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.sort.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.lowlevel.syntax.search.impl.ElasticsearchSearchSyntax;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateNestingContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.AbstractElasticsearchReversibleSort;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortCollector;
import org.hibernate.search.engine.search.common.SortMode;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

abstract class AbstractElasticsearchDocumentValueSort
extends AbstractElasticsearchReversibleSort {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final JsonAccessor<JsonElement> MODE_ACCESSOR = JsonAccessor.root().property("mode");
    private static final JsonPrimitive SUM_KEYWORD_JSON = new JsonPrimitive("sum");
    private static final JsonPrimitive AVG_KEYWORD_JSON = new JsonPrimitive("avg");
    private static final JsonPrimitive MIN_KEYWORD_JSON = new JsonPrimitive("min");
    private static final JsonPrimitive MAX_KEYWORD_JSON = new JsonPrimitive("max");
    private static final JsonPrimitive MEDIAN_KEYWORD_JSON = new JsonPrimitive("median");
    protected final String absoluteFieldPath;
    protected final List<String> nestedPathHierarchy;
    protected final ElasticsearchSearchSyntax searchSyntax;
    private final JsonPrimitive mode;
    private final ElasticsearchSearchPredicate filter;

    AbstractElasticsearchDocumentValueSort(AbstractBuilder<?> builder) {
        super(builder);
        this.absoluteFieldPath = builder.field.absolutePath();
        this.nestedPathHierarchy = builder.nestedPathHierarchy;
        this.searchSyntax = builder.searchSyntax;
        this.mode = builder.mode;
        this.filter = builder.filter;
    }

    @Override
    protected void enrichInnerObject(ElasticsearchSearchSortCollector collector, JsonObject innerObject) {
        if (!this.nestedPathHierarchy.isEmpty()) {
            JsonObject jsonFilter = this.getJsonFilter(collector.getRootPredicateContext());
            this.searchSyntax.requestNestedSort(this.nestedPathHierarchy, innerObject, jsonFilter);
        }
        if (this.mode != null) {
            MODE_ACCESSOR.set(innerObject, (JsonElement)this.mode);
        }
    }

    private JsonObject getJsonFilter(PredicateRequestContext rootPredicateContext) {
        if (this.filter == null) {
            return null;
        }
        String lastNestedPath = this.nestedPathHierarchy.get(this.nestedPathHierarchy.size() - 1);
        PredicateRequestContext filterContext = rootPredicateContext.withNestedPath(lastNestedPath);
        return this.filter.toJsonQuery(filterContext);
    }

    static abstract class AbstractBuilder<F>
    extends AbstractElasticsearchReversibleSort.AbstractBuilder {
        private final ElasticsearchSearchSyntax searchSyntax;
        protected final ElasticsearchSearchIndexValueFieldContext<F> field;
        protected final List<String> nestedPathHierarchy;
        private JsonPrimitive mode;
        private ElasticsearchSearchPredicate filter;

        AbstractBuilder(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<F> field) {
            super(scope);
            this.searchSyntax = scope.searchSyntax();
            this.field = field;
            this.nestedPathHierarchy = field.nestedPathHierarchy();
        }

        public void mode(SortMode mode) {
            if (!this.nestedPathHierarchy.isEmpty() && SortMode.MEDIAN.equals((Object)mode)) {
                throw log.invalidSortModeAcrossNested(mode, this.field.eventContext());
            }
            if (mode != null) {
                switch (mode) {
                    case SUM: {
                        this.mode = SUM_KEYWORD_JSON;
                        break;
                    }
                    case AVG: {
                        this.mode = AVG_KEYWORD_JSON;
                        break;
                    }
                    case MIN: {
                        this.mode = MIN_KEYWORD_JSON;
                        break;
                    }
                    case MAX: {
                        this.mode = MAX_KEYWORD_JSON;
                        break;
                    }
                    case MEDIAN: {
                        this.mode = MEDIAN_KEYWORD_JSON;
                        break;
                    }
                    default: {
                        throw new AssertionFailure("Unexpected sort mode: " + mode);
                    }
                }
            }
        }

        public void filter(SearchPredicate filter) {
            if (this.nestedPathHierarchy.isEmpty()) {
                throw log.cannotFilterSortOnRootDocumentField(this.field.absolutePath(), this.field.eventContext());
            }
            ElasticsearchSearchPredicate elasticsearchFilter = ElasticsearchSearchPredicate.from(this.scope, filter);
            elasticsearchFilter.checkNestableWithin(PredicateNestingContext.nested(this.nestedPathHierarchy.get(this.nestedPathHierarchy.size() - 1)));
            this.filter = elasticsearchFilter;
        }
    }
}

