/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.glassfish.enterprise.concurrent.spi.TransactionHandle;
import org.glassfish.enterprise.concurrent.spi.TransactionSetupProvider;
import org.jboss.as.ee.logging.EeLogger;
import org.wildfly.transaction.client.ContextTransactionManager;

public class TransactionSetupProviderImpl
implements TransactionSetupProvider {
    private final transient TransactionManager transactionManager = ContextTransactionManager.getInstance();

    public TransactionHandle beforeProxyMethod(String transactionExecutionProperty) {
        Transaction transaction = null;
        if (!"USE_TRANSACTION_OF_EXECUTION_THREAD".equals(transactionExecutionProperty)) {
            try {
                transaction = this.transactionManager.suspend();
            }
            catch (Throwable e) {
                EeLogger.ROOT_LOGGER.debug("failed to suspend transaction", e);
            }
        }
        return new TransactionHandleImpl(transaction);
    }

    public void afterProxyMethod(TransactionHandle transactionHandle, String transactionExecutionProperty) {
        Transaction transaction = ((TransactionHandleImpl)transactionHandle).getTransaction();
        if (transaction != null) {
            try {
                this.transactionManager.resume(transaction);
            }
            catch (Throwable e) {
                EeLogger.ROOT_LOGGER.debug("failed to resume transaction", e);
            }
        }
    }

    private static class TransactionHandleImpl
    implements TransactionHandle {
        private final Transaction transaction;

        private TransactionHandleImpl(Transaction transaction) {
            this.transaction = transaction;
        }

        public Transaction getTransaction() {
            return this.transaction;
        }
    }
}

