/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent.service;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.glassfish.enterprise.concurrent.AbstractManagedExecutorService;
import org.glassfish.enterprise.concurrent.ContextServiceImpl;
import org.glassfish.enterprise.concurrent.ManagedScheduledExecutorServiceAdapter;
import org.jboss.as.ee.concurrent.ManagedScheduledExecutorServiceImpl;
import org.jboss.as.ee.concurrent.ManagedThreadFactoryImpl;
import org.jboss.as.ee.concurrent.service.DelegatingSupplier;
import org.jboss.as.ee.concurrent.service.EEConcurrentAbstractService;
import org.jboss.as.ee.concurrent.service.ManagedExecutorHungTasksPeriodicTerminationService;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.requestcontroller.ControlPoint;
import org.wildfly.extension.requestcontroller.RequestController;

public class ManagedScheduledExecutorServiceService
extends EEConcurrentAbstractService<ManagedScheduledExecutorServiceAdapter> {
    private volatile ManagedScheduledExecutorServiceImpl executorService;
    private final Consumer<ManagedScheduledExecutorServiceAdapter> consumer;
    private final String name;
    private final Supplier<ManagedThreadFactoryImpl> managedThreadFactorySupplier;
    private final long hungTaskThreshold;
    private final long hungTaskTerminationPeriod;
    private final boolean longRunningTasks;
    private final int corePoolSize;
    private final long keepAliveTime;
    private final TimeUnit keepAliveTimeUnit;
    private final long threadLifeTime;
    private final DelegatingSupplier<ContextServiceImpl> contextServiceSupplier = new DelegatingSupplier();
    private final AbstractManagedExecutorService.RejectPolicy rejectPolicy;
    private final Integer threadPriority;
    private final Supplier<RequestController> requestControllerSupplier;
    private ControlPoint controlPoint;
    private final Supplier<ManagedExecutorHungTasksPeriodicTerminationService> hungTasksPeriodicTerminationService;
    private Future hungTasksPeriodicTerminationFuture;

    public ManagedScheduledExecutorServiceService(Consumer<ManagedScheduledExecutorServiceAdapter> consumer, Supplier<ContextServiceImpl> contextServiceSupplier, Supplier<ManagedThreadFactoryImpl> managedThreadFactorySupplier, Supplier<RequestController> requestControllerSupplier, String name, String jndiName, long hungTaskThreshold, long hungTaskTerminationPeriod, boolean longRunningTasks, int corePoolSize, long keepAliveTime, TimeUnit keepAliveTimeUnit, long threadLifeTime, AbstractManagedExecutorService.RejectPolicy rejectPolicy, Integer threadPriority, Supplier<ManagedExecutorHungTasksPeriodicTerminationService> hungTasksPeriodicTerminationService) {
        super(jndiName);
        this.consumer = consumer;
        this.contextServiceSupplier.set(contextServiceSupplier);
        this.managedThreadFactorySupplier = managedThreadFactorySupplier;
        this.requestControllerSupplier = requestControllerSupplier;
        this.name = name;
        this.hungTaskThreshold = hungTaskThreshold;
        this.hungTaskTerminationPeriod = hungTaskTerminationPeriod;
        this.longRunningTasks = longRunningTasks;
        this.corePoolSize = corePoolSize;
        this.keepAliveTime = keepAliveTime;
        this.keepAliveTimeUnit = keepAliveTimeUnit;
        this.threadLifeTime = threadLifeTime;
        this.rejectPolicy = rejectPolicy;
        this.threadPriority = threadPriority;
        this.hungTasksPeriodicTerminationService = hungTasksPeriodicTerminationService;
    }

    @Override
    void startValue(StartContext context) throws StartException {
        ManagedThreadFactoryImpl managedThreadFactory;
        int priority;
        if (this.threadPriority != null) {
            priority = this.threadPriority;
        } else {
            managedThreadFactory = this.managedThreadFactorySupplier != null ? this.managedThreadFactorySupplier.get() : null;
            priority = managedThreadFactory != null ? managedThreadFactory.getPriority() : 5;
        }
        managedThreadFactory = new ManagedThreadFactoryImpl("EE-ManagedScheduledExecutorService-" + this.name, null, priority);
        if (this.requestControllerSupplier != null) {
            RequestController requestController = this.requestControllerSupplier.get();
            this.controlPoint = requestController != null ? requestController.getControlPoint(this.name, "managed-scheduled-executor-service") : null;
        }
        this.executorService = new ManagedScheduledExecutorServiceImpl(this.name, managedThreadFactory, this.hungTaskThreshold, this.longRunningTasks, this.corePoolSize, this.keepAliveTime, this.keepAliveTimeUnit, this.threadLifeTime, this.contextServiceSupplier != null ? this.contextServiceSupplier.get() : null, this.rejectPolicy, this.controlPoint);
        if (this.hungTaskThreshold > 0L && this.hungTaskTerminationPeriod > 0L) {
            this.hungTasksPeriodicTerminationFuture = this.hungTasksPeriodicTerminationService.get().startHungTaskPeriodicTermination(this.executorService, this.hungTaskTerminationPeriod);
        }
    }

    @Override
    void stopValue(StopContext context) {
        if (this.executorService != null) {
            if (this.hungTasksPeriodicTerminationFuture != null) {
                this.hungTasksPeriodicTerminationFuture.cancel(true);
            }
            this.executorService.shutdownNow();
            this.executorService.getManagedThreadFactory().stop();
            this.executorService = null;
        }
        if (this.controlPoint != null) {
            this.requestControllerSupplier.get().removeControlPoint(this.controlPoint);
        }
    }

    public ManagedScheduledExecutorServiceAdapter getValue() throws IllegalStateException {
        return this.getExecutorService().getAdapter();
    }

    public ManagedScheduledExecutorServiceImpl getExecutorService() throws IllegalStateException {
        if (this.executorService == null) {
            throw EeLogger.ROOT_LOGGER.concurrentServiceValueUninitialized();
        }
        return this.executorService;
    }

    public DelegatingSupplier<ContextServiceImpl> getContextServiceSupplier() {
        return this.contextServiceSupplier;
    }
}

