/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.managedbean.processors;

import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.filter.PathFilters;

public class JavaEEDependencyProcessor
implements DeploymentUnitProcessor {
    private static String JBOSS_INVOCATION_ID = "org.jboss.invocation";
    private static String JBOSS_AS_EE = "org.jboss.as.ee";
    private static final String[] JAVA_EE_API_MODULES = new String[]{"jakarta.annotation.api", "jakarta.enterprise.concurrent.api", "jakarta.interceptor.api", "jakarta.json.api", "jakarta.json.bind.api", "jakarta.resource.api", "javax.rmi.api", "jakarta.xml.bind.api", "org.glassfish.javax.el", "org.glassfish.javax.enterprise.concurrent"};

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        ModuleDependency invocation = new ModuleDependency(moduleLoader, JBOSS_INVOCATION_ID, false, false, false, false);
        invocation.addImportFilter(PathFilters.is((String)"org/jboss/invocation/proxy/classloading"), true);
        invocation.addImportFilter(PathFilters.acceptAll(), false);
        moduleSpecification.addSystemDependency(invocation);
        ModuleDependency ee = new ModuleDependency(moduleLoader, JBOSS_AS_EE, false, false, false, false);
        ee.addImportFilter(PathFilters.is((String)"org/jboss/as/ee/component/serialization"), true);
        ee.addImportFilter(PathFilters.is((String)"org/jboss/as/ee/concurrent"), true);
        ee.addImportFilter(PathFilters.is((String)"org/jboss/as/ee/concurrent/handle"), true);
        ee.addImportFilter(PathFilters.acceptAll(), false);
        moduleSpecification.addSystemDependency(ee);
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, "org.wildfly.naming", false, false, false, false));
        for (String moduleIdentifier : JAVA_EE_API_MODULES) {
            moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, moduleIdentifier, true, false, true, false));
        }
    }
}

