/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.persistence.filestore;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.timerservice.CalendarTimer;
import org.jboss.as.ejb3.timerservice.TimerImpl;
import org.jboss.as.ejb3.timerservice.TimerServiceImpl;
import org.jboss.as.ejb3.timerservice.persistence.CalendarTimerEntity;
import org.jboss.as.ejb3.timerservice.persistence.TimerEntity;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.InputStreamByteInput;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.Unmarshaller;

public class LegacyFileStore {
    public static final String MIGRATION_MARKER = "migrated-to-xml.marker";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, TimerImpl> loadTimersFromFile(String timedObjectId, TimerServiceImpl timerService, String directory, MarshallerFactory factory, MarshallingConfiguration configuration) {
        HashMap<String, TimerImpl> timers;
        block23: {
            timers = new HashMap<String, TimerImpl>();
            try {
                File file = new File(directory);
                if (!file.exists()) {
                    return timers;
                }
                if (!file.isDirectory()) {
                    EjbLogger.ROOT_LOGGER.failToRestoreTimers(file);
                    return timers;
                }
                File marker = new File(file, MIGRATION_MARKER);
                if (marker.exists()) {
                    return timers;
                }
                Unmarshaller unmarshaller = factory.createUnmarshaller(configuration);
                for (File timerFile : file.listFiles()) {
                    if (timerFile.getName().endsWith(".xml")) continue;
                    FileInputStream in = null;
                    try {
                        TimerImpl.Builder builder;
                        in = new FileInputStream(timerFile);
                        unmarshaller.start((ByteInput)new InputStreamByteInput((InputStream)in));
                        TimerEntity entity = (TimerEntity)unmarshaller.readObject(TimerEntity.class);
                        if (entity instanceof CalendarTimerEntity) {
                            CalendarTimerEntity c = (CalendarTimerEntity)entity;
                            builder = CalendarTimer.builder().setScheduleExprSecond(c.getSecond()).setScheduleExprMinute(c.getMinute()).setScheduleExprHour(c.getHour()).setScheduleExprDayOfWeek(c.getDayOfWeek()).setScheduleExprDayOfMonth(c.getDayOfMonth()).setScheduleExprMonth(c.getMonth()).setScheduleExprYear(c.getYear()).setScheduleExprStartDate(c.getStartDate()).setScheduleExprEndDate(c.getEndDate()).setScheduleExprTimezone(c.getTimezone()).setAutoTimer(c.isAutoTimer()).setTimeoutMethod(CalendarTimer.getTimeoutMethod(c.getTimeoutMethod(), ((TimedObjectInvoker)timerService.getTimedObjectInvoker().getValue()).getClassLoader()));
                        } else {
                            builder = TimerImpl.builder();
                        }
                        builder.setId(entity.getId()).setTimedObjectId(entity.getTimedObjectId()).setInitialDate(entity.getInitialDate()).setRepeatInterval(entity.getInterval()).setNextDate(entity.getNextDate()).setPreviousRun(entity.getPreviousRun()).setInfo(entity.getInfo()).setPrimaryKey(entity.getPrimaryKey()).setTimerState(entity.getTimerState()).setPersistent(true);
                        timers.put(entity.getId(), builder.build(timerService));
                        unmarshaller.finish();
                    }
                    catch (Exception e) {
                        EjbLogger.ROOT_LOGGER.failToRestoreTimersFromFile(timerFile, e);
                    }
                    finally {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException e) {
                                EjbLogger.ROOT_LOGGER.failToCloseFile(e);
                            }
                        }
                    }
                }
                if (timers.isEmpty()) break block23;
                try (FileOutputStream out = new FileOutputStream(marker);){
                    out.write(new Date().toString().getBytes());
                }
            }
            catch (Exception e) {
                EjbLogger.ROOT_LOGGER.failToRestoreTimersForObjectId(timedObjectId, e);
            }
        }
        return timers;
    }
}

