/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.merging;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.metadata.MethodAnnotationAggregator;
import org.jboss.as.ee.metadata.RuntimeAnnotationInformation;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.processors.merging.AbstractMergingProcessor;
import org.jboss.as.ejb3.security.EJBMethodSecurityAttribute;
import org.jboss.as.ejb3.security.EjbJaccConfigurator;
import org.jboss.as.ejb3.util.MethodInfoHelper;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.metadata.ejb.spec.AssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.ejb.spec.ExcludeListMetaData;
import org.jboss.metadata.ejb.spec.MethodMetaData;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
import org.jboss.metadata.ejb.spec.MethodPermissionMetaData;
import org.jboss.metadata.ejb.spec.MethodPermissionsMetaData;
import org.jboss.metadata.ejb.spec.MethodsMetaData;

public class MethodPermissionsMergingProcessor
extends AbstractMergingProcessor<EJBComponentDescription> {
    public MethodPermissionsMergingProcessor() {
        super(EJBComponentDescription.class);
    }

    @Override
    protected void handleAnnotations(DeploymentUnit deploymentUnit, EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, EJBComponentDescription description) throws DeploymentUnitProcessingException {
        RuntimeAnnotationInformation permitData = MethodAnnotationAggregator.runtimeAnnotationInformation(componentClass, (EEApplicationClasses)applicationClasses, (DeploymentReflectionIndex)deploymentReflectionIndex, PermitAll.class);
        for (Map.Entry entry : permitData.getClassAnnotations().entrySet()) {
            description.getAnnotationMethodPermissions().setAttribute(null, (String)entry.getKey(), EJBMethodSecurityAttribute.permitAll());
        }
        for (Map.Entry entry : permitData.getMethodAnnotations().entrySet()) {
            Method method = (Method)entry.getKey();
            description.getAnnotationMethodPermissions().setAttribute(null, EJBMethodSecurityAttribute.permitAll(), method.getDeclaringClass().getName(), method.getName(), MethodInfoHelper.getCanonicalParameterTypes(method));
        }
        RuntimeAnnotationInformation data = MethodAnnotationAggregator.runtimeAnnotationInformation(componentClass, (EEApplicationClasses)applicationClasses, (DeploymentReflectionIndex)deploymentReflectionIndex, RolesAllowed.class);
        for (Map.Entry entry : data.getClassAnnotations().entrySet()) {
            description.getAnnotationMethodPermissions().setAttribute(null, (String)entry.getKey(), EJBMethodSecurityAttribute.rolesAllowed(new HashSet<Object>(Arrays.asList((Object[])((List)entry.getValue()).get(0)))));
        }
        for (Map.Entry entry : data.getMethodAnnotations().entrySet()) {
            Method method = (Method)entry.getKey();
            description.getAnnotationMethodPermissions().setAttribute(null, EJBMethodSecurityAttribute.rolesAllowed(new HashSet<Object>(Arrays.asList((Object[])((List)entry.getValue()).get(0)))), method.getDeclaringClass().getName(), method.getName(), MethodInfoHelper.getCanonicalParameterTypes(method));
        }
        RuntimeAnnotationInformation runtimeAnnotationInformation = MethodAnnotationAggregator.runtimeAnnotationInformation(componentClass, (EEApplicationClasses)applicationClasses, (DeploymentReflectionIndex)deploymentReflectionIndex, DenyAll.class);
        for (Map.Entry entry : runtimeAnnotationInformation.getClassAnnotations().entrySet()) {
            description.getAnnotationMethodPermissions().setAttribute(null, (String)entry.getKey(), EJBMethodSecurityAttribute.denyAll());
        }
        for (Map.Entry entry : runtimeAnnotationInformation.getMethodAnnotations().entrySet()) {
            Method method = (Method)entry.getKey();
            description.getAnnotationMethodPermissions().setAttribute(null, EJBMethodSecurityAttribute.denyAll(), method.getDeclaringClass().getName(), method.getName(), MethodInfoHelper.getCanonicalParameterTypes(method));
        }
    }

    @Override
    protected void handleDeploymentDescriptor(DeploymentUnit deploymentUnit, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, EJBComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        AssemblyDescriptorMetaData assemblyDescriptor;
        componentDescription.getConfigurators().add(new EjbJaccConfigurator());
        EjbJarMetaData ejbJarMetadata = (EjbJarMetaData)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        if (ejbJarMetadata != null && (assemblyDescriptor = ejbJarMetadata.getAssemblyDescriptor()) != null) {
            MethodPermissionsMetaData methodPermissions;
            ExcludeListMetaData excludeList = assemblyDescriptor.getExcludeListByEjbName(componentDescription.getEJBName());
            if (excludeList != null && excludeList.getMethods() != null) {
                for (MethodMetaData method : excludeList.getMethods()) {
                    String methodName = method.getMethodName();
                    MethodIntf defaultMethodIntf = componentDescription instanceof MessageDrivenComponentDescription ? MethodIntf.MESSAGE_ENDPOINT : MethodIntf.BEAN;
                    MethodIntf methodIntf = this.getMethodIntf(method.getMethodIntf(), defaultMethodIntf);
                    if (methodName.equals("*")) {
                        componentDescription.getDescriptorMethodPermissions().setAttribute(methodIntf, null, EJBMethodSecurityAttribute.denyAll());
                        continue;
                    }
                    MethodParametersMetaData methodParams = method.getMethodParams();
                    if (methodParams == null) {
                        componentDescription.getDescriptorMethodPermissions().setAttribute(methodIntf, EJBMethodSecurityAttribute.denyAll(), methodName);
                        continue;
                    }
                    componentDescription.getDescriptorMethodPermissions().setAttribute(methodIntf, EJBMethodSecurityAttribute.denyAll(), null, methodName, this.getMethodParams(methodParams));
                }
            }
            if ((methodPermissions = assemblyDescriptor.getMethodPermissionsByEjbName(componentDescription.getEJBName())) != null) {
                for (MethodPermissionMetaData methodPermissionMetaData : methodPermissions) {
                    MethodsMetaData methods = methodPermissionMetaData.getMethods();
                    for (MethodMetaData method : methods) {
                        EJBMethodSecurityAttribute existingRoles;
                        EJBMethodSecurityAttribute ejbMethodSecurityMetaData = methodPermissionMetaData.isNotChecked() ? EJBMethodSecurityAttribute.permitAll() : EJBMethodSecurityAttribute.rolesAllowed(methodPermissionMetaData.getRoles());
                        String methodName = method.getMethodName();
                        MethodIntf defaultMethodIntf = componentDescription instanceof MessageDrivenComponentDescription ? MethodIntf.MESSAGE_ENDPOINT : MethodIntf.BEAN;
                        MethodIntf methodIntf = this.getMethodIntf(method.getMethodIntf(), defaultMethodIntf);
                        if (methodName.equals("*")) {
                            EJBMethodSecurityAttribute existingRoles2 = componentDescription.getDescriptorMethodPermissions().getAttributeStyle1(methodIntf, null);
                            ejbMethodSecurityMetaData = this.mergeExistingRoles(ejbMethodSecurityMetaData, existingRoles2);
                            componentDescription.getDescriptorMethodPermissions().setAttribute(methodIntf, null, ejbMethodSecurityMetaData);
                            continue;
                        }
                        MethodParametersMetaData methodParams = method.getMethodParams();
                        if (methodParams == null) {
                            existingRoles = componentDescription.getDescriptorMethodPermissions().getAttributeStyle2(methodIntf, methodName);
                            ejbMethodSecurityMetaData = this.mergeExistingRoles(ejbMethodSecurityMetaData, existingRoles);
                            componentDescription.getDescriptorMethodPermissions().setAttribute(methodIntf, ejbMethodSecurityMetaData, methodName);
                            continue;
                        }
                        existingRoles = componentDescription.getDescriptorMethodPermissions().getAttributeStyle3(methodIntf, null, methodName, this.getMethodParams(methodParams));
                        ejbMethodSecurityMetaData = this.mergeExistingRoles(ejbMethodSecurityMetaData, existingRoles);
                        componentDescription.getDescriptorMethodPermissions().setAttribute(methodIntf, ejbMethodSecurityMetaData, null, methodName, this.getMethodParams(methodParams));
                    }
                }
            }
        }
    }

    private EJBMethodSecurityAttribute mergeExistingRoles(EJBMethodSecurityAttribute ejbMethodSecurityMetaData, EJBMethodSecurityAttribute existingRoles) {
        if (existingRoles != null && !existingRoles.getRolesAllowed().isEmpty()) {
            HashSet<String> roles = new HashSet<String>(existingRoles.getRolesAllowed());
            roles.addAll(ejbMethodSecurityMetaData.getRolesAllowed());
            ejbMethodSecurityMetaData = EJBMethodSecurityAttribute.rolesAllowed(roles);
        }
        return ejbMethodSecurityMetaData;
    }
}

