/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import java.util.Map;
import java.util.Set;
import org.jboss.as.core.security.ServerSecurityManager;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInterceptorFactory;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.security.EJBSecurityMetaData;
import org.jboss.as.ejb3.security.SecurityContextInterceptor;
import org.jboss.as.ejb3.security.SecurityContextInterceptorHolder;
import org.jboss.as.security.service.SimpleSecurityManager;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;

public class SecurityContextInterceptorFactory
extends ComponentInterceptorFactory {
    private static final String DEFAULT_DOMAIN = "other";
    private final boolean securityRequired;
    private final boolean propagateSecurity;
    private final String policyContextID;

    public static String contextIdForDeployment(DeploymentUnit du) {
        String contextID = du.getName();
        if (du.getParent() != null) {
            contextID = du.getParent().getName() + "!" + contextID;
        }
        return contextID;
    }

    public SecurityContextInterceptorFactory(boolean securityRequired, String policyContextID) {
        this(securityRequired, true, policyContextID);
    }

    public SecurityContextInterceptorFactory(boolean securityRequired, boolean propagateSecurity) {
        this(securityRequired, propagateSecurity, null);
    }

    public SecurityContextInterceptorFactory(boolean securityRequired, boolean propagateSecurity, String policyContextID) {
        this.securityRequired = securityRequired;
        this.propagateSecurity = propagateSecurity;
        this.policyContextID = policyContextID;
    }

    protected Interceptor create(Component component, InterceptorFactoryContext context) {
        if (!(component instanceof EJBComponent)) {
            throw EjbLogger.ROOT_LOGGER.unexpectedComponent(component, EJBComponent.class);
        }
        EJBComponent ejbComponent = (EJBComponent)component;
        Object securityManager = this.propagateSecurity ? ejbComponent.getSecurityManager() : new SimpleSecurityManager((SimpleSecurityManager)ejbComponent.getSecurityManager());
        EJBSecurityMetaData securityMetaData = ejbComponent.getSecurityMetaData();
        String securityDomain = securityMetaData.getSecurityDomain();
        if (securityDomain == null) {
            securityDomain = DEFAULT_DOMAIN;
        }
        if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
            EjbLogger.ROOT_LOGGER.trace("Using security domain: " + securityDomain + " for EJB " + ejbComponent.getComponentName());
        }
        String runAs = securityMetaData.getRunAs();
        String runAsPrincipal = securityMetaData.getRunAsPrincipal();
        SecurityRolesMetaData securityRoles = securityMetaData.getSecurityRoles();
        Set extraRoles = null;
        Map principalVsRolesMap = null;
        if (securityRoles != null) {
            principalVsRolesMap = securityRoles.getPrincipalVersusRolesMap();
            if (runAsPrincipal != null) {
                extraRoles = securityRoles.getSecurityRoleNamesByPrincipal(runAsPrincipal);
            }
        }
        SecurityContextInterceptorHolder holder = new SecurityContextInterceptorHolder();
        holder.setSecurityManager((ServerSecurityManager)securityManager).setSecurityDomain(securityDomain).setRunAs(runAs).setRunAsPrincipal(runAsPrincipal).setPolicyContextID(this.policyContextID).setExtraRoles(extraRoles).setPrincipalVsRolesMap(principalVsRolesMap).setSkipAuthentication(!this.securityRequired);
        return new SecurityContextInterceptor(holder);
    }
}

