/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote.protocol.versionone;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.jboss.as.ejb3.deployment.DeploymentModuleIdentifier;
import org.jboss.as.ejb3.deployment.DeploymentRepository;
import org.jboss.as.ejb3.deployment.DeploymentRepositoryListener;
import org.jboss.as.ejb3.deployment.ModuleDeployment;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.remote.EJBRemoteTransactionsRepository;
import org.jboss.as.ejb3.remote.RegistryCollector;
import org.jboss.as.ejb3.remote.RemoteAsyncInvocationCancelStatusService;
import org.jboss.as.ejb3.remote.protocol.MessageHandler;
import org.jboss.as.ejb3.remote.protocol.versionone.ChannelAssociation;
import org.jboss.as.ejb3.remote.protocol.versionone.ClusterTopologyWriter;
import org.jboss.as.ejb3.remote.protocol.versionone.InvocationCancellationMessageHandler;
import org.jboss.as.ejb3.remote.protocol.versionone.MethodInvocationMessageHandler;
import org.jboss.as.ejb3.remote.protocol.versionone.ModuleAvailabilityWriter;
import org.jboss.as.ejb3.remote.protocol.versionone.SessionOpenRequestHandler;
import org.jboss.as.ejb3.remote.protocol.versionone.TransactionRequestHandler;
import org.jboss.as.network.ClientMapping;
import org.jboss.as.server.suspend.ServerActivity;
import org.jboss.as.server.suspend.ServerActivityCallback;
import org.jboss.as.server.suspend.SuspendController;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.MessageOutputStream;
import org.wildfly.clustering.registry.Registry;
import org.xnio.IoUtils;

public class VersionOneProtocolChannelReceiver
implements Channel.Receiver,
DeploymentRepositoryListener,
RegistryCollector.Listener<String, List<ClientMapping>>,
ServerActivity {
    private static final byte HEADER_SESSION_OPEN_REQUEST = 1;
    private static final byte HEADER_INVOCATION_REQUEST = 3;
    private static final byte HEADER_INVOCATION_CANCELLATION_REQUEST = 4;
    private static final byte HEADER_TX_COMMIT_REQUEST = 15;
    private static final byte HEADER_TX_ROLLBACK_REQUEST = 16;
    private static final byte HEADER_TX_PREPARE_REQUEST = 17;
    private static final byte HEADER_TX_FORGET_REQUEST = 18;
    private static final byte HEADER_TX_BEFORE_COMPLETION_REQUEST = 19;
    protected final ChannelAssociation channelAssociation;
    protected final DeploymentRepository deploymentRepository;
    protected final EJBRemoteTransactionsRepository transactionsRepository;
    protected final MarshallerFactory marshallerFactory;
    protected final ExecutorService executorService;
    protected final RegistryCollector<String, List<ClientMapping>> clientMappingRegistryCollector;
    protected final Set<ClusterTopologyUpdateListener> clusterTopologyUpdateListeners = Collections.synchronizedSet(new HashSet());
    protected final RemoteAsyncInvocationCancelStatusService remoteAsyncInvocationCancelStatus;
    protected final SuspendController suspendController;

    public VersionOneProtocolChannelReceiver(ChannelAssociation channelAssociation, DeploymentRepository deploymentRepository, EJBRemoteTransactionsRepository transactionsRepository, RegistryCollector<String, List<ClientMapping>> clientMappingRegistryCollector, MarshallerFactory marshallerFactory, ExecutorService executorService, RemoteAsyncInvocationCancelStatusService asyncInvocationCancelStatusService, SuspendController suspendController) {
        this.marshallerFactory = marshallerFactory;
        this.channelAssociation = channelAssociation;
        this.executorService = executorService;
        this.deploymentRepository = deploymentRepository;
        this.transactionsRepository = transactionsRepository;
        this.clientMappingRegistryCollector = clientMappingRegistryCollector;
        this.remoteAsyncInvocationCancelStatus = asyncInvocationCancelStatusService;
        this.suspendController = suspendController;
    }

    public void startReceiving() {
        Channel channel = this.channelAssociation.getChannel();
        channel.addCloseHandler((CloseHandler)new ChannelCloseHandler());
        channel.receiveMessage((Channel.Receiver)this);
        this.deploymentRepository.addListener(this);
        this.clientMappingRegistryCollector.addListener(this);
        this.suspendController.registerActivity((ServerActivity)this);
        Collection<Registry<String, List<ClientMapping>>> clusters = this.clientMappingRegistryCollector.getRegistries();
        try {
            if (clusters != null && clusters.size() > 0) {
                this.sendNewClusterFormedMessage(clusters);
            }
        }
        catch (IOException ioe) {
            EjbLogger.REMOTE_LOGGER.failedToSendClusterFormationMessageToClient(ioe, channel);
        }
        for (Registry<String, List<ClientMapping>> cluster : clusters) {
            ClusterTopologyUpdateListener clusterTopologyUpdateListener = new ClusterTopologyUpdateListener(cluster, this);
            cluster.addListener((Registry.Listener)clusterTopologyUpdateListener);
            this.clusterTopologyUpdateListeners.add(clusterTopologyUpdateListener);
        }
    }

    public void handleError(Channel channel, IOException error) {
        try {
            channel.close();
        }
        catch (IOException e) {
            throw EjbLogger.ROOT_LOGGER.couldNotCloseChannel(e);
        }
        finally {
            this.cleanupOnChannelDown();
        }
    }

    public void handleEnd(Channel channel) {
        try {
            channel.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.cleanupOnChannelDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Channel channel, MessageInputStream messageInputStream) {
        try {
            channel.receiveMessage((Channel.Receiver)this);
            this.processMessage(channel, (InputStream)messageInputStream);
        }
        catch (Throwable e) {
            EjbLogger.REMOTE_LOGGER.exceptionOnChannel(e, channel, messageInputStream);
            IoUtils.safeClose((Closeable)channel);
        }
        finally {
            IoUtils.safeClose((Closeable)messageInputStream);
        }
    }

    protected MessageHandler getMessageHandler(byte header) {
        switch (header) {
            case 3: {
                return new MethodInvocationMessageHandler(this.deploymentRepository, this.marshallerFactory, this.executorService, this.remoteAsyncInvocationCancelStatus);
            }
            case 4: {
                return new InvocationCancellationMessageHandler(this.remoteAsyncInvocationCancelStatus);
            }
            case 1: {
                return new SessionOpenRequestHandler(this.deploymentRepository, this.marshallerFactory, this.executorService);
            }
            case 15: {
                return new TransactionRequestHandler(this.transactionsRepository, this.marshallerFactory, this.executorService, TransactionRequestHandler.TransactionRequestType.COMMIT);
            }
            case 16: {
                return new TransactionRequestHandler(this.transactionsRepository, this.marshallerFactory, this.executorService, TransactionRequestHandler.TransactionRequestType.ROLLBACK);
            }
            case 18: {
                return new TransactionRequestHandler(this.transactionsRepository, this.marshallerFactory, this.executorService, TransactionRequestHandler.TransactionRequestType.FORGET);
            }
            case 17: {
                return new TransactionRequestHandler(this.transactionsRepository, this.marshallerFactory, this.executorService, TransactionRequestHandler.TransactionRequestType.PREPARE);
            }
            case 19: {
                return new TransactionRequestHandler(this.transactionsRepository, this.marshallerFactory, this.executorService, TransactionRequestHandler.TransactionRequestType.BEFORE_COMPLETION);
            }
        }
        return null;
    }

    protected void processMessage(Channel channel, InputStream inputStream) throws IOException {
        int header = inputStream.read();
        EjbLogger.REMOTE_LOGGER.tracef("Got message with header 0x%x on channel %s", header, channel);
        MessageHandler messageHandler = this.getMessageHandler((byte)header);
        if (messageHandler == null) {
            channel.receiveMessage((Channel.Receiver)this);
            EjbLogger.REMOTE_LOGGER.unsupportedMessageHeader(header, channel);
            return;
        }
        messageHandler.processMessage(this.channelAssociation, inputStream);
    }

    @Override
    public void listenerAdded(DeploymentRepository repository) {
        Map<DeploymentModuleIdentifier, ModuleDeployment> availableModules = this.deploymentRepository.getStartedModules();
        if (availableModules != null && !availableModules.isEmpty()) {
            try {
                EjbLogger.REMOTE_LOGGER.debugf("Sending initial module availability message, containing %s module(s) to channel %s", availableModules.size(), this.channelAssociation.getChannel());
                this.sendModuleAvailability(availableModules.keySet().toArray(new DeploymentModuleIdentifier[availableModules.size()]));
            }
            catch (IOException e) {
                EjbLogger.REMOTE_LOGGER.failedToSendModuleAvailabilityMessageToClient(e, this.channelAssociation.getChannel());
            }
        }
    }

    @Override
    public void deploymentAvailable(DeploymentModuleIdentifier deploymentModuleIdentifier, ModuleDeployment moduleDeployment) {
    }

    @Override
    public void deploymentStarted(DeploymentModuleIdentifier deploymentModuleIdentifier, ModuleDeployment moduleDeployment) {
        try {
            this.sendModuleAvailability(new DeploymentModuleIdentifier[]{deploymentModuleIdentifier});
        }
        catch (IOException e) {
            EjbLogger.REMOTE_LOGGER.failedToSendModuleAvailabilityMessageToClient(e, deploymentModuleIdentifier, this.channelAssociation.getChannel());
        }
    }

    @Override
    public void deploymentRemoved(DeploymentModuleIdentifier deploymentModuleIdentifier) {
        try {
            this.sendModuleUnAvailability(new DeploymentModuleIdentifier[]{deploymentModuleIdentifier});
        }
        catch (IOException e) {
            EjbLogger.REMOTE_LOGGER.failedToSendModuleUnavailabilityMessageToClient(e, deploymentModuleIdentifier, this.channelAssociation.getChannel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendModuleAvailability(DeploymentModuleIdentifier[] availableModules) throws IOException {
        MessageOutputStream messageOutputStream;
        try {
            messageOutputStream = this.channelAssociation.acquireChannelMessageOutputStream();
        }
        catch (Exception e) {
            throw EjbLogger.ROOT_LOGGER.failedToOpenMessageOutputStream(e);
        }
        DataOutputStream outputStream = new DataOutputStream((OutputStream)messageOutputStream);
        ModuleAvailabilityWriter moduleAvailabilityWriter = new ModuleAvailabilityWriter();
        try {
            moduleAvailabilityWriter.writeModuleAvailability(outputStream, availableModules);
        }
        finally {
            this.channelAssociation.releaseChannelMessageOutputStream(messageOutputStream);
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendModuleUnAvailability(DeploymentModuleIdentifier[] availableModules) throws IOException {
        MessageOutputStream messageOutputStream;
        try {
            messageOutputStream = this.channelAssociation.acquireChannelMessageOutputStream();
        }
        catch (Exception e) {
            throw EjbLogger.ROOT_LOGGER.failedToOpenMessageOutputStream(e);
        }
        DataOutputStream outputStream = new DataOutputStream((OutputStream)messageOutputStream);
        ModuleAvailabilityWriter moduleAvailabilityWriter = new ModuleAvailabilityWriter();
        try {
            moduleAvailabilityWriter.writeModuleUnAvailability(outputStream, availableModules);
        }
        finally {
            this.channelAssociation.releaseChannelMessageOutputStream(messageOutputStream);
            outputStream.close();
        }
    }

    @Override
    public void registryAdded(Registry<String, List<ClientMapping>> cluster) {
        try {
            if (EjbLogger.REMOTE_LOGGER.isDebugEnabled()) {
                EjbLogger.REMOTE_LOGGER.debugf("Received new cluster formation notification for cluster %s", cluster.getGroup().getName());
            }
            this.sendNewClusterFormedMessage(Collections.singleton(cluster));
        }
        catch (IOException ioe) {
            EjbLogger.REMOTE_LOGGER.failedToSendClusterFormationMessageToClient(ioe, cluster.getGroup().getName(), this.channelAssociation.getChannel());
        }
        finally {
            ClusterTopologyUpdateListener clusterTopologyUpdateListener = new ClusterTopologyUpdateListener(cluster, this);
            cluster.addListener((Registry.Listener)clusterTopologyUpdateListener);
            this.clusterTopologyUpdateListeners.add(clusterTopologyUpdateListener);
        }
    }

    @Override
    public void registryRemoved(Registry<String, List<ClientMapping>> registry) {
        try {
            if (EjbLogger.REMOTE_LOGGER.isDebugEnabled()) {
                EjbLogger.REMOTE_LOGGER.debugf("Received cluster removal notification for cluster %s", registry.getGroup());
            }
            if (registry.getEntries().keySet().size() == 1) {
                this.sendClusterRemovedMessage(registry);
            }
        }
        catch (IOException ioe) {
            EjbLogger.REMOTE_LOGGER.couldNotSendClusterRemovalMessage(ioe, registry.getGroup(), this.channelAssociation.getChannel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNewClusterFormedMessage(Collection<Registry<String, List<ClientMapping>>> clientMappingRegistries) throws IOException {
        MessageOutputStream messageOutputStream;
        try {
            messageOutputStream = this.channelAssociation.acquireChannelMessageOutputStream();
        }
        catch (Exception e) {
            throw EjbLogger.ROOT_LOGGER.failedToOpenMessageOutputStream(e);
        }
        DataOutputStream outputStream = new DataOutputStream((OutputStream)messageOutputStream);
        ClusterTopologyWriter clusterTopologyWriter = new ClusterTopologyWriter();
        try {
            EjbLogger.REMOTE_LOGGER.debugf("Writing out cluster formation message for %d clusters, to channel %s", clientMappingRegistries.size(), this.channelAssociation.getChannel());
            clusterTopologyWriter.writeCompleteClusterTopology(outputStream, clientMappingRegistries);
        }
        finally {
            this.channelAssociation.releaseChannelMessageOutputStream(messageOutputStream);
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendClusterRemovedMessage(Registry<String, List<ClientMapping>> registry) throws IOException {
        MessageOutputStream messageOutputStream;
        try {
            messageOutputStream = this.channelAssociation.acquireChannelMessageOutputStream();
        }
        catch (Exception e) {
            throw EjbLogger.ROOT_LOGGER.failedToOpenMessageOutputStream(e);
        }
        DataOutputStream outputStream = new DataOutputStream((OutputStream)messageOutputStream);
        ClusterTopologyWriter clusterTopologyWriter = new ClusterTopologyWriter();
        try {
            if (EjbLogger.REMOTE_LOGGER.isDebugEnabled()) {
                EjbLogger.REMOTE_LOGGER.debugf("Cluster Ts removed, writing cluster removal message to channel %s", registry.getGroup().getName(), this.channelAssociation.getChannel());
            }
            clusterTopologyWriter.writeClusterRemoved(outputStream, Collections.singleton(registry));
        }
        finally {
            this.channelAssociation.releaseChannelMessageOutputStream(messageOutputStream);
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanupOnChannelDown() {
        Set<ClusterTopologyUpdateListener> set = this.clusterTopologyUpdateListeners;
        synchronized (set) {
            for (ClusterTopologyUpdateListener clusterTopologyUpdateListener : this.clusterTopologyUpdateListeners) {
                clusterTopologyUpdateListener.unregisterListener();
            }
        }
        this.deploymentRepository.removeListener(this);
        this.clientMappingRegistryCollector.removeListener(this);
        this.suspendController.unRegisterActivity((ServerActivity)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preSuspend(ServerActivityCallback listener) {
        Map<DeploymentModuleIdentifier, ModuleDeployment> availableModules = this.deploymentRepository.getStartedModules();
        if (availableModules != null && !availableModules.isEmpty()) {
            try {
                EjbLogger.ROOT_LOGGER.debugf("Sending module unavailability message on suspend of server, containing %s module(s) to channel %s", availableModules.size(), this.channelAssociation.getChannel());
                this.sendModuleUnAvailability(availableModules.keySet().toArray(new DeploymentModuleIdentifier[availableModules.size()]));
            }
            catch (IOException e) {
                EjbLogger.ROOT_LOGGER.failedToSendModuleAvailabilityMessageToClient(e, this.channelAssociation.getChannel());
            }
            finally {
                listener.done();
            }
        }
    }

    public void suspended(ServerActivityCallback listener) {
        listener.done();
    }

    public void resume() {
        Map<DeploymentModuleIdentifier, ModuleDeployment> availableModules = this.deploymentRepository.getStartedModules();
        if (availableModules != null && !availableModules.isEmpty()) {
            try {
                EjbLogger.ROOT_LOGGER.debugf("Sending module availability message on resume of server, containing %s module(s) to channel %s", availableModules.size(), this.channelAssociation.getChannel());
                this.sendModuleAvailability(availableModules.keySet().toArray(new DeploymentModuleIdentifier[availableModules.size()]));
            }
            catch (IOException e) {
                EjbLogger.ROOT_LOGGER.failedToSendModuleAvailabilityMessageToClient(e, this.channelAssociation.getChannel());
            }
        }
    }

    private class ClusterTopologyUpdateListener
    implements Registry.Listener<String, List<ClientMapping>> {
        private final String clusterName;
        private final VersionOneProtocolChannelReceiver channelReceiver;
        private final Registry<String, List<ClientMapping>> cluster;

        ClusterTopologyUpdateListener(Registry<String, List<ClientMapping>> cluster, VersionOneProtocolChannelReceiver channelReceiver) {
            this.channelReceiver = channelReceiver;
            this.clusterName = cluster.getGroup().getName();
            this.cluster = cluster;
        }

        public void addedEntries(Map<String, List<ClientMapping>> added) {
            try {
                this.sendClusterNodesAdded(added);
            }
            catch (IOException ioe) {
                EjbLogger.REMOTE_LOGGER.failedToSendClusterNodeAdditionMessageToClient(ioe, VersionOneProtocolChannelReceiver.this.channelAssociation.getChannel());
            }
        }

        public void updatedEntries(Map<String, List<ClientMapping>> updated) {
        }

        public void removedEntries(Map<String, List<ClientMapping>> removed) {
            try {
                this.sendClusterNodesRemoved(removed.keySet());
            }
            catch (IOException ioe) {
                EjbLogger.REMOTE_LOGGER.failedToSendClusterNodeRemovalMessageToClient(ioe, VersionOneProtocolChannelReceiver.this.channelAssociation.getChannel());
            }
        }

        void unregisterListener() {
            this.cluster.removeListener((Registry.Listener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendClusterNodesRemoved(Set<String> removedNodes) throws IOException {
            MessageOutputStream messageOutputStream;
            try {
                messageOutputStream = VersionOneProtocolChannelReceiver.this.channelAssociation.acquireChannelMessageOutputStream();
            }
            catch (Exception e) {
                throw EjbLogger.ROOT_LOGGER.failedToOpenMessageOutputStream(e);
            }
            DataOutputStream outputStream = new DataOutputStream((OutputStream)messageOutputStream);
            ClusterTopologyWriter clusterTopologyWriter = new ClusterTopologyWriter();
            try {
                if (EjbLogger.REMOTE_LOGGER.isDebugEnabled()) {
                    EjbLogger.REMOTE_LOGGER.debug("Following " + removedNodes.size() + " nodes removed from cluster " + this.clusterName + ", writing a protocol message to channel " + this.channelReceiver.channelAssociation.getChannel());
                    StringBuilder sb = new StringBuilder();
                    for (String nodeName : removedNodes) {
                        sb.append(nodeName);
                        sb.append(System.lineSeparator());
                    }
                    EjbLogger.REMOTE_LOGGER.debug(sb.toString());
                }
                clusterTopologyWriter.writeNodesRemoved(outputStream, this.clusterName, removedNodes);
            }
            finally {
                VersionOneProtocolChannelReceiver.this.channelAssociation.releaseChannelMessageOutputStream(messageOutputStream);
                outputStream.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendClusterNodesAdded(Map<String, List<ClientMapping>> addedNodes) throws IOException {
            MessageOutputStream messageOutputStream;
            try {
                messageOutputStream = VersionOneProtocolChannelReceiver.this.channelAssociation.acquireChannelMessageOutputStream();
            }
            catch (Exception e) {
                throw EjbLogger.ROOT_LOGGER.failedToOpenMessageOutputStream(e);
            }
            DataOutputStream outputStream = new DataOutputStream((OutputStream)messageOutputStream);
            ClusterTopologyWriter clusterTopologyWriter = new ClusterTopologyWriter();
            try {
                if (EjbLogger.REMOTE_LOGGER.isDebugEnabled()) {
                    EjbLogger.REMOTE_LOGGER.debug("Following " + addedNodes.size() + " nodes added to cluster " + this.clusterName + ", writing a protocol message to channel " + this.channelReceiver.channelAssociation.getChannel());
                    StringBuilder sb = new StringBuilder();
                    for (String nodeName : addedNodes.keySet()) {
                        sb.append(nodeName);
                        sb.append(System.lineSeparator());
                    }
                    EjbLogger.REMOTE_LOGGER.debug(sb.toString());
                }
                clusterTopologyWriter.writeNewNodesAdded(outputStream, this.clusterName, addedNodes);
            }
            finally {
                VersionOneProtocolChannelReceiver.this.channelAssociation.releaseChannelMessageOutputStream(messageOutputStream);
                outputStream.close();
            }
        }
    }

    class ChannelCloseHandler
    implements CloseHandler<Channel> {
        ChannelCloseHandler() {
        }

        public void handleClose(Channel closedChannel, IOException exception) {
            EjbLogger.REMOTE_LOGGER.debugf("Channel %s closed", closedChannel);
            VersionOneProtocolChannelReceiver.this.cleanupOnChannelDown();
        }
    }
}

