/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.logging;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.ejb.ConcurrentAccessTimeoutException;
import javax.ejb.EJBAccessException;
import javax.ejb.EJBException;
import javax.ejb.EJBTransactionRequiredException;
import javax.ejb.IllegalLoopbackException;
import javax.ejb.LockType;
import javax.ejb.NoMoreTimeoutsException;
import javax.ejb.NoSuchEJBException;
import javax.ejb.NoSuchEntityException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.ejb.ScheduleExpression;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;
import javax.ejb.TransactionAttributeType;
import javax.interceptor.InvocationContext;
import javax.naming.Context;
import javax.resource.ResourceException;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Transaction;
import javax.transaction.xa.Xid;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentCreateServiceFactory;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ee.component.ResourceInjectionTarget;
import org.jboss.as.ejb3.EJBMethodIdentifier;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBComponentUnavailableException;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentInstance;
import org.jboss.as.ejb3.concurrency.LockableComponent;
import org.jboss.as.ejb3.deployment.DeploymentModuleIdentifier;
import org.jboss.as.ejb3.subsystem.deployment.EJBComponentType;
import org.jboss.as.ejb3.subsystem.deployment.InstalledComponent;
import org.jboss.as.ejb3.timerservice.TimerImpl;
import org.jboss.as.ejb3.timerservice.persistence.TimeoutMethod;
import org.jboss.as.ejb3.tx.TimerTransactionRolledBackException;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.dmr.ModelNode;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.XidTransactionID;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jca.core.spi.rar.NotFoundException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.MessageInputStream;
import org.wildfly.clustering.group.Group;

@MessageLogger(projectCode="WFLYEJB", length=4)
public interface EjbLogger
extends BasicLogger {
    public static final EjbLogger ROOT_LOGGER = (EjbLogger)Logger.getMessageLogger(EjbLogger.class, (String)"org.jboss.as.ejb3");
    public static final EjbLogger DEPLOYMENT_LOGGER = (EjbLogger)Logger.getMessageLogger(EjbLogger.class, (String)"org.jboss.as.ejb3.deployment");
    public static final EjbLogger REMOTE_LOGGER = (EjbLogger)Logger.getMessageLogger(EjbLogger.class, (String)"org.jboss.as.ejb3.remote");
    public static final EjbLogger EJB3_INVOCATION_LOGGER = (EjbLogger)Logger.getMessageLogger(EjbLogger.class, (String)"org.jboss.as.ejb3.invocation");
    public static final EjbLogger EJB3_TIMER_LOGGER = (EjbLogger)Logger.getMessageLogger(EjbLogger.class, (String)"org.jboss.as.ejb3.timer");

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1, value="Failed to remove %s from cache")
    public void cacheRemoveFailed(Object var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=2, value="Failed to find SFSB instance with session ID %s in cache")
    public void cacheEntryNotFound(Object var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3, value="Asynchronous invocation failed")
    public void asyncInvocationFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=4, value="failed to get tx manager status; ignoring")
    public void getTxManagerStatusFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5, value="failed to set rollback only; ignoring")
    public void setRollbackOnlyFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=6, value="ActivationConfigProperty %s will be ignored since it is not allowed by resource adapter: %s")
    public void activationConfigPropertyIgnored(Object var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=7, value="Discarding stateful component instance: %s due to exception")
    public void discardingStatefulComponent(StatefulSessionComponentInstance var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=8, value="Failed to remove bean: %s with session id %s")
    public void failedToRemoveBean(String var1, SessionID var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=9, value="Could not find stateful session bean instance with id: %s for bean: %s during destruction. Probably already removed")
    public void failToFindSfsbWithId(SessionID var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10, value="Default interceptor class %s is not listed in the <interceptors> section of ejb-jar.xml and will not be applied")
    public void defaultInterceptorClassNotListed(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=11, value="No method named: %s found on EJB: %s while processing exclude-list element in ejb-jar.xml")
    public void noMethodFoundOnEjbExcludeList(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=12, value="No method named: %s with param types: %s found on EJB: %s while processing exclude-list element in ejb-jar.xml")
    public void noMethodFoundOnEjbWithParamExcludeList(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=13, value="No method named: %s found on EJB: %s while processing method-permission element in ejb-jar.xml")
    public void noMethodFoundOnEjbPermission(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=14, value="No method named: %s with param types: %s found on EJB: %s while processing method-permission element in ejb-jar.xml")
    public void noMethodFoundWithParamOnEjbMethodPermission(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15, value="Unknown timezone id: %s found in schedule expression. Ignoring it and using server's timezone: %s")
    public void unknownTimezoneId(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=16, value="Timer persistence is not enabled, persistent timers will not survive JVM restarts")
    public void timerPersistenceNotEnable();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=17, value="Next expiration is null. No tasks will be scheduled for timer %S")
    public void nextExpirationIsNull(TimerImpl var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=18, value="Ignoring exception during setRollbackOnly")
    public void ignoringException(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=19, value="Unregistered an already registered Timerservice with id %s and a new instance will be registered")
    public void UnregisteredRegisteredTimerService(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=20, value="Error invoking timeout for timer: %s")
    public void errorInvokeTimeout(Timer var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=21, value="Timer: %s will be retried")
    public void timerRetried(Timer var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=22, value="Error during retrying timeout for timer: %s")
    public void errorDuringRetryTimeout(Timer var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=23, value="Retrying timeout for timer: %s")
    public void retryingTimeout(Timer var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=24, value="Timer is not active, skipping retry of timer: %s")
    public void timerNotActive(Timer var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=26, value="Could not read timer information for EJB component %s")
    public void failToReadTimerInformation(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=27, value="Could not remove persistent timer %s")
    public void failedToRemovePersistentTimer(File var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=28, value="%s is not a directory, could not restore timers")
    public void failToRestoreTimers(File var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=29, value="Could not restore timer from %s")
    public void failToRestoreTimersFromFile(File var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=30, value="error closing file ")
    public void failToCloseFile(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=31, value="Could not restore timers for %s")
    public void failToRestoreTimersForObjectId(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=32, value="Could not create directory %s to persist EJB timers.")
    public void failToCreateDirectoryForPersistTimers(File var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=34, value="EJB Invocation failed on component %s for method %s")
    public void invocationFailed(String var1, Method var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=35, value="Could not find EJB for locator %s, EJB client proxy will not be replaced")
    public void couldNotFindEjbForLocatorIIOP(EJBLocator<?> var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=36, value="EJB %s is not being replaced with a Stub as it is not exposed over IIOP")
    public void ejbNotExposedOverIIOP(EJBLocator<?> var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=37, value="Dynamic stub creation failed for class %s")
    public void dynamicStubCreationFailed(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=38, value="Exception releasing entity")
    public void exceptionReleasingEntity(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=39, value="Unsupported client marshalling strategy %s received on channel %s ,no further communication will take place")
    public void unsupportedClientMarshallingStrategy(String var1, Channel var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=40, value="Closing channel %s due to an error")
    public void closingChannel(Channel var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=41, value="Channel end notification received, closing channel %s")
    public void closingChannelOnChannelEnd(Channel var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=42, value="Started message driven bean '%s' with '%s' resource adapter")
    public void logMDBStart(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=43, value="A previous execution of timer %s is still in progress, skipping this overlapping scheduled execution at: %s.")
    public void skipOverlappingInvokeTimeout(Timer var1, Date var2);

    @Message(id=44, value="Resource adapter repository is not available")
    public IllegalStateException resourceAdapterRepositoryUnAvailable();

    @Message(id=45, value="Could not find an Endpoint for resource adapter %s")
    public IllegalArgumentException noSuchEndpointException(String var1, @Cause NotFoundException var2);

    @Message(id=46, value="Endpoint is not available for message driven component %s")
    public IllegalStateException endpointUnAvailable(String var1);

    @Message(id=47, value="Could not deactivate endpoint for message driven component %s")
    public RuntimeException failureDuringEndpointDeactivation(String var1, @Cause ResourceException var2);

    @Message(id=48, value="")
    public UnsupportedCallbackException unsupportedCallback(@Param Callback var1);

    @Message(id=49, value="Could not create an instance of cluster node selector %s for cluster %s")
    public RuntimeException failureDuringLoadOfClusterNodeSelector(String var1, String var2, @Cause Exception var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=50, value="Failed to parse property %s due to %s")
    public void failedToCreateOptionForProperty(String var1, String var2);

    @Message(id=51, value="Could not find view %s for EJB %s")
    public IllegalStateException viewNotFound(String var1, String var2);

    @Message(id=52, value="Cannot perform asynchronous local invocation for component that is not a session bean")
    public RuntimeException asyncInvocationOnlyApplicableForSessionBeans();

    @Message(id=53, value="%s is not a Stateful Session bean in app: %s module: %s distinct-name: %s")
    public IllegalArgumentException notStatefulSessionBean(String var1, String var2, String var3, String var4);

    @Message(id=54, value="Failed to marshal EJB parameters")
    public RuntimeException failedToMarshalEjbParameters(@Cause Exception var1);

    @Message(id=55, value="No matching deployment for EJB: %s")
    public NoSuchEJBException unknownDeployment(EJBLocator<?> var1);

    @Message(id=56, value="Could not find EJB in matching deployment: %s")
    public NoSuchEJBException ejbNotFoundInDeployment(EJBLocator<?> var1);

    @Message(id=57, value="%s annotation is only valid on method targets")
    public IllegalArgumentException annotationApplicableOnlyForMethods(String var1);

    @Message(id=58, value="Method %s, on class %s, annotated with @javax.interceptor.AroundTimeout is expected to accept a single param of type javax.interceptor.InvocationContext")
    public IllegalArgumentException aroundTimeoutMethodExpectedWithInvocationContextParam(String var1, String var2);

    @Message(id=59, value="Method %s, on class %s, annotated with @javax.interceptor.AroundTimeout must return Object type")
    public IllegalArgumentException aroundTimeoutMethodMustReturnObjectType(String var1, String var2);

    @Message(id=60, value="Wrong tx on thread: expected %s, actual %s")
    public IllegalStateException wrongTxOnThread(Transaction var1, Transaction var2);

    @Message(id=61, value="Unknown transaction attribute %s on invocation %s")
    public IllegalStateException unknownTxAttributeOnInvocation(TransactionAttributeType var1, InterceptorContext var2);

    @Message(id=62, value="Transaction is required for invocation %s")
    public EJBTransactionRequiredException txRequiredForInvocation(InterceptorContext var1);

    @Message(id=63, value="Transaction present on server in Never call (EJB3 13.6.2.6)")
    public EJBException txPresentForNeverTxAttribute();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=64, value="Failed to set transaction for rollback only")
    public void failedToSetRollbackOnly(@Cause Exception var1);

    @Message(id=65, value="View interface cannot be null")
    public IllegalArgumentException viewInterfaceCannotBeNull();

    @Message(id=68, value="Could not load view class for component %s")
    public RuntimeException failedToLoadViewClassForComponent(@Cause Exception var1, String var2);

    @Message(id=73, value="Illegal call to EJBHome.remove(Object) on a session bean")
    public RemoveException illegalCallToEjbHomeRemove();

    @Message(id=74, value="EJB 3.1 FR 13.6.2.8 setRollbackOnly is not allowed with SUPPORTS transaction attribute")
    public IllegalStateException setRollbackOnlyNotAllowedForSupportsTxAttr();

    @Message(id=75, value="Cannot call getPrimaryKey on a session bean")
    public EJBException cannotCallGetPKOnSessionBean();

    @Message(id=76, value="Singleton beans cannot have EJB 2.x views")
    public RuntimeException ejb2xViewNotApplicableForSingletonBeans();

    @Message(id=78, value="Bean %s does not have an EJBLocalObject")
    public IllegalStateException ejbLocalObjectUnavailable(String var1);

    @Message(id=79, value="[EJB 3.1 spec, section 14.1.1] Class: %s cannot be marked as an application exception because it is not of type java.lang.Exception")
    public IllegalArgumentException cannotBeApplicationExceptionBecauseNotAnExceptionType(Class<?> var1);

    @Message(id=80, value="[EJB 3.1 spec, section 14.1.1] Exception class: %s cannot be marked as an application exception because it is of type java.rmi.RemoteException")
    public IllegalArgumentException rmiRemoteExceptionCannotBeApplicationException(Class<?> var1);

    @Message(id=81, value="%s annotation is allowed only on classes. %s is not a class")
    public RuntimeException annotationOnlyAllowedOnClass(String var1, AnnotationTarget var2);

    @Message(id=82, value="Bean %s specifies @Remote annotation, but does not implement 1 interface")
    public DeploymentUnitProcessingException beanWithRemoteAnnotationImplementsMoreThanOneInterface(Class<?> var1);

    @Message(id=83, value="Bean %s specifies @Local annotation, but does not implement 1 interface")
    public DeploymentUnitProcessingException beanWithLocalAnnotationImplementsMoreThanOneInterface(Class<?> var1);

    @Message(id=84, value="Could not analyze remote interface for %s")
    public RuntimeException failedToAnalyzeRemoteInterface(@Cause Exception var1, String var2);

    @Message(id=85, value="Exception while parsing %s")
    public DeploymentUnitProcessingException failedToParse(@Cause Exception var1, String var2);

    @Message(id=86, value="Failed to install management resources for %s")
    public DeploymentUnitProcessingException failedToInstallManagementResource(@Cause Exception var1, String var2);

    @Message(id=87, value="Could not load view %s")
    public RuntimeException failedToLoadViewClass(@Cause Exception var1, String var2);

    @Message(id=88, value="Could not determine type of ejb-ref %s for injection target %s")
    public DeploymentUnitProcessingException couldNotDetermineEjbRefForInjectionTarget(String var1, ResourceInjectionTarget var2);

    @Message(id=89, value="Could not determine type of ejb-local-ref %s for injection target %s")
    public DeploymentUnitProcessingException couldNotDetermineEjbLocalRefForInjectionTarget(String var1, ResourceInjectionTarget var2);

    @Message(id=90, value="@EJB injection target %s is invalid. Only setter methods are allowed")
    public IllegalArgumentException onlySetterMethodsAllowedToHaveEJBAnnotation(MethodInfo var1);

    @Message(id=91, value="@EJB attribute 'name' is required for class level annotations. Class: %s")
    public DeploymentUnitProcessingException nameAttributeRequiredForEJBAnnotationOnClass(String var1);

    @Message(id=92, value="@EJB attribute 'beanInterface' is required for class level annotations. Class: %s")
    public DeploymentUnitProcessingException beanInterfaceAttributeRequiredForEJBAnnotationOnClass(String var1);

    @Message(id=93, value="Module hasn't been attached to deployment unit %s")
    public IllegalStateException moduleNotAttachedToDeploymentUnit(DeploymentUnit var1);

    @Message(id=94, value="EJB 3.1 FR 5.4.2 MessageDrivenBean %s does not implement 1 interface nor specifies message listener interface")
    public DeploymentUnitProcessingException mdbDoesNotImplementNorSpecifyMessageListener(ClassInfo var1);

    @Message(id=95, value="Unknown session bean type %s")
    public IllegalArgumentException unknownSessionBeanType(String var1);

    @Message(id=96, value="More than one method found with name %s on %s")
    public DeploymentUnitProcessingException moreThanOneMethodWithSameNameOnComponent(String var1, Class<?> var2);

    @Message(id=97, value="Unknown EJB locator type %s")
    public RuntimeException unknownEJBLocatorType(EJBLocator<?> var1);

    @Message(id=98, value="Could not create CORBA object for %s")
    public RuntimeException couldNotCreateCorbaObject(@Cause Exception var1, EJBLocator<?> var2);

    @Message(id=99, value="Provided locator %s was not for EJB %s")
    public IllegalArgumentException incorrectEJBLocatorForBean(EJBLocator<?> var1, String var2);

    @Message(id=100, value="Failed to lookup java:comp/ORB")
    public IOException failedToLookupORB();

    @Message(id=101, value="%s is not an ObjectImpl")
    public IOException notAnObjectImpl(Class<?> var1);

    @Message(id=102, value="Message endpoint %s has already been released")
    public UnavailableException messageEndpointAlreadyReleased(MessageEndpoint var1);

    @Message(id=103, value="Cannot handle client version %s")
    public RuntimeException ejbRemoteServiceCannotHandleClientVersion(byte var1);

    @Message(id=104, value="Could not find marshaller factory for marshaller strategy %s")
    public RuntimeException failedToFindMarshallerFactoryForStrategy(String var1);

    @Message(id=105, value="%s is not an EJB component")
    public IllegalArgumentException notAnEJBComponent(Component var1);

    @Message(id=106, value="Could not load method param class %s of timeout method")
    public RuntimeException failedToLoadTimeoutMethodParamClass(@Cause Exception var1, String var2);

    @Message(id=107, value="Timer invocation failed, invoker is not started")
    public IllegalStateException timerInvocationFailedDueToInvokerNotBeingStarted();

    @Message(id=109, value="Invalid value for second: %s")
    public IllegalArgumentException invalidValueForSecondInScheduleExpression(String var1);

    @Message(id=110, value="Timer invocation failed, transaction rolled back")
    public TimerTransactionRolledBackException timerInvocationRolledBack();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111, value="No jndi bindings will be created for EJB %s since no views are exposed")
    public void noJNDIBindingsForSessionBean(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=112, value="Could not send cluster formation message to the client on channel %s")
    public void failedToSendClusterFormationMessageToClient(@Cause Exception var1, Channel var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=113, value="Could not send module availability notification of module %s on channel %s")
    public void failedToSendModuleAvailabilityMessageToClient(@Cause Exception var1, DeploymentModuleIdentifier var2, Channel var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=-1, value="Could not send initial module availability report to channel %s")
    public void failedToSendModuleAvailabilityMessageToClient(@Cause Exception var1, Channel var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=114, value="Could not send module un-availability notification of module %s on channel %s")
    public void failedToSendModuleUnavailabilityMessageToClient(@Cause Exception var1, DeploymentModuleIdentifier var2, Channel var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=115, value="Could not send a cluster formation message for cluster: %s to the client on channel %s")
    public void failedToSendClusterFormationMessageToClient(@Cause Exception var1, String var2, Channel var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=116, value="Could not write a new cluster node addition message to channel %s")
    public void failedToSendClusterNodeAdditionMessageToClient(@Cause Exception var1, Channel var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=117, value="Could not write a cluster node removal message to channel %s")
    public void failedToSendClusterNodeRemovalMessageToClient(@Cause Exception var1, Channel var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=118, value="[EJB3.1 spec, section 4.9.2] Session bean implementation class MUST NOT be a interface - %s is an interface, hence won't be considered as a session bean")
    public void sessionBeanClassCannotBeAnInterface(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=119, value="[EJB3.1 spec, section 4.9.2] Session bean implementation class MUST be public, not abstract and not final - %s won't be considered as a session bean, since it doesn't meet that requirement")
    public void sessionBeanClassMustBePublicNonAbstractNonFinal(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=120, value="[EJB3.1 spec, section 5.6.2] Message driven bean implementation class MUST NOT be a interface - %s is an interface, hence won't be considered as a message driven bean")
    public void mdbClassCannotBeAnInterface(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=121, value="[EJB3.1 spec, section 5.6.2] Message driven bean implementation class MUST be public, not abstract and not final - %s won't be considered as a message driven bean, since it doesn't meet that requirement")
    public void mdbClassMustBePublicNonAbstractNonFinal(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=122, value="Method %s was a async method but the client could not be informed about the same. This will mean that the client might block till the method completes")
    public void failedToSendAsyncMethodIndicatorToClient(@Cause Throwable var1, Method var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=123, value="Asynchronous invocations are only supported on session beans. Bean class %s is not a session bean, invocation on method %s will have no asynchronous semantics")
    public void asyncMethodSupportedOnlyForSessionBeans(Class<?> var1, Method var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=124, value="Cannot add cluster node %s to cluster %s since none of the client mappings matched for addresses %s")
    public void cannotAddClusterNodeDueToUnresolvableClientMapping(String var1, String var2, Object var3);

    @Message(id=125, value="Could not create an instance of deployment node selector %s")
    public DeploymentUnitProcessingException failedToCreateDeploymentNodeSelector(@Cause Exception var1, String var2);

    @Message(id=126, value="Could not lookup service %s")
    public IllegalStateException serviceNotFound(ServiceName var1);

    @Message(id=127, value="EJB %s of type %s must have public default constructor")
    public DeploymentUnitProcessingException ejbMustHavePublicDefaultConstructor(String var1, String var2);

    @Message(id=128, value="EJB %s of type %s must not be inner class")
    public DeploymentUnitProcessingException ejbMustNotBeInnerClass(String var1, String var2);

    @Message(id=129, value="EJB %s of type %s must be declared public")
    public DeploymentUnitProcessingException ejbMustBePublicClass(String var1, String var2);

    @Message(id=130, value="EJB %s of type %s must not be declared final")
    public DeploymentUnitProcessingException ejbMustNotBeFinalClass(String var1, String var2);

    @Message(id=131, value="EJB client context selector failed due to unavailability of %s service")
    public IllegalStateException ejbClientContextSelectorUnableToFunctionDueToMissingService(ServiceName var1);

    @Message(id=132, value="@PostConstruct method of EJB singleton %s of type %s has been recursively invoked")
    public IllegalStateException reentrantSingletonCreation(String var1, String var2);

    @Message(id=133, value="Failed to read EJB info")
    public IOException failedToReadEjbInfo(@Cause Throwable var1);

    @Message(id=134, value="Failed to read EJB Locator")
    public IOException failedToReadEJBLocator(@Cause Throwable var1);

    @Message(id=135, value="default-security-domain was defined")
    public String rejectTransformationDefinedDefaultSecurityDomain();

    @Message(id=136, value="default-missing-method-permissions-deny-access was set to true")
    public String rejectTransformationDefinedDefaultMissingMethodPermissionsDenyAccess();

    @Message(id=137, value="Only session and message-driven beans with bean-managed transaction demarcation are allowed to access UserTransaction")
    public IllegalStateException unauthorizedAccessToUserTransaction();

    @Message(id=138, value="More than one timer found in database with id %s")
    public RuntimeException moreThanOneTimerFoundWithId(String var1);

    @Message(id=139, value="The timer service has been disabled. Please add a <timer-service> entry into the ejb section of the server configuration to enable it.")
    public String timerServiceIsNotActive();

    @Message(id=140, value="This EJB does not have any timeout methods")
    public String ejbHasNoTimerMethods();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=141, value="Exception calling deployment added listener")
    public void deploymentAddListenerException(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=142, value="Exception calling deployment removal listener")
    public void deploymentRemoveListenerException(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=143, value="Failed to remove management resources for %s -- %s")
    public void failedToRemoveManagementResources(InstalledComponent var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=144, value="CORBA interface repository for %s: %s")
    public void cobraInterfaceRepository(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=145, value="Cannot unregister EJBHome from CORBA naming service")
    public void cannotUnregisterEJBHomeFromCobra(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=146, value="Cannot deactivate home servant")
    public void cannotDeactivateHomeServant(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=147, value="Cannot deactivate bean servant")
    public void cannotDeactivateBeanServant(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=148, value="Exception on channel %s from message %s")
    public void exceptionOnChannel(@Cause Throwable var1, Channel var2, MessageInputStream var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=149, value="Error invoking method %s on bean named %s for appname %s modulename %s distinctname %s")
    public void errorInvokingMethod(@Cause Throwable var1, Method var2, String var3, String var4, String var5, String var6);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=150, value="Could not write method invocation failure for method %s on bean named %s for appname %s modulename %s distinctname %s due to")
    public void couldNotWriteMethodInvocation(@Cause Throwable var1, Method var2, String var3, String var4, String var5, String var6);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=151, value="Exception while generating session id for component %s with invocation %s")
    public void exceptionGeneratingSessionId(@Cause Throwable var1, String var2, Object var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=152, value="Could not write out message to channel due to")
    public void couldNotWriteOutToChannel(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=153, value="Could not write out invocation success message to channel due to")
    public void couldNotWriteInvocationSuccessMessage(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=154, value="Received unsupported message header 0x%x on channel %s")
    public void unsupportedMessageHeader(int var1, Channel var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=155, value="Error during transaction management of transaction id %s")
    public void errorDuringTransactionManagement(@Cause Throwable var1, XidTransactionID var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=156, value="%s retrying %d")
    public void retrying(String var1, int var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=157, value="Failed to get status")
    public void failedToGetStatus(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=158, value="Failed to rollback")
    public void failedToRollback(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=159, value="BMT stateful bean '%s' did not complete user transaction properly status=%s")
    public void transactionNotComplete(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=160, value="Cannot delete cache %s %s, will be deleted on exit")
    public void cannotDeleteCacheFile(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=161, value="Failed to reinstate timer '%s' (id=%s) from its persistent state")
    public void timerReinstatementFailed(String var1, String var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=162, value="A previous execution of timer %s is being retried, skipping this scheduled execution at: %s")
    public void skipInvokeTimeoutDuringRetry(Timer var1, Date var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=163, value="Cannot create table for timer persistence")
    public void couldNotCreateTable(@Cause SQLException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=164, value="Exception running timer task for timer %s on EJB %s")
    public void exceptionRunningTimerTask(Timer var1, String var2, @Cause Exception var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=165, value="Error during transaction recovery")
    public void errorDuringTransactionRecovery(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=166, value="The @%s annotation is deprecated and will be ignored.")
    public void deprecatedAnnotation(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=167, value="The <%2$s xmlns=\"%1$s\"/> element will be ignored.")
    public void deprecatedNamespace(String var1, String var2);

    @Message(id=168, value="Could not find EJB with id %s")
    public NoSuchEJBException couldNotFindEjb(String var1);

    @Message(id=169, value="Component not set in InterceptorContext: %s")
    public IllegalStateException componentNotSetInInterceptor(InterceptorContext var1);

    @Message(id=170, value="Method name cannot be null")
    public IllegalArgumentException methodNameIsNull();

    @Message(id=171, value="Bean %s does not have a Home interface")
    public IllegalStateException beanHomeInterfaceIsNull(String var1);

    @Message(id=172, value="Bean %s does not have a Local Home interface")
    public IllegalStateException beanLocalHomeInterfaceIsNull(String var1);

    @Message(id=173, value="EJB 3.1 FR 13.6.1 Only beans with container-managed transaction demarcation can use getRollbackOnly.")
    public IllegalStateException failToCallgetRollbackOnly();

    @Message(id=174, value="getRollbackOnly() not allowed without a transaction.")
    public IllegalStateException failToCallgetRollbackOnlyOnNoneTransaction();

    @Message(id=175, value="getRollbackOnly() not allowed after transaction is completed (EJBTHREE-1445)")
    public IllegalStateException failToCallgetRollbackOnlyAfterTxcompleted();

    @Message(id=176, value="EJB 3.1 FR 4.3.3 & 5.4.5 Only beans with bean-managed transaction demarcation can use this method.")
    public IllegalStateException failToCallIsBeanManagedTransaction();

    @Message(id=177, value="jndi name cannot be null during lookup")
    public IllegalArgumentException jndiNameCannotBeNull();

    @Message(id=178, value="No NamespaceContextSelector available, cannot lookup %s")
    public IllegalArgumentException noNamespaceContextSelectorAvailable(String var1);

    @Message(id=179, value=" Could not lookup jndi name: %s")
    public RuntimeException failToLookupJNDI(String var1, @Cause Throwable var2);

    @Message(id=180, value="Cannot lookup jndi name: %s since it doesn't belong to java:app, java:module, java:comp or java:global namespace")
    public IllegalArgumentException failToLookupJNDINameSpace(String var1);

    @Message(id=181, value="Could not lookup jndi name: %s in context: %s")
    public IllegalArgumentException failToLookupStrippedJNDI(NamespaceContextSelector var1, Context var2, @Cause Throwable var3);

    @Message(id=182, value="EJB 3.1 FR 13.6.1 Only beans with container-managed transaction demarcation can use setRollbackOnly.")
    public IllegalStateException failToCallSetRollbackOnlyOnNoneCMB();

    @Message(id=183, value="setRollbackOnly() not allowed without a transaction.")
    public IllegalStateException failToCallSetRollbackOnlyWithNoTx();

    @Message(id=184, value="EjbJarConfiguration cannot be null")
    public IllegalArgumentException EjbJarConfigurationIsNull();

    @Message(id=185, value="Cannot set security roles to null")
    public IllegalArgumentException SecurityRolesIsNull();

    @Message(id=186, value="Classname cannot be null or empty: %s")
    public IllegalArgumentException classnameIsNull(String var1);

    @Message(id=187, value="Cannot set null roles for class %s")
    public IllegalArgumentException setRolesForClassIsNull(String var1);

    @Message(id=188, value="EJB method identifier cannot be null while setting roles on method")
    public IllegalArgumentException ejbMethodIsNull();

    @Message(id=189, value="Roles cannot be null while setting roles on method: %s")
    public IllegalArgumentException rolesIsNull(EJBMethodIdentifier var1);

    @Message(id=190, value="EJB method identifier cannot be null while setting roles on view type: %s")
    public IllegalArgumentException ejbMethodIsNullForViewType(MethodIntf var1);

    @Message(id=191, value="Roles cannot be null while setting roles on view type: %s")
    public IllegalArgumentException rolesIsNullOnViewType(MethodIntf var1);

    @Message(id=192, value="Roles cannot be null while setting roles on view type: %s and method: %s")
    public IllegalArgumentException rolesIsNullOnViewTypeAndMethod(MethodIntf var1, EJBMethodIdentifier var2);

    @Message(id=193, value="Cannot link from a null or empty security role: %s")
    public IllegalArgumentException failToLinkFromEmptySecurityRole(String var1);

    @Message(id=194, value="Cannot link to a null or empty security role: %s")
    public IllegalArgumentException failToLinkToEmptySecurityRole(String var1);

    @Message(id=195, value="EjbJarConfiguration not found as an attachment in deployment unit: %s")
    public DeploymentUnitProcessingException ejbJarConfigNotFound(DeploymentUnit var1);

    @Message(id=196, value="ComponentViewInstance not available in interceptor context: %s")
    public IllegalStateException componentViewNotAvailableInContext(InterceptorContext var1);

    @Message(id=197, value="Unknown timeout method %s")
    public RuntimeException failToCallTimeOutMethod(Method var1);

    @Message(id=198, value="Component %s does not have a timeout method")
    public IllegalArgumentException componentTimeoutMethodNotSet(String var1);

    @Message(id=199, value="No resource adapter registered with resource adapter name %s")
    public IllegalStateException unknownResourceAdapter(String var1);

    @Message(id=200, value="found more than one RA registered as %s")
    public IllegalStateException multipleResourceAdapterRegistered(String var1);

    @Message(id=201, value="Security is not enabled")
    public UnsupportedOperationException securityNotEnabled();

    @Message(id=202, value="Task did not complete in %s  %S")
    public TimeoutException failToCompleteTaskBeforeTimeOut(long var1, TimeUnit var3);

    @Message(id=203, value="Task was cancelled")
    public CancellationException taskWasCancelled();

    @Message(id=204, value="Could not resolve ejbRemove method for interface method on EJB %s")
    public DeploymentUnitProcessingException failToResolveEjbRemoveForInterface(String var1);

    @Message(id=205, value="Could not resolve corresponding %s for home interface method %s on EJB %s")
    public DeploymentUnitProcessingException failToResolveMethodForHomeInterface(String var1, Method var2, String var3);

    @Message(id=206, value="Not implemented yet")
    public IllegalStateException methodNotImplemented();

    @Message(id=207, value="%s was attached to a view that is not an EJBObject or an EJBLocalObject")
    public RuntimeException classAttachToViewNotEjbObject(Class<?> var1);

    @Message(id=208, value="Invocation was not associated with an instance, primary key was null, instance may have been removed")
    public NoSuchEJBException invocationNotAssociated();

    @Message(id=209, value="Could not re-acquire lock for non-reentrant instance %s")
    public EJBException failToReacquireLockForNonReentrant(ComponentInstance var1);

    @Message(id=210, value="Could not find entity from %s with params %s")
    public ObjectNotFoundException couldNotFindEntity(Method var1, String var2);

    @Message(id=211, value="Invocation was not associated with an instance, primary key was null, instance may have been removed")
    public NoSuchEJBException primaryKeyIsNull();

    @Message(id=212, value="Instance of %s with primary key %s has been removed")
    public NoSuchEntityException instanceWasRemoved(String var1, Object var2);

    @Message(id=213, value="Unexpected component: %s component Expected %s")
    public IllegalStateException unexpectedComponent(Component var1, Class<?> var2);

    @Message(id=214, value="EjbJarConfiguration hasn't been set in %s Cannot create component create service for EJB %S")
    public IllegalStateException ejbJarConfigNotBeenSet(ComponentCreateServiceFactory var1, String var2);

    @Message(id=215, value="Cannot find any resource adapter service for resource adapter %s")
    public IllegalStateException failToFindResourceAdapter(String var1);

    @Message(id=216, value="No resource-adapter has been specified for %s")
    public IllegalStateException resourceAdapterNotSpecified(MessageDrivenComponent var1);

    @Message(id=217, value="PoolConfig cannot be null")
    public IllegalArgumentException poolConfigIsNull();

    @Message(id=218, value="PoolConfig cannot be null or empty")
    public IllegalStateException poolConfigIsEmpty();

    @Message(id=219, value="Cannot invoke %s in a session bean lifecycle method")
    public IllegalStateException failToInvokeMethodInSessionBeanLifeCycle(String var1);

    @Message(id=220, value="[EJB 3.1 spec, section 4.9.7] - Can't add view class: %s as local view since it's already marked as remote view for bean: %s")
    public IllegalStateException failToAddClassToLocalView(String var1, String var2);

    @Message(id=221, value="Business interface type cannot be null")
    public IllegalStateException businessInterfaceIsNull();

    @Message(id=222, value="Bean %s does not have an %s")
    public IllegalStateException beanComponentMissingEjbObject(String var1, String var2);

    @Message(id=223, value="EJB 3.1 FR 13.6.2.9 getRollbackOnly is not allowed with SUPPORTS attribute")
    public IllegalStateException getRollBackOnlyIsNotAllowWithSupportsAttribute();

    @Message(id=224, value="Not a business method %s. Do not call non-public methods on EJB's")
    public EJBException failToCallBusinessOnNonePublicMethod(Method var1);

    @Message(id=225, value="Component instance isn't available for invocation: %s")
    public Exception componentInstanceNotAvailable(InterceptorContext var1);

    @Message(id=226, value="Component %s with component class: %s isn't a singleton component")
    public IllegalArgumentException componentNotSingleton(Component var1, Class<?> var2);

    @Message(id=227, value="SingletonComponent cannot be null")
    public IllegalArgumentException singletonComponentIsNull();

    @Message(id=228, value="EJB 3.1 FR 4.3.14.1 concurrent access timeout on %s - could not obtain lock within %s %s")
    public ConcurrentAccessTimeoutException failToObtainLock(String var1, long var2, TimeUnit var4);

    @Message(id=229, value="Unable to find method %s %s")
    public RuntimeException failToFindMethod(String var1, String var2);

    @Message(id=230, value="TimerService is not supported for Stateful session bean %s")
    public IllegalStateException timerServiceNotSupportedForSFSB(String var1);

    @Message(id=231, value="Session id cannot be null")
    public IllegalArgumentException sessionIdIsNull();

    @Message(id=232, value="Stateful component cannot be null")
    public IllegalArgumentException statefulComponentIsNull();

    @Message(id=233, value="Could not create session for Stateful bean %s")
    public RuntimeException failToCreateStatefulSessionBean(String var1, @Cause Throwable var2);

    @Message(id=234, value="Session id hasn't been set for stateful component: %s")
    public IllegalStateException statefulSessionIdIsNull(String var1);

    @Message(id=235, value="@Remove method identifier cannot be null")
    public IllegalArgumentException removeMethodIsNull();

    @Message(id=236, value="Component %s with component class: %s%n isn't a %s component")
    public IllegalArgumentException componentNotInstanceOfSessionComponent(Component var1, Class<?> var2, String var3);

    @Message(id=237, value="both methodIntf and className are set on %s")
    public IllegalArgumentException bothMethodIntAndClassNameSet(String var1);

    @Message(id=238, value="EJB 3.1 PFD2 4.8.5.1.1 upgrading from read to write lock is not allowed")
    public IllegalLoopbackException failToUpgradeToWriteLock();

    @Message(id=239, value="%s cannot be null")
    public IllegalArgumentException componentIsNull(String var1);

    @Message(id=240, value="Invocation context: %s cannot be processed because it's not applicable for a method invocation")
    public IllegalArgumentException invocationNotApplicableForMethodInvocation(InvocationContext var1);

    @Message(id=241, value="EJB 3.1 PFD2 4.8.5.5.1 concurrent access timeout on %s - could not obtain lock within %s")
    public ConcurrentAccessTimeoutException concurrentAccessTimeoutException(String var1, String var2);

    @Message(id=242, value="Illegal lock type %s on %s for component %s")
    public IllegalStateException failToObtainLockIllegalType(LockType var1, Method var2, LockableComponent var3);

    @Message(id=243, value="Cannot call %s, no %s is present for this invocation")
    public IllegalStateException cannotCall(String var1, String var2);

    @Message(id=244, value="No asynchronous invocation in progress")
    public IllegalStateException noAsynchronousInvocationInProgress();

    @Message(id=245, value="%s is not allowed while dependency injection is in progress")
    public IllegalStateException callMethodNotAllowWhenDependencyInjectionInProgress(String var1);

    @Message(id=246, value="%s is deprecated")
    public UnsupportedOperationException isDeprecated(String var1);

    @Message(id=247, value="Getting parameters is not allowed on lifecycle callbacks")
    public IllegalStateException gettingParametersNotAllowLifeCycleCallbacks();

    @Message(id=248, value="%s is not allowed in lifecycle callbacks (EJB 3.1 FR 4.6.1, 4.7.2, 4.8.6, 5.5.1)")
    public IllegalStateException notAllowedInLifecycleCallbacks(String var1);

    @Message(id=249, value="Setting parameters is not allowed on lifecycle callbacks")
    public IllegalStateException setParameterNotAllowOnLifeCycleCallbacks();

    @Message(id=250, value="Got wrong number of arguments, expected %s, got %s on %s")
    public IllegalArgumentException wrongNumberOfArguments(int var1, int var2, Method var3);

    @Message(id=251, value="Parameter %s has the wrong type, expected %, got %s on %s")
    public IllegalArgumentException wrongParameterType(int var1, Class<?> var2, Class<?> var3, Method var4);

    @Message(id=252, value="No current invocation context available")
    public IllegalStateException noCurrentContextAvailable();

    @Message(id=253, value="Should be overridden")
    public IllegalStateException shouldBeOverridden();

    @Message(id=254, value="Could not find session bean with name %s")
    public DeploymentUnitProcessingException couldNotFindSessionBean(String var1);

    @Message(id=255, value="<role-name> cannot be null or empty in <security-role-ref>%nfor bean: %s")
    public DeploymentUnitProcessingException roleNamesIsNull(String var1);

    @Message(id=256, value="Default interceptors cannot specify a method to bind to in ejb-jar.xml")
    public DeploymentUnitProcessingException defaultInterceptorsNotBindToMethod();

    @Message(id=258, value="Two ejb-jar.xml bindings for %s specify an absolute order")
    public DeploymentUnitProcessingException twoEjbBindingsSpecifyAbsoluteOrder(String var1);

    @Message(id=259, value="Could not find method %s.%s referenced in ejb-jar.xml")
    public DeploymentUnitProcessingException failToFindMethodInEjbJarXml(String var1, String var2);

    @Message(id=260, value="More than one method %s found on class %s referenced in ejb-jar.xml. Specify the parameter types to resolve the ambiguity")
    public DeploymentUnitProcessingException multipleMethodReferencedInEjbJarXml(String var1, String var2);

    @Message(id=261, value="Could not find method %s.%s with parameter types %s referenced in ejb-jar.xml")
    public DeploymentUnitProcessingException failToFindMethodWithParameterTypes(String var1, String var2, MethodParametersMetaData var3);

    @Message(id=262, value="Could not load component class for component %s")
    public DeploymentUnitProcessingException failToLoadComponentClass(@Cause Throwable var1, String var2);

    @Message(id=263, value="Could not load EJB view class ")
    public RuntimeException failToLoadEjbViewClass(@Cause Throwable var1);

    @Message(id=264, value="Could not merge data for %s")
    public DeploymentUnitProcessingException failToMergeData(String var1, @Cause Throwable var2);

    @Message(id=265, value="Could not load EJB class %s")
    public DeploymentUnitProcessingException failToLoadEjbClass(String var1, @Cause Throwable var2);

    @Message(id=266, value="Only one %s method is allowed on bean %s")
    public RuntimeException multipleAnnotationsOnBean(String var1, String var2);

    @Message(id=267, value="Could not determine type of corresponding implied EJB 2.x local interface (see EJB 3.1 21.4.5)%n due to multiple create* methods with different return types on home %s")
    public DeploymentUnitProcessingException multipleCreateMethod(Class<?> var1);

    @Message(id=268, value="Could not find EJB %s referenced by @DependsOn annotation in %s")
    public DeploymentUnitProcessingException failToFindEjbRefByDependsOn(String var1, String var2);

    @Message(id=269, value="More than one EJB called %s referenced by @DependsOn annotation in %s Components:%s")
    public DeploymentUnitProcessingException failToCallEjbRefByDependsOn(String var1, String var2, Set<ComponentDescription> var3);

    @Message(id=270, value="Async method %s does not return void or Future")
    public DeploymentUnitProcessingException wrongReturnTypeForAsyncMethod(Method var1);

    @Message(id=271, value="Could not load application exception class %s in ejb-jar.xml")
    public DeploymentUnitProcessingException failToLoadAppExceptionClassInEjbJarXml(String var1, @Cause Throwable var2);

    @Message(id=272, value="EJB %s entity bean %s implemented TimedObject, but has a different timeout method specified either via annotations or via the deployment descriptor")
    public DeploymentUnitProcessingException invalidEjbEntityTimeout(String var1, Class<?> var2);

    @Message(id=273, value="%s does not have an EJB 2.x local interface")
    public RuntimeException invalidEjbLocalInterface(String var1);

    @Message(id=274, value="Local Home not allowed for %s")
    public DeploymentUnitProcessingException localHomeNotAllow(EJBComponentDescription var1);

    @Message(id=275, value="Could not resolve corresponding ejbCreate or @Init method for home interface method %s on EJB %s")
    public DeploymentUnitProcessingException failToCallEjbCreateForHomeInterface(Method var1, String var2);

    @Message(id=276, value="EJBComponent has not been set in the current invocation context %s")
    public IllegalStateException failToGetEjbComponent(InterceptorContext var1);

    @Message(id=277, value="Value cannot be null")
    public IllegalArgumentException valueIsNull();

    @Message(id=278, value="Cannot create %s from a null schedule expression")
    public IllegalArgumentException invalidScheduleExpression(String var1);

    @Message(id=279, value="Second cannot be null in schedule expression %s")
    public IllegalArgumentException invalidScheduleExpressionSecond(ScheduleExpression var1);

    @Message(id=280, value="Minute cannot be null in schedule expression %s")
    public IllegalArgumentException invalidScheduleExpressionMinute(ScheduleExpression var1);

    @Message(id=281, value="Hour cannot be null in schedule expression %s")
    public IllegalArgumentException invalidScheduleExpressionHour(ScheduleExpression var1);

    @Message(id=282, value="day-of-month cannot be null in schedule expression %s")
    public IllegalArgumentException invalidScheduleExpressionDayOfMonth(ScheduleExpression var1);

    @Message(id=283, value="day-of-week cannot be null in schedule expression %s")
    public IllegalArgumentException invalidScheduleExpressionDayOfWeek(ScheduleExpression var1);

    @Message(id=284, value="Month cannot be null in schedule expression %s")
    public IllegalArgumentException invalidScheduleExpressionMonth(ScheduleExpression var1);

    @Message(id=285, value="Year cannot be null in schedule expression %s")
    public IllegalArgumentException invalidScheduleExpressionYear(ScheduleExpression var1);

    @Message(id=286, value="Invalid range value: %s")
    public IllegalArgumentException invalidRange(String var1);

    @Message(id=287, value="Invalid list expression: %s")
    public IllegalArgumentException invalidListExpression(String var1);

    @Message(id=288, value="Invalid increment value: %s")
    public IllegalArgumentException invalidIncrementValue(String var1);

    @Message(id=289, value="There are no valid seconds for expression: %s")
    public IllegalStateException invalidExpressionSeconds(String var1);

    @Message(id=290, value="There are no valid minutes for expression: %s")
    public IllegalStateException invalidExpressionMinutes(String var1);

    @Message(id=291, value="Invalid value: %s since %s doesn't support values of types %s")
    public IllegalArgumentException invalidScheduleExpressionType(String var1, String var2, String var3);

    @Message(id=292, value="A list value can only contain either a range or an individual value. Invalid value: %s")
    public IllegalArgumentException invalidListValue(String var1);

    @Message(id=293, value="Could not parse: %s in schedule expression")
    public IllegalArgumentException couldNotParseScheduleExpression(String var1);

    @Message(id=294, value="Invalid value: %s Valid values are between %s and %s")
    public IllegalArgumentException invalidValuesRange(Integer var1, int var2, int var3);

    @Message(id=295, value="Invalid value for day-of-month: %s")
    public IllegalArgumentException invalidValueDayOfMonth(Integer var1);

    @Message(id=296, value="Relative day-of-month cannot be null or empty")
    public IllegalArgumentException relativeDayOfMonthIsNull();

    @Message(id=297, value="%s is not a relative value")
    public IllegalArgumentException invalidRelativeValue(String var1);

    @Message(id=298, value="Value is null, cannot determine if it's relative")
    public IllegalArgumentException relativeValueIsNull();

    @Message(id=299, value="null timerservice cannot be registered")
    public IllegalArgumentException timerServiceNotRegistered();

    @Message(id=300, value="Timer service with timedObjectId: %s is already registered")
    public IllegalStateException timerServiceAlreadyRegistered(String var1);

    @Message(id=301, value="null timedObjectId cannot be used for unregistering timerservice")
    public IllegalStateException timedObjectIdIsNullForUnregisteringTimerService();

    @Message(id=302, value="Cannot unregister timer service with timedObjectId: %s because it's not registered")
    public IllegalStateException failToUnregisterTimerService(String var1);

    @Message(id=303, value="Invoker cannot be null")
    public IllegalArgumentException invokerIsNull();

    @Message(id=304, value="Transaction manager cannot be null")
    public IllegalArgumentException transactionManagerIsNull();

    @Message(id=305, value="Executor cannot be null")
    public IllegalArgumentException executorIsNull();

    @Message(id=306, value="initialExpiration cannot be null while creating a timer")
    public IllegalArgumentException initialExpirationIsNullCreatingTimer();

    @Message(id=307, value="%s cannot be negative while creating a timer")
    public IllegalArgumentException invalidInitialExpiration(String var1);

    @Message(id=308, value="expiration cannot be null while creating a single action timer")
    public IllegalArgumentException expirationIsNull();

    @Message(id=309, value="expiration.getTime() cannot be negative while creating a single action timer")
    public IllegalArgumentException invalidExpirationActionTimer();

    @Message(id=310, value="duration cannot be negative while creating single action timer")
    public IllegalArgumentException invalidDurationActionTimer();

    @Message(id=311, value="Duration cannot negative while creating the timer")
    public IllegalArgumentException invalidDurationTimer();

    @Message(id=312, value="Expiration date cannot be null while creating a timer")
    public IllegalArgumentException expirationDateIsNull();

    @Message(id=313, value="expiration.getTime() cannot be negative while creating a timer")
    public IllegalArgumentException invalidExpirationTimer();

    @Message(id=314, value="Initial duration cannot be negative while creating timer")
    public IllegalArgumentException invalidInitialDurationTimer();

    @Message(id=315, value="Interval cannot be negative while creating timer")
    public IllegalArgumentException invalidIntervalTimer();

    @Message(id=316, value="initial expiration date cannot be null while creating a timer")
    public IllegalArgumentException initialExpirationDateIsNull();

    @Message(id=317, value="interval duration cannot be negative while creating timer")
    public IllegalArgumentException invalidIntervalDurationTimer();

    @Message(id=318, value="Creation of timers is not allowed during lifecycle callback of non-singleton EJBs")
    public IllegalStateException failToCreateTimerDoLifecycle();

    @Message(id=319, value="initial expiration is null")
    public IllegalArgumentException initialExpirationIsNull();

    @Message(id=320, value="interval duration is negative")
    public IllegalArgumentException invalidIntervalDuration();

    @Message(id=321, value="schedule is null")
    public IllegalArgumentException scheduleIsNull();

    @Message(id=322, value="Could not start transaction")
    public RuntimeException failToStartTransaction(@Cause Throwable var1);

    @Message(id=323, value="Transaction cannot be ended since no transaction is in progress")
    public IllegalStateException noTransactionInProgress();

    @Message(id=324, value="Could not end transaction")
    public RuntimeException failToEndTransaction(@Cause Throwable var1);

    @Message(id=325, value="Cannot invoke timer service methods in lifecycle callback of non-singleton beans")
    public IllegalStateException failToInvokeTimerServiceDoLifecycle();

    @Message(id=326, value="Timer cannot be null")
    public IllegalStateException timerIsNull();

    @Message(id=327, value="%s Timer handles are only available for persistent timers.")
    public IllegalStateException invalidTimerHandlersForPersistentTimers(String var1);

    @Message(id=328, value="No more timeouts for timer %s")
    public NoMoreTimeoutsException noMoreTimeoutForTimer(TimerImpl var1);

    @Message(id=329, value="Timer %s is not a calendar based timer")
    public IllegalStateException invalidTimerNotCalendarBaseTimer(TimerImpl var1);

    @Message(id=330, value="Timer has expired")
    public NoSuchObjectLocalException timerHasExpired();

    @Message(id=331, value="Timer was canceled")
    public NoSuchObjectLocalException timerWasCanceled();

    @Message(id=332, value="Timer %s is not persistent")
    public IllegalStateException failToPersistTimer(TimerImpl var1);

    @Message(id=333, value="Could not register with tx for timer cancellation")
    public RuntimeException failToRegisterWithTxTimerCancellation(@Cause Throwable var1);

    @Message(id=334, value="Could not deserialize info in timer ")
    public RuntimeException failToDeserializeInfoInTimer(@Cause Throwable var1);

    @Message(id=335, value="Id cannot be null")
    public IllegalArgumentException idIsNull();

    @Message(id=336, value="Timed objectid cannot be null")
    public IllegalArgumentException timedObjectNull();

    @Message(id=337, value="Timer service cannot be null")
    public IllegalArgumentException timerServiceIsNull();

    @Message(id=338, value="Timerservice with timedObjectId: %s is not registered")
    public EJBException timerServiceWithIdNotRegistered(String var1);

    @Message(id=339, value="Timer for handle: %s is not active")
    public NoSuchObjectLocalException timerHandleIsNotActive(TimerHandle var1);

    @Message(id=340, value="Could not find timeout method: %s")
    public IllegalStateException failToFindTimeoutMethod(TimeoutMethod var1);

    @Message(id=341, value="Cannot invoke getTimeoutMethod on a timer which is not an auto-timer")
    public IllegalStateException failToInvokegetTimeoutMethod();

    @Message(id=342, value="Could not load declaring class: %s of timeout method")
    public RuntimeException failToLoadDeclaringClassOfTimeOut(String var1);

    @Message(id=343, value="Cannot invoke timeout method because method %s is not a timeout method")
    public RuntimeException failToInvokeTimeout(Method var1);

    @Message(id=344, value="Could not create timer file store directory %s")
    public RuntimeException failToCreateTimerFileStoreDir(File var1);

    @Message(id=345, value="Timer file store directory %s does not exist")
    public RuntimeException timerFileStoreDirNotExist(File var1);

    @Message(id=346, value="Timer file store directory %s is not a directory")
    public RuntimeException invalidTimerFileStoreDir(File var1);

    @Message(id=347, value="EJB %s is enabled for security but doesn't have a security domain set")
    public IllegalStateException invalidSecurityForDomainSet(String var1);

    @Message(id=348, value="%s is not an EJB component")
    public IllegalArgumentException invalidComponentConfiguration(String var1);

    @Message(id=349, value="Could not load view class for ejb %s")
    public RuntimeException failToLoadViewClassEjb(String var1, @Cause Throwable var2);

    @Message(id=350, value="Component named %s with component class %s is not an EJB component")
    public IllegalArgumentException invalidEjbComponent(String var1, Class<?> var2);

    @Message(id=351, value="No timed object invoke for %s")
    public StartException failToInvokeTimedObject(EJBComponent var1);

    @Message(id=352, value="TimerService is not started")
    public IllegalStateException failToStartTimerService();

    @Message(id=353, value="ResourceBundle based descriptions of %s are not supported")
    public UnsupportedOperationException resourceBundleDescriptionsNotSupported(String var1);

    @Message(id=354, value="Runtime attribute %s is not marshallable")
    public UnsupportedOperationException runtimeAttributeNotMarshallable(String var1);

    @Message(id=355, value="Invalid value: %s for '%s' element %s")
    public String invalidValueForElement(String var1, String var2, Location var3);

    @Message(id=356, value="EJB component type %s does not support pools")
    public IllegalStateException invalidComponentType(String var1);

    @Message(id=357, value="Unknown EJBComponent type %s")
    public IllegalStateException unknownComponentType(EJBComponentType var1);

    @Message(id=358, value="Method %s for view %s shouldn't be marked for both %s and %s at the same time")
    public IllegalStateException invalidSecurityAnnotation(Method var1, String var2, String var3, String var4);

    @Message(id=359, value="Method named %s with params %s not found on component class %s")
    public RuntimeException failToFindComponentMethod(String var1, String var2, Class<?> var3);

    @Message(id=360, value="EJB method security metadata cannot be null")
    public IllegalArgumentException ejbMethodSecurityMetaDataIsNull();

    @Message(id=361, value="View classname cannot be null or empty")
    public IllegalArgumentException viewClassNameIsNull();

    @Message(id=362, value="View method cannot be null")
    public IllegalArgumentException viewMethodIsNull();

    @Message(id=363, value="%s cannot handle method %s of view class %s.Expected view method to be %s on view class %s")
    public IllegalStateException failProcessInvocation(String var1, Method var2, String var3, Method var4, String var5);

    @Message(id=364, value="Invocation on method: %s of bean: %s is not allowed")
    public EJBAccessException invocationOfMethodNotAllowed(Method var1, String var2);

    @Message(id=365, value="Unknown EJB Component description type %s")
    public IllegalArgumentException unknownComponentDescriptionType(Class<?> var1);

    @Message(id=366, value="Unknown attribute %s")
    public IllegalStateException unknownAttribute(String var1);

    @Message(id=367, value="Unknown operation %s")
    public IllegalStateException unknownOperations(String var1);

    @Message(id=368, value="No EJB component registered for address %s")
    public String noComponentRegisteredForAddress(PathAddress var1);

    @Message(id=369, value="No EJB component is available for address %s")
    public String noComponentAvailableForAddress(PathAddress var1);

    @Message(id=370, value="EJB component for address %s is in %n state %s, must be in state %s")
    public String invalidComponentState(PathAddress var1, ServiceController.State var2, ServiceController.State var3);

    @Message(id=371, value="%s is not an EJB component")
    public IllegalArgumentException invalidComponentIsNotEjbComponent(String var1);

    @Message(id=372, value="Component class %s has multiple @Timeout annotations")
    public DeploymentUnitProcessingException componentClassHasMultipleTimeoutAnnotations(Class<?> var1);

    @Message(id=373, value="Current component is not an EJB %s")
    public IllegalStateException currentComponentNotAEjb(ComponentInstance var1);

    @Message(id=374, value="%s not allowed in lifecycle methods")
    public IllegalStateException lifecycleMethodNotAllowed(String var1);

    @Message(id=375, value="%s is not allowed in lifecycle methods of stateless session beans")
    public IllegalStateException lifecycleMethodNotAllowedFromStatelessSessionBean(String var1);

    @Message(id=376, value="Cannot call %s when invoking through %s or %s")
    public IllegalStateException cannotCall(String var1, String var2, String var3);

    @Message(id=377, value="%s is not allowed from stateful beans")
    public IllegalStateException notAllowedFromStatefulBeans(String var1);

    @Message(id=378, value="Failed to acquire a permit within %s %s")
    public EJBException failedToAcquirePermit(long var1, TimeUnit var3);

    @Message(id=379, value="Acquire semaphore was interrupted")
    public EJBException acquireSemaphoreInterrupted();

    @Message(id=380, value="%s is deprecated")
    public IllegalStateException isDeprecatedIllegalState(String var1);

    @Message(id=381, value="Could not find method %s on entity bean")
    public RuntimeException couldNotFindEntityBeanMethod(String var1);

    @Message(id=382, value="Could not determine ClassLoader for stub %s")
    public RuntimeException couldNotFindClassLoaderForStub(String var1);

    @Message(id=383, value="No message listener of type %s found in resource adapter %s")
    public IllegalStateException unknownMessageListenerType(String var1, String var2);

    @Message(id=384, value="Could not find method %s from view %s on EJB class %s")
    public DeploymentUnitProcessingException couldNotFindViewMethodOnEjb(Method var1, String var2, String var3);

    @Message(id=385, value="%s cannot be null or empty")
    public IllegalArgumentException stringParamCannotBeNullOrEmpty(String var1);

    @Message(id=386, value="EJB 4.6.4 Cannot remove EJB via EJB 2.x remove() method while participating in a transaction")
    public RemoveException cannotRemoveWhileParticipatingInTransaction();

    @Message(id=387, value="Transaction propagation over IIOP is not supported")
    public RemoteException transactionPropagationNotSupported();

    @Deprecated
    @Message(id=388, value="Cannot call method %s in afterCompletion callback")
    public IllegalStateException cannotCallMethodInAfterCompletion(String var1);

    @Message(id=389, value="Cannot call %s when state is %s")
    public IllegalStateException cannotCallMethod(String var1, String var2);

    @Deprecated
    @Message(id=390, value="%s is already associated with serialization group %s")
    public IllegalStateException existingSerializationGroup(Object var1, Object var2);

    @Deprecated
    @Message(id=391, value="%s is not compatible with serialization group %s")
    public IllegalStateException incompatibleSerializationGroup(Object var1, Object var2);

    @Deprecated
    @Message(id=392, value="Cache entry %s is in use")
    public IllegalStateException cacheEntryInUse(Object var1);

    @Deprecated
    @Message(id=393, value="Cache entry %s is not in use")
    public IllegalStateException cacheEntryNotInUse(Object var1);

    @Deprecated
    @Message(id=394, value="Failed to acquire lock on %s")
    public RuntimeException lockAcquisitionInterrupted(@Cause Throwable var1, Object var2);

    @Deprecated
    @Message(id=395, value="%s is already a member of serialization group %s")
    public IllegalStateException duplicateSerializationGroupMember(Object var1, Object var2);

    @Deprecated
    @Message(id=396, value="%s is not a member of serialization group %s")
    public IllegalStateException missingSerializationGroupMember(Object var1, Object var2);

    @Deprecated
    @Message(id=397, value="%s already exists in cache")
    public IllegalStateException duplicateCacheEntry(Object var1);

    @Deprecated
    @Message(id=398, value="%s is missing from cache")
    public IllegalStateException missingCacheEntry(Object var1);

    @Message(id=399, value="Incompatible cache implementations in nested hierarchy")
    public IllegalStateException incompatibleCaches();

    @Deprecated
    @Message(id=400, value="Failed to passivate %s")
    public RuntimeException passivationFailed(@Cause Throwable var1, Object var2);

    @Deprecated
    @Message(id=401, value="Failed to activate %s")
    public RuntimeException activationFailed(@Cause Throwable var1, Object var2);

    @Deprecated
    @Message(id=402, value="Failed to create passivation directory: %s")
    public RuntimeException passivationDirectoryCreationFailed(String var1);

    @Deprecated
    @Message(id=403, value="Failed to create passivation directory: %s")
    public RuntimeException passivationPathNotADirectory(String var1);

    @Deprecated
    @Message(id=404, value="Group creation context already exists")
    public IllegalStateException groupCreationContextAlreadyExists();

    @Message(id=405, value="No EJB found with interface of type '%s' and name '%s' for binding %s")
    public String ejbNotFound(String var1, String var2, String var3);

    @Message(id=406, value="No EJB found with interface of type '%s' for binding %s")
    public String ejbNotFound(String var1, String var2);

    @Message(id=407, value="More than one EJB found with interface of type '%s' and name '%s' for binding %s. Found: %s")
    public String moreThanOneEjbFound(String var1, String var2, String var3, Set<EJBViewDescription> var4);

    @Message(id=408, value="More than one EJB found with interface of type '%s' for binding %s. Found: %s")
    public String moreThanOneEjbFound(String var1, String var2, Set<EJBViewDescription> var3);

    @Deprecated
    @Message(id=409, value="@Clustered annotation cannot be used with message driven beans. %s failed since %s bean is marked with @Clustered on class %s")
    public DeploymentUnitProcessingException clusteredAnnotationIsNotApplicableForMDB(DeploymentUnit var1, String var2, String var3);

    @Deprecated
    @Message(id=410, value="@Clustered annotation cannot be used with entity beans. %s failed since %s bean is marked with @Clustered on class %s")
    public DeploymentUnitProcessingException clusteredAnnotationIsNotApplicableForEntityBean(DeploymentUnit var1, String var2, String var3);

    @Deprecated
    @Message(id=411, value="@Clustered annotation is currently not supported for singleton EJB. %s failed since %s bean is marked with @Clustered on class %s")
    public DeploymentUnitProcessingException clusteredAnnotationNotYetImplementedForSingletonBean(DeploymentUnit var1, String var2, String var3);

    @Deprecated
    @Message(id=412, value="%s failed since @Clustered annotation cannot be used for %s bean on class %s")
    public DeploymentUnitProcessingException clusteredAnnotationIsNotApplicableForBean(DeploymentUnit var1, String var2, String var3);

    @Message(id=413, value="<session-type> not specified for ejb %s. This must be present in ejb-jar.xml")
    public DeploymentUnitProcessingException sessionTypeNotSpecified(String var1);

    @Message(id=414, value="Default interceptors cannot specify an <interceptor-order> element in ejb-jar.xml")
    public DeploymentUnitProcessingException defaultInterceptorsNotSpecifyOrder();

    @Message(id=415, value="Cache is not clustered")
    public IllegalStateException cacheIsNotClustered();

    @Message(id=416, value="%s cannot be null")
    public IllegalArgumentException paramCannotBeNull(String var1);

    @Message(id=417, value="A GroupMembershipNotifier is already registered by the name of %s")
    public IllegalArgumentException groupMembershipNotifierAlreadyRegistered(String var1);

    @Message(id=418, value="No GroupMembershipNotifier registered by the name of %s")
    public IllegalArgumentException groupMembershipNotifierNotRegistered(String var1);

    @Message(id=419, value="Pool name cannot be empty string for bean %s")
    public IllegalArgumentException poolNameCannotBeEmptyString(String var1);

    @Message(id=420, value="No EjbContext available as no EJB invocation is active")
    public IllegalStateException noEjbContextAvailable();

    @Message(id=421, value="Invocation cannot proceed as component is shutting down")
    public EJBComponentUnavailableException componentIsShuttingDown();

    @Message(id=422, value="Could not open message outputstream for writing to Channel")
    public IOException failedToOpenMessageOutputStream(@Cause Throwable var1);

    @Message(id=423, value="Could not create session for stateful bean %s")
    public RuntimeException failedToCreateSessionForStatefulBean(@Cause Exception var1, String var2);

    @Message(id=424, value="No thread context classloader available")
    public IllegalStateException tcclNotAvailable();

    @Message(id=425, value="Cannot write to null DataOutput")
    public IllegalArgumentException cannotWriteToNullDataOutput();

    @Message(id=426, value="No client-mapping entries found for node %s in cluster %s")
    public IllegalStateException clientMappingMissing(String var1, String var2);

    @Message(id=427, value="Could not load class")
    public RuntimeException classNotFoundException(@Cause ClassNotFoundException var1);

    @Message(id=428, value="EJB module identifiers cannot be null")
    public IllegalArgumentException ejbModuleIdentifiersCannotBeNull();

    @Message(id=429, value="MessageInputStream cannot be null")
    public IllegalArgumentException messageInputStreamCannotBeNull();

    @Message(id=430, value="Unknown transaction request type %s")
    public IllegalArgumentException unknownTransactionRequestType(String var1);

    @Message(id=431, value="Could not close channel")
    public RuntimeException couldNotCloseChannel(@Cause IOException var1);

    @Message(id=432, value="No subordinate transaction present for xid %s")
    public RuntimeException noSubordinateTransactionPresentForXid(Xid var1);

    @Message(id=433, value="Failed to register transaction synchronization")
    public RuntimeException failedToRegisterTransactionSynchronization(@Cause Exception var1);

    @Message(id=434, value="Failed to get current transaction")
    public RuntimeException failedToGetCurrentTransaction(@Cause Exception var1);

    @Message(id=435, value="Could not obtain lock on %s to passivate %s")
    public IllegalStateException couldNotObtainLockForGroup(String var1, String var2);

    @Message(id=436, value="Unknown channel creation option type %s")
    public IllegalArgumentException unknownChannelCreationOptionType(String var1);

    @Message(id=437, value="Could not determine remote interface from home interface %s for bean %s")
    public DeploymentUnitProcessingException couldNotDetermineRemoteInterfaceFromHome(String var1, String var2);

    @Message(id=438, value="Could not determine local interface from local home interface %s for bean %s")
    public DeploymentUnitProcessingException couldNotDetermineLocalInterfaceFromLocalHome(String var1, String var2);

    @Message(id=439, value="Unsupported marshalling version: %d")
    public IllegalArgumentException unsupportedMarshallingVersion(int var1);

    @Message(id=440, value="%s method %s must be public")
    public DeploymentUnitProcessingException ejbMethodMustBePublic(String var1, Method var2);

    @Message(id=441, value="EJB business method %s must be public")
    public DeploymentUnitProcessingException ejbBusinessMethodMustBePublic(Method var1);

    @Message(id=442, value="Unexpected Error")
    public EJBException unexpectedError();

    @Message(id=443, value="EJB 3.1 FR 13.3.3: BMT bean %s should complete transaction before returning.")
    public String transactionNotComplete(String var1);

    @Message(id=444, value="Timer service resource %s is not suitable for the target. Only a configuration with a single file-store and no other configured data-store is supported on target")
    public String untransformableTimerService(PathAddress var1);

    @Deprecated
    @Message(id=445, value="Detected asymmetric usage of cache")
    public IllegalStateException asymmetricCacheUsage();

    @Message(id=446, value="The timer %s is already active.")
    public IllegalStateException timerIsActive(Timer var1);

    @Message(id=447, value="Transaction '%s' was already rolled back")
    public RollbackException transactionAlreadyRolledBack(Transaction var1);

    @Message(id=448, value="Transaction '%s' is in unexpected state (%s)")
    public EJBException transactionInUnexpectedState(Transaction var1, String var2);

    @Message(id=449, value="Timerservice API is not allowed on stateful session bean %s")
    public String timerServiceMethodNotAllowedForSFSB(String var1);

    @Message(id=450, value="Entity Beans are no longer supported, beans %s cannot be deployed")
    public DeploymentUnitProcessingException entityBeansAreNotSupported(String var1);

    @Message(id=451, value="Attribute '%s' is not supported on current version servers; it is only allowed if its value matches '%s'")
    public OperationFailedException inconsistentAttributeNotSupported(String var1, String var2);

    @Message(id=452, value="Unexpected end of document")
    public XMLStreamException unexpectedEndOfDocument(@Param Location var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=453, value="Failed to persist timer %s")
    public void failedToPersistTimer(Timer var1, @Cause Exception var2);

    @Message(id=454, value="Only one instance on <container-transaction> with an ejb-name of * can be present.")
    public DeploymentUnitProcessingException mustOnlyBeSingleContainerTransactionElementWithWildcard();

    @Message(id=455, value="<container-transaction> elements that use the wildcard EJB name * can only use a method name of *")
    public DeploymentUnitProcessingException wildcardContainerTransactionElementsMustHaveWildcardMethodName();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=456, value="Failed to refresh timers for %s")
    public void failedToRefreshTimers(String var1);

    @Message(id=457, value="Unexpected Error")
    public String convertUnexpectedError();

    @Message(id=459, value="Module %s containing bean %s is not deployed in ear but it specifies resource adapter name '%s' in a relative format.")
    public DeploymentUnitProcessingException relativeResourceAdapterNameInStandaloneModule(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=460, value="The transaction isolation need to be equal or stricter than READ_COMMITTED to ensure that the timer run once-and-only-once")
    public void wrongTransactionIsolationConfiguredForTimer();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=461, value="Update timer failed and it was not possible to rollback the transaction!")
    public void timerUpdateFailedAndRollbackNotPossible(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=462, value="Unable to detect database dialect from connection metadata or JDBC driver name. Please configure this manually using the 'datasource' property in your configuration.  Known database dialect strings are %s")
    public void jdbcDatabaseDialectDetectionFailed(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=463, value="Invalid transaction attribute type %s on SFSB lifecycle method %s of class %s, valid types are REQUIRES_NEW and NOT_SUPPORTED. Method will be treated as NOT_SUPPORTED.")
    public void invalidTransactionTypeForSfsbLifecycleMethod(TransactionAttributeType var1, MethodIdentifier var2, Class<?> var3);

    @Message(id=464, value="The \"disable-default-ejb-permissions\" attribute may not be set to true")
    public OperationFailedException disableDefaultEjbPermissionsCannotBeTrue();

    @Message(id=465, value="Invalid client descriptor configuration: 'profile' and 'remoting-ejb-receivers' cannot be used together")
    public DeploymentUnitProcessingException profileAndRemotingEjbReceiversUsedTogether();

    @Message(id=466, value="Failed to process business interfaces for EJB class %s")
    public DeploymentUnitProcessingException failedToProcessBusinessInterfaces(Class<?> var1, @Cause Exception var2);

    @Message(id=467, value="The request was rejected as the container is suspended")
    public EJBComponentUnavailableException containerSuspended();

    @Message(id=468, value="Timer invocation failed")
    public OperationFailedException timerInvocationFailed(@Cause Exception var1);

    @Message(id=469, value="Indexed child resources can only be registered if the parent resource supports ordered children. The parent of '%s' is not indexed")
    public IllegalStateException indexedChildResourceRegistrationNotAvailable(PathElement var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=470, value="Could not create a connection for cluster node %s in cluster %s")
    public void couldNotCreateClusterConnection(@Cause Throwable var1, String var2, String var3);

    @Message(id=471, value="RMI/IIOP Violation: %s%n")
    public RuntimeException rmiIiopVoliation(String var1);

    @Message(id=472, value="Cannot obtain exception repository id for %s:%n%s")
    public RuntimeException exceptionRepositoryNotFound(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=473, value="JNDI bindings for session bean named '%s' in deployment unit '%s' are as follows:%s")
    public void jndiBindings(String var1, DeploymentUnit var2, StringBuilder var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=474, value="Attribute '%s' is not supported on current version servers; it is only allowed if its value matches '%s'. This attribute should be removed.")
    public void logInconsistentAttributeNotSupported(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=475, value="MDB delivery started: %s,%s")
    public void mdbDeliveryStarted(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=476, value="MDB delivery stopped: %s,%s")
    public void mdbDeliveryStopped(String var1, String var2);

    @Message(id=477, value="MDB delivery group is missing: %s")
    public DeploymentUnitProcessingException missingMdbDeliveryGroup(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=480, value="Loaded timer (%s) for EJB (%s) and this node that is marked as being in a timeout. The original timeout may not have been processed. Please use graceful shutdown to ensure timeout tasks are finished before shutting down.")
    public void loadedPersistentTimerInTimeout(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=481, value="Strict pool %s is using a max instance size of %d (per class), which is derived from thread worker pool sizing.")
    public void strictPoolDerivedFromWorkers(String var1, int var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=482, value="Strict pool %s is using a max instance size of %d (per class), which is derived from the number of CPUs on this host.")
    public void strictPoolDerivedFromCPUs(String var1, int var2);

    @Message(id=483, value="Attributes are mutually exclusive: %s, %s")
    public XMLStreamException mutuallyExclusiveAttributes(@Param Location var1, String var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=484, value="Could not send a cluster removal message for cluster: (%s) to the client on channel %s")
    public void couldNotSendClusterRemovalMessage(@Cause Throwable var1, Group var2, Channel var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=485, value="Transaction type %s is unspecified for the %s method of the %s message-driven bean. It will be handled as NOT_SUPPORTED.")
    public void invalidTransactionTypeForMDB(TransactionAttributeType var1, String var2, String var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=486, value="Parameter 'default-clustered-sfsb-cache' was defined for the 'add' operation for resource '%s'. This parameter is deprecated and its previous behavior has been remapped to attribute 'default-sfsb-cache'. As a result the 'default-sfsb-cache' attribute has been set to '%s' and the 'default-sfsb-passivation-disabled-cache' attribute has been set to '%s'.")
    public void remappingCacheAttributes(String var1, ModelNode var2, ModelNode var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=487, value="Unexpected invocation state %s")
    public void unexpectedInvocationState(int var1);

    @Message(id=488, value="Unauthenticated (anonymous) access to this EJB method is not authorized")
    public SecurityException ejbAuthenticationRequired();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=489, value="Timer %s not running as transaction could not be started")
    public void timerNotRunning(@Cause NotSupportedException var1, TimerImpl var2);

    @Message(id=490, value="Multiple security domains not supported")
    public DeploymentUnitProcessingException multipleSecurityDomainsDetected();

    @Message(id=491, value="The transaction begin request was rejected as the container is suspended")
    public EJBException cannotBeginUserTransaction();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=492, value="EJB subsystem suspension waiting for active transactions, %d transaction(s) remaining")
    public void suspensionWaitingActiveTransactions(int var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=493, value="EJB subsystem suspension complete")
    public void suspensionComplete();
}

