/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.deployment.EjbDeploymentInformation;
import org.jboss.as.ejb3.deployment.ModuleDeployment;
import org.jboss.marshalling.SerializabilityChecker;

public class StatefulSessionBeanSerializabilityChecker
implements SerializabilityChecker {
    private final Set<Class<?>> serializableClasses = Collections.newSetFromMap(new IdentityHashMap());

    public StatefulSessionBeanSerializabilityChecker(ModuleDeployment deployment) {
        for (EjbDeploymentInformation info : deployment.getEjbs().values()) {
            EJBComponent component = info.getEjbComponent();
            if (!(component instanceof StatefulSessionComponent)) continue;
            for (Class componentClass = component.getComponentClass(); componentClass != Object.class; componentClass = componentClass.getSuperclass()) {
                this.serializableClasses.add(componentClass);
            }
        }
    }

    public boolean isSerializable(Class<?> targetClass) {
        return targetClass != Object.class && (this.serializableClasses.contains(targetClass) || DEFAULT.isSerializable(targetClass));
    }
}

