/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.singleton;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.ejb.LockType;
import javax.interceptor.InvocationContext;
import org.jboss.as.ejb3.component.singleton.SingletonComponent;
import org.jboss.as.ejb3.concurrency.AccessTimeoutDetails;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;

class ContainerManagedConcurrencyInterceptor
implements Interceptor {
    private final SingletonComponent lockableComponent;
    private final Map<Method, Method> viewMethodToComponentMethodMap;

    public ContainerManagedConcurrencyInterceptor(SingletonComponent component, Map<Method, Method> viewMethodToComponentMethodMap) {
        this.viewMethodToComponentMethodMap = viewMethodToComponentMethodMap;
        if (component == null) {
            throw EjbLogger.ROOT_LOGGER.componentIsNull(SingletonComponent.class.getName());
        }
        this.lockableComponent = component;
    }

    protected SingletonComponent getLockableComponent() {
        return this.lockableComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        boolean success;
        InvocationContext invocationContext = context.getInvocationContext();
        SingletonComponent lockableComponent = this.getLockableComponent();
        Method method = invocationContext.getMethod();
        if (method == null) {
            throw EjbLogger.ROOT_LOGGER.invocationNotApplicableForMethodInvocation(invocationContext);
        }
        Method invokedMethod = this.viewMethodToComponentMethodMap.get(method);
        if (invokedMethod == null) {
            invokedMethod = method;
        }
        Lock lock = this.getLock(lockableComponent, invokedMethod);
        AccessTimeoutDetails defaultAccessTimeout = lockableComponent.getDefaultAccessTimeout();
        long time = defaultAccessTimeout.getValue();
        TimeUnit unit = defaultAccessTimeout.getTimeUnit();
        AccessTimeoutDetails accessTimeoutOnMethod = lockableComponent.getAccessTimeout(invokedMethod);
        if (accessTimeoutOnMethod != null) {
            if (accessTimeoutOnMethod.getValue() < 0L) {
                if (EjbLogger.ROOT_LOGGER.isDebugEnabled()) {
                    EjbLogger.ROOT_LOGGER.debug("Ignoring a negative @AccessTimeout value: " + accessTimeoutOnMethod.getValue() + " and timeout unit: " + accessTimeoutOnMethod.getTimeUnit().name() + ". Will default to timeout value: " + defaultAccessTimeout.getValue() + " and timeout unit: " + defaultAccessTimeout.getTimeUnit().name());
                }
            } else {
                time = accessTimeoutOnMethod.getValue();
                unit = accessTimeoutOnMethod.getTimeUnit();
            }
        }
        if (!(success = lock.tryLock(time, unit))) {
            throw EjbLogger.ROOT_LOGGER.concurrentAccessTimeoutException(lockableComponent.getComponentName(), time + unit.name());
        }
        try {
            Object object = invocationContext.proceed();
            return object;
        }
        finally {
            lock.unlock();
        }
    }

    private Lock getLock(SingletonComponent lockableComponent, Method method) {
        LockType lockType = lockableComponent.getLockType(method);
        switch (lockType) {
            case READ: {
                return lockableComponent.getLock().readLock();
            }
            case WRITE: {
                return lockableComponent.getLock().writeLock();
            }
        }
        throw EjbLogger.ROOT_LOGGER.failToObtainLockIllegalType(lockType, method, lockableComponent);
    }
}

