/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.interceptor.server;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.interceptor.AroundInvoke;
import javax.interceptor.AroundTimeout;
import javax.interceptor.InvocationContext;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.ee.utils.ClassLoadingUtils;
import org.jboss.as.ejb3.component.ContainerInterceptorMethodInterceptorFactory;
import org.jboss.as.ejb3.interceptor.server.ServerInterceptorMetaData;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ValueManagedReference;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.MethodInfo;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.value.CachedValue;
import org.jboss.msc.value.ConstructedValue;
import org.jboss.msc.value.Value;

public class ServerInterceptorCache {
    private final List<ServerInterceptorMetaData> serverInterceptorMetaData;
    private List<InterceptorFactory> serverInterceptorsAroundInvoke = null;
    private List<InterceptorFactory> serverInterceptorsAroundTimeout = null;

    public ServerInterceptorCache(List<ServerInterceptorMetaData> interceptorsMetaData) {
        this.serverInterceptorMetaData = interceptorsMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InterceptorFactory> getServerInterceptorsAroundInvoke() {
        ServerInterceptorCache serverInterceptorCache = this;
        synchronized (serverInterceptorCache) {
            if (this.serverInterceptorsAroundInvoke == null) {
                this.loadServerInterceptors();
            }
        }
        return this.serverInterceptorsAroundInvoke;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InterceptorFactory> getServerInterceptorsAroundTimeout() {
        ServerInterceptorCache serverInterceptorCache = this;
        synchronized (serverInterceptorCache) {
            if (this.serverInterceptorsAroundTimeout == null) {
                this.loadServerInterceptors();
            }
        }
        return this.serverInterceptorsAroundTimeout;
    }

    private void loadServerInterceptors() {
        this.serverInterceptorsAroundInvoke = new ArrayList<InterceptorFactory>();
        this.serverInterceptorsAroundTimeout = new ArrayList<InterceptorFactory>();
        for (ServerInterceptorMetaData si : this.serverInterceptorMetaData) {
            Class interceptorClass;
            String moduleId = si.getModule();
            try {
                Module module = Module.getCallerModuleLoader().loadModule(moduleId);
                interceptorClass = ClassLoadingUtils.loadClass((String)si.getClazz(), (Module)module);
            }
            catch (ModuleLoadException e) {
                throw EjbLogger.ROOT_LOGGER.cannotLoadServerInterceptorModule(moduleId, (Exception)((Object)e));
            }
            catch (ClassNotFoundException e) {
                throw EeLogger.ROOT_LOGGER.cannotLoadInterceptor((Throwable)e, si.getClazz());
            }
            Index index = this.buildIndexForClass(interceptorClass);
            this.serverInterceptorsAroundInvoke.addAll(this.findAnnotatedMethods(interceptorClass, index, AroundInvoke.class));
            this.serverInterceptorsAroundTimeout.addAll(this.findAnnotatedMethods(interceptorClass, index, AroundTimeout.class));
        }
    }

    private Index buildIndexForClass(Class<?> interceptorClass) {
        try {
            String classNameAsResource = interceptorClass.getName().replaceAll("\\.", "/").concat(".class");
            InputStream stream = interceptorClass.getClassLoader().getResourceAsStream(classNameAsResource);
            Indexer indexer = new Indexer();
            indexer.index(stream);
            stream.close();
            return indexer.complete();
        }
        catch (IOException e) {
            throw EjbLogger.ROOT_LOGGER.cannotBuildIndexForServerInterceptor(interceptorClass.getName(), e);
        }
    }

    private List<InterceptorFactory> findAnnotatedMethods(Class<?> interceptorClass, Index index, Class<?> annotationClass) {
        ArrayList<InterceptorFactory> interceptorFactories = new ArrayList<InterceptorFactory>();
        DotName annotationName = DotName.createSimple((String)annotationClass.getName());
        List annotations = index.getAnnotations(annotationName);
        for (AnnotationInstance annotation : annotations) {
            Constructor<?> constructor;
            if (annotation.target().kind() != AnnotationTarget.Kind.METHOD) continue;
            MethodInfo methodInfo = annotation.target().asMethod();
            try {
                constructor = interceptorClass.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw EjbLogger.ROOT_LOGGER.serverInterceptorNoEmptyConstructor(interceptorClass.toString(), e);
            }
            try {
                Method annotatedMethod = interceptorClass.getMethod(methodInfo.name(), InvocationContext.class);
                InterceptorFactory interceptorFactory = this.createInterceptorFactoryForServerInterceptor(annotatedMethod, constructor);
                interceptorFactories.add(interceptorFactory);
            }
            catch (NoSuchMethodException e) {
                throw EjbLogger.ROOT_LOGGER.serverInterceptorInvalidMethod(methodInfo.name(), interceptorClass.toString(), annotationClass.toString(), e);
            }
        }
        return interceptorFactories;
    }

    private InterceptorFactory createInterceptorFactoryForServerInterceptor(Method method, Constructor interceptorConstructor) {
        ConstructedValue interceptorInstanceValue = new ConstructedValue(interceptorConstructor, Collections.emptyList());
        CachedValue cachedInterceptorInstanceValue = new CachedValue((Value)interceptorInstanceValue);
        ValueManagedReference interceptorInstanceRef = new ValueManagedReference((Value)cachedInterceptorInstanceValue);
        return new ContainerInterceptorMethodInterceptorFactory((ManagedReference)interceptorInstanceRef, method);
    }
}

