/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice;

import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.ejb.TimerConfig;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.timerservice.NonFunctionalTimerService;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimerService;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimerServiceConfiguration;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimerServiceFactory;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimerServiceFactoryConfiguration;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvokerFactory;
import org.jboss.as.ejb3.timerservice.spi.TimerListener;
import org.jboss.as.ejb3.timerservice.spi.TimerServiceRegistry;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.SimpleServiceNameProvider;

public class NonFunctionalTimerServiceFactoryServiceConfigurator
extends SimpleServiceNameProvider
implements ServiceConfigurator,
ManagedTimerServiceFactory {
    private final String message;
    private final TimerServiceRegistry registry;
    private final TimedObjectInvokerFactory invokerFactory;
    private final TimerListener listener;

    public NonFunctionalTimerServiceFactoryServiceConfigurator(ServiceName name, String message, ManagedTimerServiceFactoryConfiguration configuration) {
        super(name);
        this.message = message;
        this.invokerFactory = configuration.getInvokerFactory();
        this.registry = configuration.getTimerServiceRegistry();
        this.listener = configuration.getTimerListener();
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceName name = this.getServiceName();
        ServiceBuilder builder = target.addService(name);
        return builder.setInstance(Service.newInstance((Consumer)builder.provides(new ServiceName[]{name}), (Object)this));
    }

    @Override
    public ManagedTimerService createTimerService(EJBComponent component) {
        final TimedObjectInvoker invoker = this.invokerFactory.createInvoker(component);
        final TimerServiceRegistry registry = this.registry;
        final TimerListener listener = this.listener;
        return new NonFunctionalTimerService(this.message, new ManagedTimerServiceConfiguration(){

            @Override
            public TimedObjectInvoker getInvoker() {
                return invoker;
            }

            @Override
            public TimerServiceRegistry getTimerServiceRegistry() {
                return registry;
            }

            @Override
            public TimerListener getTimerListener() {
                return listener;
            }

            @Override
            public Predicate<TimerConfig> getTimerFilter() {
                return ManagedTimerServiceConfiguration.TimerFilter.ALL;
            }
        });
    }
}

