/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.dmr.ModelNode;

public class EJB3SubsystemRemove
extends AbstractRemoveStepHandler {
    public static final EJB3SubsystemRemove INSTANCE = new EJB3SubsystemRemove();

    private EJB3SubsystemRemove() {
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        ModelNode model = resource.getModel();
        if (model.hasDefined("default-slsb-instance-pool")) {
            context.deregisterCapability("org.wildfly.ejb3.pool-config.slsb-default");
            try {
                String resolvedDefaultSLSBPoolName = context.resolveExpressions(model.get("default-slsb-instance-pool")).asString();
                String defaultSLSBPoolRequirementName = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.ejb3.pool-config", (String)resolvedDefaultSLSBPoolName);
                context.deregisterCapabilityRequirement(defaultSLSBPoolRequirementName, "org.wildfly.ejb3.pool-config.slsb-default", "default-slsb-instance-pool");
            }
            catch (OperationFailedException ofe) {
                EjbLogger.ROOT_LOGGER.defaultPoolExpressionCouldNotBeResolved("default-slsb-instance-pool", model.get("default-slsb-instance-pool").asString());
            }
        }
        if (model.hasDefined("default-mdb-instance-pool")) {
            context.deregisterCapability("org.wildfly.ejb3.pool-config.mdb-default");
            try {
                String resolvedDefaultMDBPoolName = context.resolveExpressions(model.get("default-mdb-instance-pool")).asString();
                String defaultMDBPoolRequirementName = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.ejb3.pool-config", (String)resolvedDefaultMDBPoolName);
                context.deregisterCapabilityRequirement(defaultMDBPoolRequirementName, "org.wildfly.ejb3.pool-config.mdb-default", "default-mdb-instance-pool");
            }
            catch (OperationFailedException ofe) {
                EjbLogger.ROOT_LOGGER.defaultPoolExpressionCouldNotBeResolved("default-mdb-instance-pool", model.get("default-mdb-instance-pool").asString());
            }
        }
        super.recordCapabilitiesAndRequirements(context, operation, resource);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        context.reloadRequired();
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        context.revertReloadRequired();
    }
}

