/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.merging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.metadata.ClassAnnotationInformation;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentDescription;
import org.jboss.as.ejb3.delivery.metadata.EJBBoundMdbDeliveryMetaData;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.processors.merging.AbstractMergingProcessor;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.ejb3.annotation.DeliveryActive;
import org.jboss.ejb3.annotation.DeliveryGroup;
import org.jboss.metadata.ejb.spec.AssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;

public class MdbDeliveryMergingProcessor
extends AbstractMergingProcessor<MessageDrivenComponentDescription> {
    public MdbDeliveryMergingProcessor() {
        super(MessageDrivenComponentDescription.class);
    }

    @Override
    protected void handleAnnotations(DeploymentUnit deploymentUnit, EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, MessageDrivenComponentDescription componentConfiguration) throws DeploymentUnitProcessingException {
        List deliveryGroups;
        ClassAnnotationInformation deliveryGroup;
        EEModuleClassDescription clazz = applicationClasses.getClassByName(componentClass.getName());
        if (clazz == null) {
            return;
        }
        ClassAnnotationInformation deliveryActive = clazz.getAnnotationInformation(DeliveryActive.class);
        if (deliveryActive != null && !deliveryActive.getClassLevelAnnotations().isEmpty()) {
            componentConfiguration.setDeliveryActive((Boolean)deliveryActive.getClassLevelAnnotations().get(0));
        }
        if ((deliveryGroup = clazz.getAnnotationInformation(DeliveryGroup.class)) != null && !(deliveryGroups = deliveryGroup.getClassLevelAnnotations()).isEmpty()) {
            componentConfiguration.setDeliveryGroup(deliveryGroups.toArray(new String[deliveryGroups.size()]));
        }
    }

    @Override
    protected void handleDeploymentDescriptor(DeploymentUnit deploymentUnit, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, MessageDrivenComponentDescription componentConfiguration) throws DeploymentUnitProcessingException {
        String ejbName = componentConfiguration.getEJBName();
        EjbJarMetaData metaData = (EjbJarMetaData)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        if (metaData == null) {
            return;
        }
        AssemblyDescriptorMetaData assemblyDescriptor = metaData.getAssemblyDescriptor();
        if (assemblyDescriptor == null) {
            return;
        }
        Boolean deliveryActive = null;
        String[] deliveryGroups = null;
        List deliveryMetaDataList = assemblyDescriptor.getAny(EJBBoundMdbDeliveryMetaData.class);
        if (deliveryMetaDataList != null) {
            for (EJBBoundMdbDeliveryMetaData deliveryMetaData : deliveryMetaDataList) {
                if ("*".equals(deliveryMetaData.getEjbName())) {
                    if (deliveryActive == null) {
                        deliveryActive = deliveryMetaData.isDeliveryActive();
                    }
                    deliveryGroups = this.mergeDeliveryGroups(deliveryGroups, deliveryMetaData.getDeliveryGroups());
                    continue;
                }
                if (!ejbName.equals(deliveryMetaData.getEjbName())) continue;
                deliveryActive = deliveryMetaData.isDeliveryActive();
                deliveryGroups = this.mergeDeliveryGroups(deliveryGroups, deliveryMetaData.getDeliveryGroups());
            }
        }
        if (deliveryGroups != null && deliveryGroups.length > 0) {
            componentConfiguration.setDeliveryGroup(deliveryGroups);
        } else if (deliveryActive != null) {
            componentConfiguration.setDeliveryActive(deliveryActive);
        }
    }

    private final String[] mergeDeliveryGroups(String[] deliveryGroups1, String[] deliveryGroups2) {
        if (deliveryGroups1 == null) {
            return deliveryGroups2;
        }
        if (deliveryGroups2 == null) {
            return deliveryGroups1;
        }
        ArrayList deliveryGroupList = new ArrayList(deliveryGroups1.length + deliveryGroups2.length);
        Collections.addAll(deliveryGroupList, deliveryGroups1);
        Collections.addAll(deliveryGroupList, deliveryGroups2);
        return deliveryGroupList.toArray(new String[deliveryGroupList.size()]);
    }
}

