/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ValueManagedReference;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.ejb.client.SessionID;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.invocation.SimpleInterceptorFactoryContext;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public class SerializedStatefulSessionComponent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String serviceName;
    private final SessionID sessionID;
    private final Map<Object, Object> serializableInterceptors;
    private final ManagedReference instance;

    public SerializedStatefulSessionComponent(ManagedReference instance, SessionID sessionID, String serviceName, Map<Object, Object> serializableInterceptors) {
        this.instance = instance;
        this.sessionID = sessionID;
        this.serviceName = serviceName;
        this.serializableInterceptors = serializableInterceptors;
    }

    private Object readResolve() throws ObjectStreamException {
        ServiceName name = ServiceName.parse((String)this.serviceName);
        ServiceController service = SerializedStatefulSessionComponent.currentServiceContainer().getRequiredService(name);
        StatefulSessionComponent component = (StatefulSessionComponent)service.getValue();
        SimpleInterceptorFactoryContext context = new SimpleInterceptorFactoryContext();
        for (Map.Entry<Object, Object> entry : this.serializableInterceptors.entrySet()) {
            AtomicReference<ValueManagedReference> referenceReference = new AtomicReference<ValueManagedReference>(new ValueManagedReference((Value)new ImmediateValue(entry.getValue())));
            context.getContextData().put(entry.getKey(), referenceReference);
        }
        context.getContextData().put(SessionID.class, this.sessionID);
        return component.constructComponentInstance(this.instance, false, (InterceptorFactoryContext)context);
    }

    private static ServiceContainer currentServiceContainer() {
        return AccessController.doPrivileged(new PrivilegedAction<ServiceContainer>(){

            @Override
            public ServiceContainer run() {
                return CurrentServiceContainer.getServiceContainer();
            }
        });
    }
}

