/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.Collection;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;

public class EJBDefaultSecurityDomainProcessor
implements DeploymentUnitProcessor {
    private volatile String defaultSecurityDomainName;

    public EJBDefaultSecurityDomainProcessor(String defaultSecurityDomainName) {
        this.defaultSecurityDomainName = defaultSecurityDomainName;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (eeModuleDescription == null) {
            return;
        }
        Collection componentDescriptions = eeModuleDescription.getComponentDescriptions();
        if (componentDescriptions == null || componentDescriptions.isEmpty()) {
            return;
        }
        for (ComponentDescription componentDescription : componentDescriptions) {
            if (!(componentDescription instanceof EJBComponentDescription)) continue;
            ((EJBComponentDescription)componentDescription).setDefaultSecurityDomain(this.defaultSecurityDomainName);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    public void setDefaultSecurityDomainName(String securityDomainName) {
        this.defaultSecurityDomainName = securityDomainName;
    }
}

