/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote.protocol.versionone;

import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinateTransaction;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinationManager;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.remote.EJBRemoteTransactionsRepository;
import org.jboss.as.ejb3.remote.protocol.versionone.ChannelAssociation;
import org.jboss.as.ejb3.remote.protocol.versionone.TransactionRequestHandler;
import org.jboss.as.ejb3.remote.protocol.versionone.XidTransactionManagementTask;
import org.jboss.ejb.client.XidTransactionID;
import org.jboss.marshalling.MarshallerFactory;

class XidTransactionForgetTask
extends XidTransactionManagementTask {
    XidTransactionForgetTask(TransactionRequestHandler txRequestHandler, EJBRemoteTransactionsRepository transactionsRepository, MarshallerFactory marshallerFactory, XidTransactionID xidTransactionID, ChannelAssociation channelAssociation, short invocationId) {
        super(txRequestHandler, transactionsRepository, marshallerFactory, xidTransactionID, channelAssociation, invocationId);
    }

    @Override
    protected void manageTransaction() throws Throwable {
        SubordinateTransaction recoveredTransaction;
        SubordinateTransaction transaction = this.transactionsRepository.getImportedTransaction(this.xidTransactionID);
        if (transaction == null && (recoveredTransaction = this.tryRecoveryForImportedTransaction()) == null) {
            if (EjbLogger.EJB3_INVOCATION_LOGGER.isDebugEnabled()) {
                EjbLogger.EJB3_INVOCATION_LOGGER.debug("Not forgetting " + this.xidTransactionID + " as is was not found on the server");
            }
            return;
        }
        this.resumeTransaction((Transaction)transaction);
        Xid xid = this.xidTransactionID.getXid();
        try {
            SubordinateTransaction subordinateTransaction = SubordinationManager.getTransactionImporter().getImportedTransaction(xid);
            if (subordinateTransaction == null) {
                throw new XAException(-5);
            }
            subordinateTransaction.doForget();
        }
        catch (Exception ex) {
            XAException xaException = new XAException(-3);
            xaException.initCause(ex);
            throw xaException;
        }
        finally {
            SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
            this.transactionsRepository.getTransactionManager().suspend();
        }
    }
}

