/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.security.ServerSecurityManager;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInterceptorFactory;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.security.EJBSecurityMetaData;
import org.jboss.as.ejb3.security.SecurityContextInterceptor;
import org.jboss.as.ejb3.security.SecurityContextInterceptorHolder;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;

public class SecurityContextInterceptorFactory
extends ComponentInterceptorFactory {
    private static final String DEFAULT_DOMAIN = "other";
    private final boolean securityRequired;

    public SecurityContextInterceptorFactory(boolean securityRequired) {
        this.securityRequired = securityRequired;
    }

    protected Interceptor create(Component component, InterceptorFactoryContext context) {
        if (!(component instanceof EJBComponent)) {
            throw EjbMessages.MESSAGES.unexpectedComponent(component, EJBComponent.class);
        }
        EJBComponent ejbComponent = (EJBComponent)component;
        ServerSecurityManager securityManager = ejbComponent.getSecurityManager();
        EJBSecurityMetaData securityMetaData = ejbComponent.getSecurityMetaData();
        String securityDomain = securityMetaData.getSecurityDomain();
        if (securityDomain == null) {
            securityDomain = DEFAULT_DOMAIN;
        }
        if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
            EjbLogger.ROOT_LOGGER.trace("Using security domain: " + securityDomain + " for EJB " + ejbComponent.getComponentName());
        }
        String runAs = securityMetaData.getRunAs();
        String runAsPrincipal = securityMetaData.getRunAsPrincipal();
        SecurityRolesMetaData securityRoles = securityMetaData.getSecurityRoles();
        Set extraRoles = null;
        Map principalVsRolesMap = null;
        if (securityRoles != null) {
            principalVsRolesMap = securityRoles.getPrincipalVersusRolesMap();
            if (runAsPrincipal != null) {
                extraRoles = securityRoles.getSecurityRoleNamesByPrincipal(runAsPrincipal);
            }
        }
        SecurityContextInterceptorHolder holder = new SecurityContextInterceptorHolder();
        holder.setSecurityManager(securityManager).setSecurityDomain(securityDomain).setRunAs(runAs).setRunAsPrincipal(runAsPrincipal).setExtraRoles(extraRoles).setPrincipalVsRolesMap(principalVsRolesMap).setSkipAuthentication(!this.securityRequired);
        return new SecurityContextInterceptor(holder);
    }
}

